package software.amazon.awscdk.services.oam;

/**
 * Properties for defining a <code>CfnLink</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.oam.*;
 * CfnLinkProps cfnLinkProps = CfnLinkProps.builder()
 *         .resourceTypes(List.of("resourceTypes"))
 *         .sinkIdentifier("sinkIdentifier")
 *         // the properties below are optional
 *         .labelTemplate("labelTemplate")
 *         .linkConfiguration(LinkConfigurationProperty.builder()
 *                 .logGroupConfiguration(LinkFilterProperty.builder()
 *                         .filter("filter")
 *                         .build())
 *                 .metricConfiguration(LinkFilterProperty.builder()
 *                         .filter("filter")
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:16.785Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_oam.CfnLinkProps")
@software.amazon.jsii.Jsii.Proxy(CfnLinkProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLinkProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of strings that define which types of data that the source account shares with the monitoring account.
     * <p>
     * Valid values are <code>AWS::CloudWatch::Metric | AWS::Logs::LogGroup | AWS::XRay::Trace | AWS::ApplicationInsights::Application | AWS::InternetMonitor::Monitor | AWS::ApplicationSignals::Service | AWS::ApplicationSignals::ServiceLevelObjective</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-resourcetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-resourcetypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceTypes();

    /**
     * The ARN of the sink in the monitoring account that you want to link to.
     * <p>
     * You can use <a href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html">ListSinks</a> to find the ARNs of sinks.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-sinkidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-sinkidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSinkIdentifier();

    /**
     * Specify a friendly human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     * <p>
     * You can include the following variables in your template:
     * <p>
     * <ul>
     * <li><code>$AccountName</code> is the name of the account</li>
     * <li><code>$AccountEmail</code> is a globally-unique email address, which includes the email domain, such as <code>mariagarcia&#64;example.com</code></li>
     * <li><code>$AccountEmailNoDomain</code> is an email address without the domain name, such as <code>mariagarcia</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-labeltemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-labeltemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabelTemplate() {
        return null;
    }

    /**
     * Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-linkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-linkconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLinkConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to the link.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-oam-link.html#cfn-oam-link-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLinkProps> {
        java.util.List<java.lang.String> resourceTypes;
        java.lang.String sinkIdentifier;
        java.lang.String labelTemplate;
        java.lang.Object linkConfiguration;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnLinkProps#getResourceTypes}
         * @param resourceTypes An array of strings that define which types of data that the source account shares with the monitoring account. This parameter is required.
         *                      Valid values are <code>AWS::CloudWatch::Metric | AWS::Logs::LogGroup | AWS::XRay::Trace | AWS::ApplicationInsights::Application | AWS::InternetMonitor::Monitor | AWS::ApplicationSignals::Service | AWS::ApplicationSignals::ServiceLevelObjective</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTypes(java.util.List<java.lang.String> resourceTypes) {
            this.resourceTypes = resourceTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getSinkIdentifier}
         * @param sinkIdentifier The ARN of the sink in the monitoring account that you want to link to. This parameter is required.
         *                       You can use <a href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html">ListSinks</a> to find the ARNs of sinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sinkIdentifier(java.lang.String sinkIdentifier) {
            this.sinkIdentifier = sinkIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getLabelTemplate}
         * @param labelTemplate Specify a friendly human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
         *                      You can include the following variables in your template:
         *                      <p>
         *                      <ul>
         *                      <li><code>$AccountName</code> is the name of the account</li>
         *                      <li><code>$AccountEmail</code> is a globally-unique email address, which includes the email domain, such as <code>mariagarcia&#64;example.com</code></li>
         *                      <li><code>$AccountEmailNoDomain</code> is an email address without the domain name, such as <code>mariagarcia</code></li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labelTemplate(java.lang.String labelTemplate) {
            this.labelTemplate = labelTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getLinkConfiguration}
         * @param linkConfiguration Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkConfiguration(software.amazon.awscdk.IResolvable linkConfiguration) {
            this.linkConfiguration = linkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getLinkConfiguration}
         * @param linkConfiguration Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkConfiguration(software.amazon.awscdk.services.oam.CfnLink.LinkConfigurationProperty linkConfiguration) {
            this.linkConfiguration = linkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getTags}
         * @param tags An array of key-value pairs to apply to the link.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLinkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLinkProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLinkProps {
        private final java.util.List<java.lang.String> resourceTypes;
        private final java.lang.String sinkIdentifier;
        private final java.lang.String labelTemplate;
        private final java.lang.Object linkConfiguration;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceTypes = software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sinkIdentifier = software.amazon.jsii.Kernel.get(this, "sinkIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labelTemplate = software.amazon.jsii.Kernel.get(this, "labelTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.linkConfiguration = software.amazon.jsii.Kernel.get(this, "linkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceTypes = java.util.Objects.requireNonNull(builder.resourceTypes, "resourceTypes is required");
            this.sinkIdentifier = java.util.Objects.requireNonNull(builder.sinkIdentifier, "sinkIdentifier is required");
            this.labelTemplate = builder.labelTemplate;
            this.linkConfiguration = builder.linkConfiguration;
            this.tags = builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final java.lang.String getSinkIdentifier() {
            return this.sinkIdentifier;
        }

        @Override
        public final java.lang.String getLabelTemplate() {
            return this.labelTemplate;
        }

        @Override
        public final java.lang.Object getLinkConfiguration() {
            return this.linkConfiguration;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceTypes", om.valueToTree(this.getResourceTypes()));
            data.set("sinkIdentifier", om.valueToTree(this.getSinkIdentifier()));
            if (this.getLabelTemplate() != null) {
                data.set("labelTemplate", om.valueToTree(this.getLabelTemplate()));
            }
            if (this.getLinkConfiguration() != null) {
                data.set("linkConfiguration", om.valueToTree(this.getLinkConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_oam.CfnLinkProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLinkProps.Jsii$Proxy that = (CfnLinkProps.Jsii$Proxy) o;

            if (!resourceTypes.equals(that.resourceTypes)) return false;
            if (!sinkIdentifier.equals(that.sinkIdentifier)) return false;
            if (this.labelTemplate != null ? !this.labelTemplate.equals(that.labelTemplate) : that.labelTemplate != null) return false;
            if (this.linkConfiguration != null ? !this.linkConfiguration.equals(that.linkConfiguration) : that.linkConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourceTypes.hashCode();
            result = 31 * result + (this.sinkIdentifier.hashCode());
            result = 31 * result + (this.labelTemplate != null ? this.labelTemplate.hashCode() : 0);
            result = 31 * result + (this.linkConfiguration != null ? this.linkConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
