package software.amazon.awscdk.services.notifications;

/**
 * Properties for defining a <code>CfnManagedNotificationAccountContactAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.notifications.*;
 * CfnManagedNotificationAccountContactAssociationProps cfnManagedNotificationAccountContactAssociationProps = CfnManagedNotificationAccountContactAssociationProps.builder()
 *         .contactIdentifier("contactIdentifier")
 *         .managedNotificationConfigurationArn("managedNotificationConfigurationArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationaccountcontactassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationaccountcontactassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:16.761Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_notifications.CfnManagedNotificationAccountContactAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnManagedNotificationAccountContactAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnManagedNotificationAccountContactAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier of the notification contact associated with the AWS account.
     * <p>
     * For more information about the contact types associated with an account, see the <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact-alternate.html#manage-acct-update-contact-alternate-orgs">Account Management Reference Guide</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationaccountcontactassociation.html#cfn-notifications-managednotificationaccountcontactassociation-contactidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationaccountcontactassociation.html#cfn-notifications-managednotificationaccountcontactassociation-contactidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContactIdentifier();

    /**
     * The ARN of the <code>ManagedNotificationConfiguration</code> to be associated with the <code>Channel</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationaccountcontactassociation.html#cfn-notifications-managednotificationaccountcontactassociation-managednotificationconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationaccountcontactassociation.html#cfn-notifications-managednotificationaccountcontactassociation-managednotificationconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getManagedNotificationConfigurationArn();

    /**
     * @return a {@link Builder} of {@link CfnManagedNotificationAccountContactAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnManagedNotificationAccountContactAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnManagedNotificationAccountContactAssociationProps> {
        java.lang.String contactIdentifier;
        java.lang.String managedNotificationConfigurationArn;

        /**
         * Sets the value of {@link CfnManagedNotificationAccountContactAssociationProps#getContactIdentifier}
         * @param contactIdentifier The unique identifier of the notification contact associated with the AWS account. This parameter is required.
         *                          For more information about the contact types associated with an account, see the <a href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact-alternate.html#manage-acct-update-contact-alternate-orgs">Account Management Reference Guide</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactIdentifier(java.lang.String contactIdentifier) {
            this.contactIdentifier = contactIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedNotificationAccountContactAssociationProps#getManagedNotificationConfigurationArn}
         * @param managedNotificationConfigurationArn The ARN of the <code>ManagedNotificationConfiguration</code> to be associated with the <code>Channel</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedNotificationConfigurationArn(java.lang.String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnManagedNotificationAccountContactAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnManagedNotificationAccountContactAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnManagedNotificationAccountContactAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnManagedNotificationAccountContactAssociationProps {
        private final java.lang.String contactIdentifier;
        private final java.lang.String managedNotificationConfigurationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contactIdentifier = software.amazon.jsii.Kernel.get(this, "contactIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.managedNotificationConfigurationArn = software.amazon.jsii.Kernel.get(this, "managedNotificationConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contactIdentifier = java.util.Objects.requireNonNull(builder.contactIdentifier, "contactIdentifier is required");
            this.managedNotificationConfigurationArn = java.util.Objects.requireNonNull(builder.managedNotificationConfigurationArn, "managedNotificationConfigurationArn is required");
        }

        @Override
        public final java.lang.String getContactIdentifier() {
            return this.contactIdentifier;
        }

        @Override
        public final java.lang.String getManagedNotificationConfigurationArn() {
            return this.managedNotificationConfigurationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("contactIdentifier", om.valueToTree(this.getContactIdentifier()));
            data.set("managedNotificationConfigurationArn", om.valueToTree(this.getManagedNotificationConfigurationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_notifications.CfnManagedNotificationAccountContactAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnManagedNotificationAccountContactAssociationProps.Jsii$Proxy that = (CfnManagedNotificationAccountContactAssociationProps.Jsii$Proxy) o;

            if (!contactIdentifier.equals(that.contactIdentifier)) return false;
            return this.managedNotificationConfigurationArn.equals(that.managedNotificationConfigurationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.contactIdentifier.hashCode();
            result = 31 * result + (this.managedNotificationConfigurationArn.hashCode());
            return result;
        }
    }
}
