package software.amazon.awscdk.services.mediastore;

/**
 * Properties for defining a <code>CfnContainer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediastore.*;
 * CfnContainerProps cfnContainerProps = CfnContainerProps.builder()
 *         .containerName("containerName")
 *         // the properties below are optional
 *         .accessLoggingEnabled(false)
 *         .corsPolicy(List.of(CorsRuleProperty.builder()
 *                 .allowedHeaders(List.of("allowedHeaders"))
 *                 .allowedMethods(List.of("allowedMethods"))
 *                 .allowedOrigins(List.of("allowedOrigins"))
 *                 .exposeHeaders(List.of("exposeHeaders"))
 *                 .maxAgeSeconds(123)
 *                 .build()))
 *         .lifecyclePolicy("lifecyclePolicy")
 *         .metricPolicy(MetricPolicyProperty.builder()
 *                 .containerLevelMetrics("containerLevelMetrics")
 *                 // the properties below are optional
 *                 .metricPolicyRules(List.of(MetricPolicyRuleProperty.builder()
 *                         .objectGroup("objectGroup")
 *                         .objectGroupName("objectGroupName")
 *                         .build()))
 *                 .build())
 *         .policy("policy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:16.493Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediastore.CfnContainerProps")
@software.amazon.jsii.Jsii.Proxy(CfnContainerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnContainerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name for the container.
     * <p>
     * The name must be from 1 to 255 characters. Container names must be unique to your AWS account within a specific region. As an example, you could create a container named <code>movies</code> in every region, as long as you don’t have an existing container with that name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-containername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

    /**
     * The state of access logging on the container.
     * <p>
     * This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code> , indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLoggingEnabled() {
        return null;
    }

    /**
     * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
     * <p>
     * After November 13, 2025, you will no longer be able to access the AWS Elemental MediaStore console or AWS Elemental MediaStore resources. For more information, visit this <a href="https://docs.aws.amazon.com/media/support-for-aws-elemental-mediastore-ending-soon/">blog post</a> .
     * <p>
     * Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability.
     * <p>
     * To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
     * <p>
     * To learn more about CORS, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCorsPolicy() {
        return null;
    }

    /**
     * <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
     * <p>
     * After November 13, 2025, you will no longer be able to access the AWS Elemental MediaStore console or AWS Elemental MediaStore resources. For more information, visit this <a href="https://docs.aws.amazon.com/media/support-for-aws-elemental-mediastore-ending-soon/">blog post</a> .
     * <p>
     * Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take effect.
     * <p>
     * For information about how to construct an object lifecycle policy, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html">Components of an Object Lifecycle Policy</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-lifecyclepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-lifecyclepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLifecyclePolicy() {
        return null;
    }

    /**
     * The metric policy that is associated with the container.
     * <p>
     * A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.
     * <p>
     * To view examples of how to construct a metric policy for your use case, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html">Example Metric Policies</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetricPolicy() {
        return null;
    }

    /**
     * Creates an access policy for the specified container to restrict the users and clients that can access it.
     * <p>
     * For information about the data that is included in an access policy, see the <a href="https://docs.aws.amazon.com/iam/">AWS Identity and Access Management User Guide</a> .
     * <p>
     * For this release of the REST API, you can create only one policy for a container. If you enter <code>PutContainerPolicy</code> twice, the second command modifies the existing policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-policy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicy() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnContainerProps> {
        java.lang.String containerName;
        java.lang.Object accessLoggingEnabled;
        java.lang.Object corsPolicy;
        java.lang.String lifecyclePolicy;
        java.lang.Object metricPolicy;
        java.lang.String policy;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnContainerProps#getContainerName}
         * @param containerName The name for the container. This parameter is required.
         *                      The name must be from 1 to 255 characters. Container names must be unique to your AWS account within a specific region. As an example, you could create a container named <code>movies</code> in every region, as long as you don’t have an existing container with that name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(java.lang.String containerName) {
            this.containerName = containerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getAccessLoggingEnabled}
         * @param accessLoggingEnabled The state of access logging on the container.
         *                             This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code> , indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingEnabled(java.lang.Boolean accessLoggingEnabled) {
            this.accessLoggingEnabled = accessLoggingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getAccessLoggingEnabled}
         * @param accessLoggingEnabled The state of access logging on the container.
         *                             This value is <code>false</code> by default, indicating that AWS Elemental MediaStore does not send access logs to Amazon CloudWatch Logs. When you enable access logging on the container, MediaStore changes this value to <code>true</code> , indicating that the service delivers access logs for objects stored in that container to CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingEnabled(software.amazon.awscdk.IResolvable accessLoggingEnabled) {
            this.accessLoggingEnabled = accessLoggingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getCorsPolicy}
         * @param corsPolicy <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
         *                   After November 13, 2025, you will no longer be able to access the AWS Elemental MediaStore console or AWS Elemental MediaStore resources. For more information, visit this <a href="https://docs.aws.amazon.com/media/support-for-aws-elemental-mediastore-ending-soon/">blog post</a> .
         *                   <p>
         *                   Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability.
         *                   <p>
         *                   To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
         *                   <p>
         *                   To learn more about CORS, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsPolicy(software.amazon.awscdk.IResolvable corsPolicy) {
            this.corsPolicy = corsPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getCorsPolicy}
         * @param corsPolicy <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
         *                   After November 13, 2025, you will no longer be able to access the AWS Elemental MediaStore console or AWS Elemental MediaStore resources. For more information, visit this <a href="https://docs.aws.amazon.com/media/support-for-aws-elemental-mediastore-ending-soon/">blog post</a> .
         *                   <p>
         *                   Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability.
         *                   <p>
         *                   To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed.
         *                   <p>
         *                   To learn more about CORS, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsPolicy(java.util.List<? extends java.lang.Object> corsPolicy) {
            this.corsPolicy = corsPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getLifecyclePolicy}
         * @param lifecyclePolicy <blockquote><p>End of support notice: On November 13, 2025, AWS will discontinue support for AWS Elemental MediaStore.<p></blockquote>
         *                        After November 13, 2025, you will no longer be able to access the AWS Elemental MediaStore console or AWS Elemental MediaStore resources. For more information, visit this <a href="https://docs.aws.amazon.com/media/support-for-aws-elemental-mediastore-ending-soon/">blog post</a> .
         *                        <p>
         *                        Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take effect.
         *                        <p>
         *                        For information about how to construct an object lifecycle policy, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html">Components of an Object Lifecycle Policy</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicy(java.lang.String lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getMetricPolicy}
         * @param metricPolicy The metric policy that is associated with the container.
         *                     A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.
         *                     <p>
         *                     To view examples of how to construct a metric policy for your use case, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html">Example Metric Policies</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricPolicy(software.amazon.awscdk.IResolvable metricPolicy) {
            this.metricPolicy = metricPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getMetricPolicy}
         * @param metricPolicy The metric policy that is associated with the container.
         *                     A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include rules to define groups of objects that you want MediaStore to send object-level metrics for.
         *                     <p>
         *                     To view examples of how to construct a metric policy for your use case, see <a href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html">Example Metric Policies</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricPolicy(software.amazon.awscdk.services.mediastore.CfnContainer.MetricPolicyProperty metricPolicy) {
            this.metricPolicy = metricPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getPolicy}
         * @param policy Creates an access policy for the specified container to restrict the users and clients that can access it.
         *               For information about the data that is included in an access policy, see the <a href="https://docs.aws.amazon.com/iam/">AWS Identity and Access Management User Guide</a> .
         *               <p>
         *               For this release of the REST API, you can create only one policy for a container. If you enter <code>PutContainerPolicy</code> twice, the second command modifies the existing policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.String policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnContainerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnContainerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnContainerProps {
        private final java.lang.String containerName;
        private final java.lang.Object accessLoggingEnabled;
        private final java.lang.Object corsPolicy;
        private final java.lang.String lifecyclePolicy;
        private final java.lang.Object metricPolicy;
        private final java.lang.String policy;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessLoggingEnabled = software.amazon.jsii.Kernel.get(this, "accessLoggingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.corsPolicy = software.amazon.jsii.Kernel.get(this, "corsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lifecyclePolicy = software.amazon.jsii.Kernel.get(this, "lifecyclePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricPolicy = software.amazon.jsii.Kernel.get(this, "metricPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
            this.accessLoggingEnabled = builder.accessLoggingEnabled;
            this.corsPolicy = builder.corsPolicy;
            this.lifecyclePolicy = builder.lifecyclePolicy;
            this.metricPolicy = builder.metricPolicy;
            this.policy = builder.policy;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getContainerName() {
            return this.containerName;
        }

        @Override
        public final java.lang.Object getAccessLoggingEnabled() {
            return this.accessLoggingEnabled;
        }

        @Override
        public final java.lang.Object getCorsPolicy() {
            return this.corsPolicy;
        }

        @Override
        public final java.lang.String getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        @Override
        public final java.lang.Object getMetricPolicy() {
            return this.metricPolicy;
        }

        @Override
        public final java.lang.String getPolicy() {
            return this.policy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerName", om.valueToTree(this.getContainerName()));
            if (this.getAccessLoggingEnabled() != null) {
                data.set("accessLoggingEnabled", om.valueToTree(this.getAccessLoggingEnabled()));
            }
            if (this.getCorsPolicy() != null) {
                data.set("corsPolicy", om.valueToTree(this.getCorsPolicy()));
            }
            if (this.getLifecyclePolicy() != null) {
                data.set("lifecyclePolicy", om.valueToTree(this.getLifecyclePolicy()));
            }
            if (this.getMetricPolicy() != null) {
                data.set("metricPolicy", om.valueToTree(this.getMetricPolicy()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediastore.CfnContainerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnContainerProps.Jsii$Proxy that = (CfnContainerProps.Jsii$Proxy) o;

            if (!containerName.equals(that.containerName)) return false;
            if (this.accessLoggingEnabled != null ? !this.accessLoggingEnabled.equals(that.accessLoggingEnabled) : that.accessLoggingEnabled != null) return false;
            if (this.corsPolicy != null ? !this.corsPolicy.equals(that.corsPolicy) : that.corsPolicy != null) return false;
            if (this.lifecyclePolicy != null ? !this.lifecyclePolicy.equals(that.lifecyclePolicy) : that.lifecyclePolicy != null) return false;
            if (this.metricPolicy != null ? !this.metricPolicy.equals(that.metricPolicy) : that.metricPolicy != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerName.hashCode();
            result = 31 * result + (this.accessLoggingEnabled != null ? this.accessLoggingEnabled.hashCode() : 0);
            result = 31 * result + (this.corsPolicy != null ? this.corsPolicy.hashCode() : 0);
            result = 31 * result + (this.lifecyclePolicy != null ? this.lifecyclePolicy.hashCode() : 0);
            result = 31 * result + (this.metricPolicy != null ? this.metricPolicy.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
