package software.amazon.awscdk.services.lakeformation;

/**
 * Properties for defining a <code>CfnDataLakeSettings</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.glue.alpha.S3Table;
 * import software.amazon.awscdk.services.glue.alpha.Database;
 * import software.amazon.awscdk.services.glue.alpha.DataFormat;
 * import software.amazon.awscdk.services.glue.alpha.Schema;
 * import software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings;
 * import software.amazon.awscdk.services.lakeformation.CfnTag;
 * import software.amazon.awscdk.services.lakeformation.CfnTagAssociation;
 * Stack stack;
 * String accountId;
 * String tagKey = "aws";
 * String[] tagValues = List.of("dev");
 * Database database = new Database(this, "Database");
 * S3Table table = S3Table.Builder.create(this, "Table")
 *         .database(database)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build(), Column.builder()
 *                 .name("col2")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.CSV)
 *         .build();
 * DefaultStackSynthesizer synthesizer = (DefaultStackSynthesizer)stack.getSynthesizer();
 * CfnDataLakeSettings.Builder.create(this, "DataLakeSettings")
 *         .admins(List.of(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier(stack.formatArn(ArnComponents.builder()
 *                         .service("iam")
 *                         .resource("role")
 *                         .region("")
 *                         .account(accountId)
 *                         .resourceName("Admin")
 *                         .build()))
 *                 .build(), DataLakePrincipalProperty.builder()
 *                 // The CDK cloudformation execution role.
 *                 .dataLakePrincipalIdentifier(synthesizer.cloudFormationExecutionRoleArn.replace("${AWS::Partition}", "aws"))
 *                 .build()))
 *         .build();
 * CfnTag tag = CfnTag.Builder.create(this, "Tag")
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * LFTagPairProperty lfTagPairProperty = LFTagPairProperty.builder()
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * CfnTagAssociation tagAssociation = CfnTagAssociation.Builder.create(this, "TagAssociation")
 *         .lfTags(List.of(lfTagPairProperty))
 *         .resource(ResourceProperty.builder()
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .databaseName(database.getDatabaseName())
 *                         .columnNames(List.of("col1", "col2"))
 *                         .catalogId(accountId)
 *                         .name(table.getTableName())
 *                         .build())
 *                 .build())
 *         .build();
 * tagAssociation.node.addDependency(tag);
 * tagAssociation.node.addDependency(table);
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:15.453Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnDataLakeSettingsProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataLakeSettingsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataLakeSettingsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of AWS Lake Formation principals.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-admins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-admins</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdmins() {
        return null;
    }

    /**
     * Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation .
     * <p>
     * If set to true, you allow Amazon EMR clusters or other third-party engines to access data in Amazon S3 locations that are registered with Lake Formation .
     * <p>
     * If false or null, no third-party query engines will be able to access data in Amazon S3 locations that are registered with Lake Formation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/initial-LF-setup.html#external-data-filter">External data filtering setting</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowexternaldatafiltering">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowexternaldatafiltering</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowExternalDataFiltering() {
        return null;
    }

    /**
     * Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access.
     * <p>
     * It provides query engines and applications performance benefits as well as simplifies data access. Amazon EMR on Amazon EC2 is able to leverage this setting.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/using-cred-vending.html"></a>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowfulltableexternaldataaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-allowfulltableexternaldataaccess</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowFullTableExternalDataAccess() {
        return null;
    }

    /**
     * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     * <p>
     * Lake Formation will publish the acceptable key-value pair, for example key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the temporary security credentials that will be used to call Lake Formation 's administrative API operations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-authorizedsessiontagvaluelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-authorizedsessiontagvaluelist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizedSessionTagValueList() {
        return null;
    }

    /**
     * Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
     * <p>
     * A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicates that the user's IAM permissions determine the access to the database. This is referred to as the setting "Use only IAM access control," and is to support backward compatibility with the AWS Glue permission model implemented by IAM permissions.
     * <p>
     * The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> to <code>IAM_ALLOWED_PRINCIPALS</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createdatabasedefaultpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createdatabasedefaultpermissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreateDatabaseDefaultPermissions() {
        return null;
    }

    /**
     * Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
     * <p>
     * A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicate that the user's IAM permissions determine the access to the table. This is referred to as the setting "Use only IAM access control," and is to support the backward compatibility with the AWS Glue permission model implemented by IAM permissions.
     * <p>
     * The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> permissions to <code>IAM_ALLOWED_PRINCIPALS</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createtabledefaultpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-createtabledefaultpermissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreateTableDefaultPermissions() {
        return null;
    }

    /**
     * A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-externaldatafilteringallowlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-externaldatafilteringallowlist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExternalDataFilteringAllowList() {
        return null;
    }

    /**
     * Specifies whether the data lake settings are updated by adding new values to the current settings ( <code>APPEND</code> ) or by replacing the current settings with new settings ( <code>REPLACE</code> ).
     * <p>
     * <blockquote>
     * <p>
     * If you choose <code>REPLACE</code> , your current data lake settings will be replaced with the new values in your template.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-mutationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-mutationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMutationType() {
        return null;
    }

    /**
     * A key-value map that provides an additional configuration on your data lake.
     * <p>
     * <code>CrossAccountVersion</code> is the key you can configure in the <code>Parameters</code> field. Accepted values for the <code>CrossAccountVersion</code> key are 1, 2, 3, and 4.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * An array of UTF-8 strings.
     * <p>
     * A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log. You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-trustedresourceowners">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-trustedresourceowners</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedResourceOwners() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataLakeSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataLakeSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataLakeSettingsProps> {
        java.lang.Object admins;
        java.lang.Object allowExternalDataFiltering;
        java.lang.Object allowFullTableExternalDataAccess;
        java.util.List<java.lang.String> authorizedSessionTagValueList;
        java.lang.Object createDatabaseDefaultPermissions;
        java.lang.Object createTableDefaultPermissions;
        java.lang.Object externalDataFilteringAllowList;
        java.lang.String mutationType;
        java.lang.Object parameters;
        java.util.List<java.lang.String> trustedResourceOwners;

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAdmins}
         * @param admins A list of AWS Lake Formation principals.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder admins(software.amazon.awscdk.IResolvable admins) {
            this.admins = admins;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAdmins}
         * @param admins A list of AWS Lake Formation principals.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder admins(java.util.List<? extends java.lang.Object> admins) {
            this.admins = admins;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAllowExternalDataFiltering}
         * @param allowExternalDataFiltering Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation .
         *                                   If set to true, you allow Amazon EMR clusters or other third-party engines to access data in Amazon S3 locations that are registered with Lake Formation .
         *                                   <p>
         *                                   If false or null, no third-party query engines will be able to access data in Amazon S3 locations that are registered with Lake Formation.
         *                                   <p>
         *                                   For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/initial-LF-setup.html#external-data-filter">External data filtering setting</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowExternalDataFiltering(java.lang.Boolean allowExternalDataFiltering) {
            this.allowExternalDataFiltering = allowExternalDataFiltering;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAllowExternalDataFiltering}
         * @param allowExternalDataFiltering Whether to allow Amazon EMR clusters or other third-party query engines to access data managed by Lake Formation .
         *                                   If set to true, you allow Amazon EMR clusters or other third-party engines to access data in Amazon S3 locations that are registered with Lake Formation .
         *                                   <p>
         *                                   If false or null, no third-party query engines will be able to access data in Amazon S3 locations that are registered with Lake Formation.
         *                                   <p>
         *                                   For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/initial-LF-setup.html#external-data-filter">External data filtering setting</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowExternalDataFiltering(software.amazon.awscdk.IResolvable allowExternalDataFiltering) {
            this.allowExternalDataFiltering = allowExternalDataFiltering;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAllowFullTableExternalDataAccess}
         * @param allowFullTableExternalDataAccess Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access.
         *                                         It provides query engines and applications performance benefits as well as simplifies data access. Amazon EMR on Amazon EC2 is able to leverage this setting.
         *                                         <p>
         *                                         For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/using-cred-vending.html"></a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowFullTableExternalDataAccess(java.lang.Boolean allowFullTableExternalDataAccess) {
            this.allowFullTableExternalDataAccess = allowFullTableExternalDataAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAllowFullTableExternalDataAccess}
         * @param allowFullTableExternalDataAccess Specifies whether query engines and applications can get credentials without IAM session tags if the user has full table access.
         *                                         It provides query engines and applications performance benefits as well as simplifies data access. Amazon EMR on Amazon EC2 is able to leverage this setting.
         *                                         <p>
         *                                         For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/using-cred-vending.html"></a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowFullTableExternalDataAccess(software.amazon.awscdk.IResolvable allowFullTableExternalDataAccess) {
            this.allowFullTableExternalDataAccess = allowFullTableExternalDataAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAuthorizedSessionTagValueList}
         * @param authorizedSessionTagValueList Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
         *                                      Lake Formation will publish the acceptable key-value pair, for example key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the temporary security credentials that will be used to call Lake Formation 's administrative API operations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizedSessionTagValueList(java.util.List<java.lang.String> authorizedSessionTagValueList) {
            this.authorizedSessionTagValueList = authorizedSessionTagValueList;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getCreateDatabaseDefaultPermissions}
         * @param createDatabaseDefaultPermissions Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
         *                                         A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicates that the user's IAM permissions determine the access to the database. This is referred to as the setting "Use only IAM access control," and is to support backward compatibility with the AWS Glue permission model implemented by IAM permissions.
         *                                         <p>
         *                                         The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> to <code>IAM_ALLOWED_PRINCIPALS</code> .
         *                                         <p>
         *                                         For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createDatabaseDefaultPermissions(software.amazon.awscdk.IResolvable createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = createDatabaseDefaultPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getCreateDatabaseDefaultPermissions}
         * @param createDatabaseDefaultPermissions Specifies whether access control on a newly created database is managed by Lake Formation permissions or exclusively by IAM permissions.
         *                                         A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicates that the user's IAM permissions determine the access to the database. This is referred to as the setting "Use only IAM access control," and is to support backward compatibility with the AWS Glue permission model implemented by IAM permissions.
         *                                         <p>
         *                                         The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> to <code>IAM_ALLOWED_PRINCIPALS</code> .
         *                                         <p>
         *                                         For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createDatabaseDefaultPermissions(java.util.List<? extends java.lang.Object> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = createDatabaseDefaultPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getCreateTableDefaultPermissions}
         * @param createTableDefaultPermissions Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
         *                                      A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicate that the user's IAM permissions determine the access to the table. This is referred to as the setting "Use only IAM access control," and is to support the backward compatibility with the AWS Glue permission model implemented by IAM permissions.
         *                                      <p>
         *                                      The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> permissions to <code>IAM_ALLOWED_PRINCIPALS</code> .
         *                                      <p>
         *                                      For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createTableDefaultPermissions(software.amazon.awscdk.IResolvable createTableDefaultPermissions) {
            this.createTableDefaultPermissions = createTableDefaultPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getCreateTableDefaultPermissions}
         * @param createTableDefaultPermissions Specifies whether access control on a newly created table is managed by Lake Formation permissions or exclusively by IAM permissions.
         *                                      A null value indicates that the access is controlled by Lake Formation permissions. <code>ALL</code> permissions assigned to <code>IAM_ALLOWED_PRINCIPALS</code> group indicate that the user's IAM permissions determine the access to the table. This is referred to as the setting "Use only IAM access control," and is to support the backward compatibility with the AWS Glue permission model implemented by IAM permissions.
         *                                      <p>
         *                                      The only permitted values are an empty array or an array that contains a single JSON object that grants <code>ALL</code> permissions to <code>IAM_ALLOWED_PRINCIPALS</code> .
         *                                      <p>
         *                                      For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the default security settings for your data lake</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createTableDefaultPermissions(java.util.List<? extends java.lang.Object> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = createTableDefaultPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getExternalDataFilteringAllowList}
         * @param externalDataFilteringAllowList A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalDataFilteringAllowList(software.amazon.awscdk.IResolvable externalDataFilteringAllowList) {
            this.externalDataFilteringAllowList = externalDataFilteringAllowList;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getExternalDataFilteringAllowList}
         * @param externalDataFilteringAllowList A list of the account IDs of AWS accounts with Amazon EMR clusters or third-party engines that are allwed to perform data filtering.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalDataFilteringAllowList(java.util.List<? extends java.lang.Object> externalDataFilteringAllowList) {
            this.externalDataFilteringAllowList = externalDataFilteringAllowList;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getMutationType}
         * @param mutationType Specifies whether the data lake settings are updated by adding new values to the current settings ( <code>APPEND</code> ) or by replacing the current settings with new settings ( <code>REPLACE</code> ).
         *                     <blockquote>
         *                     <p>
         *                     If you choose <code>REPLACE</code> , your current data lake settings will be replaced with the new values in your template.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutationType(java.lang.String mutationType) {
            this.mutationType = mutationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getParameters}
         * @param parameters A key-value map that provides an additional configuration on your data lake.
         *                   <code>CrossAccountVersion</code> is the key you can configure in the <code>Parameters</code> field. Accepted values for the <code>CrossAccountVersion</code> key are 1, 2, 3, and 4.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getTrustedResourceOwners}
         * @param trustedResourceOwners An array of UTF-8 strings.
         *                              A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log. You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustedResourceOwners(java.util.List<java.lang.String> trustedResourceOwners) {
            this.trustedResourceOwners = trustedResourceOwners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataLakeSettingsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataLakeSettingsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataLakeSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataLakeSettingsProps {
        private final java.lang.Object admins;
        private final java.lang.Object allowExternalDataFiltering;
        private final java.lang.Object allowFullTableExternalDataAccess;
        private final java.util.List<java.lang.String> authorizedSessionTagValueList;
        private final java.lang.Object createDatabaseDefaultPermissions;
        private final java.lang.Object createTableDefaultPermissions;
        private final java.lang.Object externalDataFilteringAllowList;
        private final java.lang.String mutationType;
        private final java.lang.Object parameters;
        private final java.util.List<java.lang.String> trustedResourceOwners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.admins = software.amazon.jsii.Kernel.get(this, "admins", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.allowExternalDataFiltering = software.amazon.jsii.Kernel.get(this, "allowExternalDataFiltering", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.allowFullTableExternalDataAccess = software.amazon.jsii.Kernel.get(this, "allowFullTableExternalDataAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.authorizedSessionTagValueList = software.amazon.jsii.Kernel.get(this, "authorizedSessionTagValueList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.createDatabaseDefaultPermissions = software.amazon.jsii.Kernel.get(this, "createDatabaseDefaultPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.createTableDefaultPermissions = software.amazon.jsii.Kernel.get(this, "createTableDefaultPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.externalDataFilteringAllowList = software.amazon.jsii.Kernel.get(this, "externalDataFilteringAllowList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mutationType = software.amazon.jsii.Kernel.get(this, "mutationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.trustedResourceOwners = software.amazon.jsii.Kernel.get(this, "trustedResourceOwners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.admins = builder.admins;
            this.allowExternalDataFiltering = builder.allowExternalDataFiltering;
            this.allowFullTableExternalDataAccess = builder.allowFullTableExternalDataAccess;
            this.authorizedSessionTagValueList = builder.authorizedSessionTagValueList;
            this.createDatabaseDefaultPermissions = builder.createDatabaseDefaultPermissions;
            this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
            this.externalDataFilteringAllowList = builder.externalDataFilteringAllowList;
            this.mutationType = builder.mutationType;
            this.parameters = builder.parameters;
            this.trustedResourceOwners = builder.trustedResourceOwners;
        }

        @Override
        public final java.lang.Object getAdmins() {
            return this.admins;
        }

        @Override
        public final java.lang.Object getAllowExternalDataFiltering() {
            return this.allowExternalDataFiltering;
        }

        @Override
        public final java.lang.Object getAllowFullTableExternalDataAccess() {
            return this.allowFullTableExternalDataAccess;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthorizedSessionTagValueList() {
            return this.authorizedSessionTagValueList;
        }

        @Override
        public final java.lang.Object getCreateDatabaseDefaultPermissions() {
            return this.createDatabaseDefaultPermissions;
        }

        @Override
        public final java.lang.Object getCreateTableDefaultPermissions() {
            return this.createTableDefaultPermissions;
        }

        @Override
        public final java.lang.Object getExternalDataFilteringAllowList() {
            return this.externalDataFilteringAllowList;
        }

        @Override
        public final java.lang.String getMutationType() {
            return this.mutationType;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<java.lang.String> getTrustedResourceOwners() {
            return this.trustedResourceOwners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdmins() != null) {
                data.set("admins", om.valueToTree(this.getAdmins()));
            }
            if (this.getAllowExternalDataFiltering() != null) {
                data.set("allowExternalDataFiltering", om.valueToTree(this.getAllowExternalDataFiltering()));
            }
            if (this.getAllowFullTableExternalDataAccess() != null) {
                data.set("allowFullTableExternalDataAccess", om.valueToTree(this.getAllowFullTableExternalDataAccess()));
            }
            if (this.getAuthorizedSessionTagValueList() != null) {
                data.set("authorizedSessionTagValueList", om.valueToTree(this.getAuthorizedSessionTagValueList()));
            }
            if (this.getCreateDatabaseDefaultPermissions() != null) {
                data.set("createDatabaseDefaultPermissions", om.valueToTree(this.getCreateDatabaseDefaultPermissions()));
            }
            if (this.getCreateTableDefaultPermissions() != null) {
                data.set("createTableDefaultPermissions", om.valueToTree(this.getCreateTableDefaultPermissions()));
            }
            if (this.getExternalDataFilteringAllowList() != null) {
                data.set("externalDataFilteringAllowList", om.valueToTree(this.getExternalDataFilteringAllowList()));
            }
            if (this.getMutationType() != null) {
                data.set("mutationType", om.valueToTree(this.getMutationType()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getTrustedResourceOwners() != null) {
                data.set("trustedResourceOwners", om.valueToTree(this.getTrustedResourceOwners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnDataLakeSettingsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataLakeSettingsProps.Jsii$Proxy that = (CfnDataLakeSettingsProps.Jsii$Proxy) o;

            if (this.admins != null ? !this.admins.equals(that.admins) : that.admins != null) return false;
            if (this.allowExternalDataFiltering != null ? !this.allowExternalDataFiltering.equals(that.allowExternalDataFiltering) : that.allowExternalDataFiltering != null) return false;
            if (this.allowFullTableExternalDataAccess != null ? !this.allowFullTableExternalDataAccess.equals(that.allowFullTableExternalDataAccess) : that.allowFullTableExternalDataAccess != null) return false;
            if (this.authorizedSessionTagValueList != null ? !this.authorizedSessionTagValueList.equals(that.authorizedSessionTagValueList) : that.authorizedSessionTagValueList != null) return false;
            if (this.createDatabaseDefaultPermissions != null ? !this.createDatabaseDefaultPermissions.equals(that.createDatabaseDefaultPermissions) : that.createDatabaseDefaultPermissions != null) return false;
            if (this.createTableDefaultPermissions != null ? !this.createTableDefaultPermissions.equals(that.createTableDefaultPermissions) : that.createTableDefaultPermissions != null) return false;
            if (this.externalDataFilteringAllowList != null ? !this.externalDataFilteringAllowList.equals(that.externalDataFilteringAllowList) : that.externalDataFilteringAllowList != null) return false;
            if (this.mutationType != null ? !this.mutationType.equals(that.mutationType) : that.mutationType != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            return this.trustedResourceOwners != null ? this.trustedResourceOwners.equals(that.trustedResourceOwners) : that.trustedResourceOwners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.admins != null ? this.admins.hashCode() : 0;
            result = 31 * result + (this.allowExternalDataFiltering != null ? this.allowExternalDataFiltering.hashCode() : 0);
            result = 31 * result + (this.allowFullTableExternalDataAccess != null ? this.allowFullTableExternalDataAccess.hashCode() : 0);
            result = 31 * result + (this.authorizedSessionTagValueList != null ? this.authorizedSessionTagValueList.hashCode() : 0);
            result = 31 * result + (this.createDatabaseDefaultPermissions != null ? this.createDatabaseDefaultPermissions.hashCode() : 0);
            result = 31 * result + (this.createTableDefaultPermissions != null ? this.createTableDefaultPermissions.hashCode() : 0);
            result = 31 * result + (this.externalDataFilteringAllowList != null ? this.externalDataFilteringAllowList.hashCode() : 0);
            result = 31 * result + (this.mutationType != null ? this.mutationType.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.trustedResourceOwners != null ? this.trustedResourceOwners.hashCode() : 0);
            return result;
        }
    }
}
