package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Specifies a listener for an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnListener cfnListener = CfnListener.Builder.create(this, "MyCfnListener")
 *         .defaultActions(List.of(ActionProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .authenticateCognitoConfig(AuthenticateCognitoConfigProperty.builder()
 *                         .userPoolArn("userPoolArn")
 *                         .userPoolClientId("userPoolClientId")
 *                         .userPoolDomain("userPoolDomain")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout("sessionTimeout")
 *                         .build())
 *                 .authenticateOidcConfig(AuthenticateOidcConfigProperty.builder()
 *                         .authorizationEndpoint("authorizationEndpoint")
 *                         .clientId("clientId")
 *                         .issuer("issuer")
 *                         .tokenEndpoint("tokenEndpoint")
 *                         .userInfoEndpoint("userInfoEndpoint")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .clientSecret("clientSecret")
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout("sessionTimeout")
 *                         .useExistingClientSecret(false)
 *                         .build())
 *                 .fixedResponseConfig(FixedResponseConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentType("contentType")
 *                         .messageBody("messageBody")
 *                         .build())
 *                 .forwardConfig(ForwardConfigProperty.builder()
 *                         .targetGroups(List.of(TargetGroupTupleProperty.builder()
 *                                 .targetGroupArn("targetGroupArn")
 *                                 .weight(123)
 *                                 .build()))
 *                         .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
 *                                 .durationSeconds(123)
 *                                 .enabled(false)
 *                                 .build())
 *                         .build())
 *                 .order(123)
 *                 .redirectConfig(RedirectConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .host("host")
 *                         .path("path")
 *                         .port("port")
 *                         .protocol("protocol")
 *                         .query("query")
 *                         .build())
 *                 .targetGroupArn("targetGroupArn")
 *                 .build()))
 *         .loadBalancerArn("loadBalancerArn")
 *         // the properties below are optional
 *         .alpnPolicy(List.of("alpnPolicy"))
 *         .certificates(List.of(CertificateProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .build()))
 *         .listenerAttributes(List.of(ListenerAttributeProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .mutualAuthentication(MutualAuthenticationProperty.builder()
 *                 .advertiseTrustStoreCaNames("advertiseTrustStoreCaNames")
 *                 .ignoreClientCertificateExpiry(false)
 *                 .mode("mode")
 *                 .trustStoreArn("trustStoreArn")
 *                 .build())
 *         .port(123)
 *         .protocol("protocol")
 *         .sslPolicy("sslPolicy")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:12.731Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener")
public class CfnListener extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnListener(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrListenerArn() {
        return software.amazon.jsii.Kernel.get(this, "attrListenerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The actions for the default rule.
     * <p>
     * You cannot define a condition for a default rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefaultActions() {
        return software.amazon.jsii.Kernel.get(this, "defaultActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The actions for the default rule.
     * <p>
     * You cannot define a condition for a default rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultActions", java.util.Objects.requireNonNull(value, "defaultActions is required"));
    }

    /**
     * The actions for the default rule.
     * <p>
     * You cannot define a condition for a default rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultActions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "defaultActions", java.util.Objects.requireNonNull(value, "defaultActions is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArn() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancerArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancerArn", java.util.Objects.requireNonNull(value, "loadBalancerArn is required"));
    }

    /**
     * [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAlpnPolicy() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "alpnPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlpnPolicy(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "alpnPolicy", value);
    }

    /**
     * The default SSL server certificate for a secure listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCertificates() {
        return software.amazon.jsii.Kernel.get(this, "certificates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default SSL server certificate for a secure listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "certificates", value);
    }

    /**
     * The default SSL server certificate for a secure listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificates(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.CertificateProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.CertificateProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "certificates", value);
    }

    /**
     * The listener attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getListenerAttributes() {
        return software.amazon.jsii.Kernel.get(this, "listenerAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The listener attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setListenerAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "listenerAttributes", value);
    }

    /**
     * The listener attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setListenerAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ListenerAttributeProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ListenerAttributeProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "listenerAttributes", value);
    }

    /**
     * The mutual authentication configuration information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMutualAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "mutualAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The mutual authentication configuration information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMutualAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mutualAuthentication", value);
    }

    /**
     * The mutual authentication configuration information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMutualAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.MutualAuthenticationProperty value) {
        software.amazon.jsii.Kernel.set(this, "mutualAuthentication", value);
    }

    /**
     * The port on which the load balancer is listening.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port on which the load balancer is listening.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The protocol for connections from clients to the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The protocol for connections from clients to the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocol(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protocol", value);
    }

    /**
     * [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSslPolicy() {
        return software.amazon.jsii.Kernel.get(this, "sslPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSslPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sslPolicy", value);
    }
    /**
     * Specifies an action for a listener rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .authenticateCognitoConfig(AuthenticateCognitoConfigProperty.builder()
     *                 .userPoolArn("userPoolArn")
     *                 .userPoolClientId("userPoolClientId")
     *                 .userPoolDomain("userPoolDomain")
     *                 // the properties below are optional
     *                 .authenticationRequestExtraParams(Map.of(
     *                         "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
     *                 .onUnauthenticatedRequest("onUnauthenticatedRequest")
     *                 .scope("scope")
     *                 .sessionCookieName("sessionCookieName")
     *                 .sessionTimeout("sessionTimeout")
     *                 .build())
     *         .authenticateOidcConfig(AuthenticateOidcConfigProperty.builder()
     *                 .authorizationEndpoint("authorizationEndpoint")
     *                 .clientId("clientId")
     *                 .issuer("issuer")
     *                 .tokenEndpoint("tokenEndpoint")
     *                 .userInfoEndpoint("userInfoEndpoint")
     *                 // the properties below are optional
     *                 .authenticationRequestExtraParams(Map.of(
     *                         "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
     *                 .clientSecret("clientSecret")
     *                 .onUnauthenticatedRequest("onUnauthenticatedRequest")
     *                 .scope("scope")
     *                 .sessionCookieName("sessionCookieName")
     *                 .sessionTimeout("sessionTimeout")
     *                 .useExistingClientSecret(false)
     *                 .build())
     *         .fixedResponseConfig(FixedResponseConfigProperty.builder()
     *                 .statusCode("statusCode")
     *                 // the properties below are optional
     *                 .contentType("contentType")
     *                 .messageBody("messageBody")
     *                 .build())
     *         .forwardConfig(ForwardConfigProperty.builder()
     *                 .targetGroups(List.of(TargetGroupTupleProperty.builder()
     *                         .targetGroupArn("targetGroupArn")
     *                         .weight(123)
     *                         .build()))
     *                 .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
     *                         .durationSeconds(123)
     *                         .enabled(false)
     *                         .build())
     *                 .build())
     *         .order(123)
     *         .redirectConfig(RedirectConfigProperty.builder()
     *                 .statusCode("statusCode")
     *                 // the properties below are optional
     *                 .host("host")
     *                 .path("path")
     *                 .port("port")
     *                 .protocol("protocol")
     *                 .query("query")
     *                 .build())
     *         .targetGroupArn("targetGroupArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * [HTTPS listeners] Information for using Amazon Cognito to authenticate users.
         * <p>
         * Specify only when <code>Type</code> is <code>authenticate-cognito</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticateCognitoConfig() {
            return null;
        }

        /**
         * [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC).
         * <p>
         * Specify only when <code>Type</code> is <code>authenticate-oidc</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticateOidcConfig() {
            return null;
        }

        /**
         * [Application Load Balancer] Information for creating an action that returns a custom HTTP response.
         * <p>
         * Specify only when <code>Type</code> is <code>fixed-response</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFixedResponseConfig() {
            return null;
        }

        /**
         * Information for creating an action that distributes requests among one or more target groups.
         * <p>
         * For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code> . If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code> , you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-forwardconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-forwardconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardConfig() {
            return null;
        }

        /**
         * The order for the action.
         * <p>
         * This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-order">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-order</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOrder() {
            return null;
        }

        /**
         * [Application Load Balancer] Information for creating a redirect action.
         * <p>
         * Specify only when <code>Type</code> is <code>redirect</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedirectConfig() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the target group.
         * <p>
         * Specify only when <code>Type</code> is <code>forward</code> and you want to route to a single target group. To route to one or more target groups, use <code>ForwardConfig</code> instead.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-targetgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-action.html#cfn-elasticloadbalancingv2-listener-action-targetgrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.String type;
            java.lang.Object authenticateCognitoConfig;
            java.lang.Object authenticateOidcConfig;
            java.lang.Object fixedResponseConfig;
            java.lang.Object forwardConfig;
            java.lang.Number order;
            java.lang.Object redirectConfig;
            java.lang.String targetGroupArn;

            /**
             * Sets the value of {@link ActionProperty#getType}
             * @param type The type of action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateCognitoConfig}
             * @param authenticateCognitoConfig [HTTPS listeners] Information for using Amazon Cognito to authenticate users.
             *                                  Specify only when <code>Type</code> is <code>authenticate-cognito</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateCognitoConfig(software.amazon.awscdk.IResolvable authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateCognitoConfig}
             * @param authenticateCognitoConfig [HTTPS listeners] Information for using Amazon Cognito to authenticate users.
             *                                  Specify only when <code>Type</code> is <code>authenticate-cognito</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateCognitoConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.AuthenticateCognitoConfigProperty authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateOidcConfig}
             * @param authenticateOidcConfig [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC).
             *                               Specify only when <code>Type</code> is <code>authenticate-oidc</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateOidcConfig(software.amazon.awscdk.IResolvable authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateOidcConfig}
             * @param authenticateOidcConfig [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC).
             *                               Specify only when <code>Type</code> is <code>authenticate-oidc</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateOidcConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.AuthenticateOidcConfigProperty authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFixedResponseConfig}
             * @param fixedResponseConfig [Application Load Balancer] Information for creating an action that returns a custom HTTP response.
             *                            Specify only when <code>Type</code> is <code>fixed-response</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedResponseConfig(software.amazon.awscdk.IResolvable fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFixedResponseConfig}
             * @param fixedResponseConfig [Application Load Balancer] Information for creating an action that returns a custom HTTP response.
             *                            Specify only when <code>Type</code> is <code>fixed-response</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedResponseConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.FixedResponseConfigProperty fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getForwardConfig}
             * @param forwardConfig Information for creating an action that distributes requests among one or more target groups.
             *                      For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code> . If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code> , you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardConfig(software.amazon.awscdk.IResolvable forwardConfig) {
                this.forwardConfig = forwardConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getForwardConfig}
             * @param forwardConfig Information for creating an action that distributes requests among one or more target groups.
             *                      For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code> . If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code> , you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ForwardConfigProperty forwardConfig) {
                this.forwardConfig = forwardConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getOrder}
             * @param order The order for the action.
             *              This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder order(java.lang.Number order) {
                this.order = order;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getRedirectConfig}
             * @param redirectConfig [Application Load Balancer] Information for creating a redirect action.
             *                       Specify only when <code>Type</code> is <code>redirect</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectConfig(software.amazon.awscdk.IResolvable redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getRedirectConfig}
             * @param redirectConfig [Application Load Balancer] Information for creating a redirect action.
             *                       Specify only when <code>Type</code> is <code>redirect</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.RedirectConfigProperty redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getTargetGroupArn}
             * @param targetGroupArn The Amazon Resource Name (ARN) of the target group.
             *                       Specify only when <code>Type</code> is <code>forward</code> and you want to route to a single target group. To route to one or more target groups, use <code>ForwardConfig</code> instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.String type;
            private final java.lang.Object authenticateCognitoConfig;
            private final java.lang.Object authenticateOidcConfig;
            private final java.lang.Object fixedResponseConfig;
            private final java.lang.Object forwardConfig;
            private final java.lang.Number order;
            private final java.lang.Object redirectConfig;
            private final java.lang.String targetGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticateCognitoConfig = software.amazon.jsii.Kernel.get(this, "authenticateCognitoConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.authenticateOidcConfig = software.amazon.jsii.Kernel.get(this, "authenticateOidcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fixedResponseConfig = software.amazon.jsii.Kernel.get(this, "fixedResponseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.forwardConfig = software.amazon.jsii.Kernel.get(this, "forwardConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.order = software.amazon.jsii.Kernel.get(this, "order", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.redirectConfig = software.amazon.jsii.Kernel.get(this, "redirectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetGroupArn = software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.authenticateCognitoConfig = builder.authenticateCognitoConfig;
                this.authenticateOidcConfig = builder.authenticateOidcConfig;
                this.fixedResponseConfig = builder.fixedResponseConfig;
                this.forwardConfig = builder.forwardConfig;
                this.order = builder.order;
                this.redirectConfig = builder.redirectConfig;
                this.targetGroupArn = builder.targetGroupArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getAuthenticateCognitoConfig() {
                return this.authenticateCognitoConfig;
            }

            @Override
            public final java.lang.Object getAuthenticateOidcConfig() {
                return this.authenticateOidcConfig;
            }

            @Override
            public final java.lang.Object getFixedResponseConfig() {
                return this.fixedResponseConfig;
            }

            @Override
            public final java.lang.Object getForwardConfig() {
                return this.forwardConfig;
            }

            @Override
            public final java.lang.Number getOrder() {
                return this.order;
            }

            @Override
            public final java.lang.Object getRedirectConfig() {
                return this.redirectConfig;
            }

            @Override
            public final java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAuthenticateCognitoConfig() != null) {
                    data.set("authenticateCognitoConfig", om.valueToTree(this.getAuthenticateCognitoConfig()));
                }
                if (this.getAuthenticateOidcConfig() != null) {
                    data.set("authenticateOidcConfig", om.valueToTree(this.getAuthenticateOidcConfig()));
                }
                if (this.getFixedResponseConfig() != null) {
                    data.set("fixedResponseConfig", om.valueToTree(this.getFixedResponseConfig()));
                }
                if (this.getForwardConfig() != null) {
                    data.set("forwardConfig", om.valueToTree(this.getForwardConfig()));
                }
                if (this.getOrder() != null) {
                    data.set("order", om.valueToTree(this.getOrder()));
                }
                if (this.getRedirectConfig() != null) {
                    data.set("redirectConfig", om.valueToTree(this.getRedirectConfig()));
                }
                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.authenticateCognitoConfig != null ? !this.authenticateCognitoConfig.equals(that.authenticateCognitoConfig) : that.authenticateCognitoConfig != null) return false;
                if (this.authenticateOidcConfig != null ? !this.authenticateOidcConfig.equals(that.authenticateOidcConfig) : that.authenticateOidcConfig != null) return false;
                if (this.fixedResponseConfig != null ? !this.fixedResponseConfig.equals(that.fixedResponseConfig) : that.fixedResponseConfig != null) return false;
                if (this.forwardConfig != null ? !this.forwardConfig.equals(that.forwardConfig) : that.forwardConfig != null) return false;
                if (this.order != null ? !this.order.equals(that.order) : that.order != null) return false;
                if (this.redirectConfig != null ? !this.redirectConfig.equals(that.redirectConfig) : that.redirectConfig != null) return false;
                return this.targetGroupArn != null ? this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.authenticateCognitoConfig != null ? this.authenticateCognitoConfig.hashCode() : 0);
                result = 31 * result + (this.authenticateOidcConfig != null ? this.authenticateOidcConfig.hashCode() : 0);
                result = 31 * result + (this.fixedResponseConfig != null ? this.fixedResponseConfig.hashCode() : 0);
                result = 31 * result + (this.forwardConfig != null ? this.forwardConfig.hashCode() : 0);
                result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
                result = 31 * result + (this.redirectConfig != null ? this.redirectConfig.hashCode() : 0);
                result = 31 * result + (this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies information required when integrating with Amazon Cognito to authenticate users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * AuthenticateCognitoConfigProperty authenticateCognitoConfigProperty = AuthenticateCognitoConfigProperty.builder()
     *         .userPoolArn("userPoolArn")
     *         .userPoolClientId("userPoolClientId")
     *         .userPoolDomain("userPoolDomain")
     *         // the properties below are optional
     *         .authenticationRequestExtraParams(Map.of(
     *                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
     *         .onUnauthenticatedRequest("onUnauthenticatedRequest")
     *         .scope("scope")
     *         .sessionCookieName("sessionCookieName")
     *         .sessionTimeout("sessionTimeout")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.AuthenticateCognitoConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticateCognitoConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticateCognitoConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn();

        /**
         * The ID of the Amazon Cognito user pool client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolClientId();

        /**
         * The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolDomain();

        /**
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationRequestExtraParams() {
            return null;
        }

        /**
         * The behavior if the user is not authenticated. The following are possible values:.
         * <p>
         * <ul>
         * <li>deny `` - Return an HTTP 401 Unauthorized error.</li>
         * <li>allow `` - Allow the request to be forwarded to the target.</li>
         * <li>authenticate `` - Redirect the request to the IdP authorization endpoint. This is the default value.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnUnauthenticatedRequest() {
            return null;
        }

        /**
         * The set of user claims to be requested from the IdP. The default is <code>openid</code> .
         * <p>
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * The name of the cookie used to maintain session information.
         * <p>
         * The default is AWSELBAuthSessionCookie.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionCookieName() {
            return null;
        }

        /**
         * The maximum duration of the authentication session, in seconds.
         * <p>
         * The default is 604800 seconds (7 days).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticateCognitoConfigProperty> {
            java.lang.String userPoolArn;
            java.lang.String userPoolClientId;
            java.lang.String userPoolDomain;
            java.lang.Object authenticationRequestExtraParams;
            java.lang.String onUnauthenticatedRequest;
            java.lang.String scope;
            java.lang.String sessionCookieName;
            java.lang.String sessionTimeout;

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolArn}
             * @param userPoolArn The Amazon Resource Name (ARN) of the Amazon Cognito user pool. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolArn(java.lang.String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolClientId}
             * @param userPoolClientId The ID of the Amazon Cognito user pool client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolClientId(java.lang.String userPoolClientId) {
                this.userPoolClientId = userPoolClientId;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolDomain}
             * @param userPoolDomain The domain prefix or fully-qualified domain name of the Amazon Cognito user pool. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolDomain(java.lang.String userPoolDomain) {
                this.userPoolDomain = userPoolDomain;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(software.amazon.awscdk.IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getOnUnauthenticatedRequest}
             * @param onUnauthenticatedRequest The behavior if the user is not authenticated. The following are possible values:.
             *                                 <ul>
             *                                 <li>deny `` - Return an HTTP 401 Unauthorized error.</li>
             *                                 <li>allow `` - Allow the request to be forwarded to the target.</li>
             *                                 <li>authenticate `` - Redirect the request to the IdP authorization endpoint. This is the default value.</li>
             *                                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUnauthenticatedRequest(java.lang.String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getScope}
             * @param scope The set of user claims to be requested from the IdP. The default is <code>openid</code> .
             *              To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getSessionCookieName}
             * @param sessionCookieName The name of the cookie used to maintain session information.
             *                          The default is AWSELBAuthSessionCookie.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionCookieName(java.lang.String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getSessionTimeout}
             * @param sessionTimeout The maximum duration of the authentication session, in seconds.
             *                       The default is 604800 seconds (7 days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionTimeout(java.lang.String sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateCognitoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticateCognitoConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateCognitoConfigProperty {
            private final java.lang.String userPoolArn;
            private final java.lang.String userPoolClientId;
            private final java.lang.String userPoolDomain;
            private final java.lang.Object authenticationRequestExtraParams;
            private final java.lang.String onUnauthenticatedRequest;
            private final java.lang.String scope;
            private final java.lang.String sessionCookieName;
            private final java.lang.String sessionTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.userPoolArn = software.amazon.jsii.Kernel.get(this, "userPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolClientId = software.amazon.jsii.Kernel.get(this, "userPoolClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolDomain = software.amazon.jsii.Kernel.get(this, "userPoolDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticationRequestExtraParams = software.amazon.jsii.Kernel.get(this, "authenticationRequestExtraParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onUnauthenticatedRequest = software.amazon.jsii.Kernel.get(this, "onUnauthenticatedRequest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionCookieName = software.amazon.jsii.Kernel.get(this, "sessionCookieName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionTimeout = software.amazon.jsii.Kernel.get(this, "sessionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.userPoolArn = java.util.Objects.requireNonNull(builder.userPoolArn, "userPoolArn is required");
                this.userPoolClientId = java.util.Objects.requireNonNull(builder.userPoolClientId, "userPoolClientId is required");
                this.userPoolDomain = java.util.Objects.requireNonNull(builder.userPoolDomain, "userPoolDomain is required");
                this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
                this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
                this.scope = builder.scope;
                this.sessionCookieName = builder.sessionCookieName;
                this.sessionTimeout = builder.sessionTimeout;
            }

            @Override
            public final java.lang.String getUserPoolArn() {
                return this.userPoolArn;
            }

            @Override
            public final java.lang.String getUserPoolClientId() {
                return this.userPoolClientId;
            }

            @Override
            public final java.lang.String getUserPoolDomain() {
                return this.userPoolDomain;
            }

            @Override
            public final java.lang.Object getAuthenticationRequestExtraParams() {
                return this.authenticationRequestExtraParams;
            }

            @Override
            public final java.lang.String getOnUnauthenticatedRequest() {
                return this.onUnauthenticatedRequest;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public final java.lang.String getSessionCookieName() {
                return this.sessionCookieName;
            }

            @Override
            public final java.lang.String getSessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                data.set("userPoolClientId", om.valueToTree(this.getUserPoolClientId()));
                data.set("userPoolDomain", om.valueToTree(this.getUserPoolDomain()));
                if (this.getAuthenticationRequestExtraParams() != null) {
                    data.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                }
                if (this.getOnUnauthenticatedRequest() != null) {
                    data.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSessionCookieName() != null) {
                    data.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                }
                if (this.getSessionTimeout() != null) {
                    data.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.AuthenticateCognitoConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticateCognitoConfigProperty.Jsii$Proxy that = (AuthenticateCognitoConfigProperty.Jsii$Proxy) o;

                if (!userPoolArn.equals(that.userPoolArn)) return false;
                if (!userPoolClientId.equals(that.userPoolClientId)) return false;
                if (!userPoolDomain.equals(that.userPoolDomain)) return false;
                if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
                if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
                return this.sessionTimeout != null ? this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.userPoolArn.hashCode();
                result = 31 * result + (this.userPoolClientId.hashCode());
                result = 31 * result + (this.userPoolDomain.hashCode());
                result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
                result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
                result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies information required using an identity provide (IdP) that is compliant with OpenID Connect (OIDC) to authenticate users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * AuthenticateOidcConfigProperty authenticateOidcConfigProperty = AuthenticateOidcConfigProperty.builder()
     *         .authorizationEndpoint("authorizationEndpoint")
     *         .clientId("clientId")
     *         .issuer("issuer")
     *         .tokenEndpoint("tokenEndpoint")
     *         .userInfoEndpoint("userInfoEndpoint")
     *         // the properties below are optional
     *         .authenticationRequestExtraParams(Map.of(
     *                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
     *         .clientSecret("clientSecret")
     *         .onUnauthenticatedRequest("onUnauthenticatedRequest")
     *         .scope("scope")
     *         .sessionCookieName("sessionCookieName")
     *         .sessionTimeout("sessionTimeout")
     *         .useExistingClientSecret(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.AuthenticateOidcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticateOidcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticateOidcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization endpoint of the IdP.
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationEndpoint();

        /**
         * The OAuth 2.0 client identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The OIDC issuer identifier of the IdP.
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIssuer();

        /**
         * The token endpoint of the IdP.
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTokenEndpoint();

        /**
         * The user info endpoint of the IdP.
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserInfoEndpoint();

        /**
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationRequestExtraParams() {
            return null;
        }

        /**
         * The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientSecret() {
            return null;
        }

        /**
         * The behavior if the user is not authenticated. The following are possible values:.
         * <p>
         * <ul>
         * <li>deny `` - Return an HTTP 401 Unauthorized error.</li>
         * <li>allow `` - Allow the request to be forwarded to the target.</li>
         * <li>authenticate `` - Redirect the request to the IdP authorization endpoint. This is the default value.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnUnauthenticatedRequest() {
            return null;
        }

        /**
         * The set of user claims to be requested from the IdP. The default is <code>openid</code> .
         * <p>
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * The name of the cookie used to maintain session information.
         * <p>
         * The default is AWSELBAuthSessionCookie.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionCookieName() {
            return null;
        }

        /**
         * The maximum duration of the authentication session, in seconds.
         * <p>
         * The default is 604800 seconds (7 days).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionTimeout() {
            return null;
        }

        /**
         * Indicates whether to use the existing client secret when modifying a rule.
         * <p>
         * If you are creating a rule, you can omit this parameter or set it to false.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-useexistingclientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-useexistingclientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseExistingClientSecret() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticateOidcConfigProperty> {
            java.lang.String authorizationEndpoint;
            java.lang.String clientId;
            java.lang.String issuer;
            java.lang.String tokenEndpoint;
            java.lang.String userInfoEndpoint;
            java.lang.Object authenticationRequestExtraParams;
            java.lang.String clientSecret;
            java.lang.String onUnauthenticatedRequest;
            java.lang.String scope;
            java.lang.String sessionCookieName;
            java.lang.String sessionTimeout;
            java.lang.Object useExistingClientSecret;

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthorizationEndpoint}
             * @param authorizationEndpoint The authorization endpoint of the IdP. This parameter is required.
             *                              This must be a full URL, including the HTTPS protocol, the domain, and the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationEndpoint(java.lang.String authorizationEndpoint) {
                this.authorizationEndpoint = authorizationEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getClientId}
             * @param clientId The OAuth 2.0 client identifier. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getIssuer}
             * @param issuer The OIDC issuer identifier of the IdP. This parameter is required.
             *               This must be a full URL, including the HTTPS protocol, the domain, and the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getTokenEndpoint}
             * @param tokenEndpoint The token endpoint of the IdP. This parameter is required.
             *                      This must be a full URL, including the HTTPS protocol, the domain, and the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenEndpoint(java.lang.String tokenEndpoint) {
                this.tokenEndpoint = tokenEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getUserInfoEndpoint}
             * @param userInfoEndpoint The user info endpoint of the IdP. This parameter is required.
             *                         This must be a full URL, including the HTTPS protocol, the domain, and the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInfoEndpoint(java.lang.String userInfoEndpoint) {
                this.userInfoEndpoint = userInfoEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(software.amazon.awscdk.IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getClientSecret}
             * @param clientSecret The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getOnUnauthenticatedRequest}
             * @param onUnauthenticatedRequest The behavior if the user is not authenticated. The following are possible values:.
             *                                 <ul>
             *                                 <li>deny `` - Return an HTTP 401 Unauthorized error.</li>
             *                                 <li>allow `` - Allow the request to be forwarded to the target.</li>
             *                                 <li>authenticate `` - Redirect the request to the IdP authorization endpoint. This is the default value.</li>
             *                                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUnauthenticatedRequest(java.lang.String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getScope}
             * @param scope The set of user claims to be requested from the IdP. The default is <code>openid</code> .
             *              To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getSessionCookieName}
             * @param sessionCookieName The name of the cookie used to maintain session information.
             *                          The default is AWSELBAuthSessionCookie.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionCookieName(java.lang.String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getSessionTimeout}
             * @param sessionTimeout The maximum duration of the authentication session, in seconds.
             *                       The default is 604800 seconds (7 days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionTimeout(java.lang.String sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getUseExistingClientSecret}
             * @param useExistingClientSecret Indicates whether to use the existing client secret when modifying a rule.
             *                                If you are creating a rule, you can omit this parameter or set it to false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useExistingClientSecret(java.lang.Boolean useExistingClientSecret) {
                this.useExistingClientSecret = useExistingClientSecret;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getUseExistingClientSecret}
             * @param useExistingClientSecret Indicates whether to use the existing client secret when modifying a rule.
             *                                If you are creating a rule, you can omit this parameter or set it to false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useExistingClientSecret(software.amazon.awscdk.IResolvable useExistingClientSecret) {
                this.useExistingClientSecret = useExistingClientSecret;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateOidcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticateOidcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateOidcConfigProperty {
            private final java.lang.String authorizationEndpoint;
            private final java.lang.String clientId;
            private final java.lang.String issuer;
            private final java.lang.String tokenEndpoint;
            private final java.lang.String userInfoEndpoint;
            private final java.lang.Object authenticationRequestExtraParams;
            private final java.lang.String clientSecret;
            private final java.lang.String onUnauthenticatedRequest;
            private final java.lang.String scope;
            private final java.lang.String sessionCookieName;
            private final java.lang.String sessionTimeout;
            private final java.lang.Object useExistingClientSecret;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationEndpoint = software.amazon.jsii.Kernel.get(this, "authorizationEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenEndpoint = software.amazon.jsii.Kernel.get(this, "tokenEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userInfoEndpoint = software.amazon.jsii.Kernel.get(this, "userInfoEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticationRequestExtraParams = software.amazon.jsii.Kernel.get(this, "authenticationRequestExtraParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onUnauthenticatedRequest = software.amazon.jsii.Kernel.get(this, "onUnauthenticatedRequest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionCookieName = software.amazon.jsii.Kernel.get(this, "sessionCookieName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionTimeout = software.amazon.jsii.Kernel.get(this, "sessionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useExistingClientSecret = software.amazon.jsii.Kernel.get(this, "useExistingClientSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationEndpoint = java.util.Objects.requireNonNull(builder.authorizationEndpoint, "authorizationEndpoint is required");
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.issuer = java.util.Objects.requireNonNull(builder.issuer, "issuer is required");
                this.tokenEndpoint = java.util.Objects.requireNonNull(builder.tokenEndpoint, "tokenEndpoint is required");
                this.userInfoEndpoint = java.util.Objects.requireNonNull(builder.userInfoEndpoint, "userInfoEndpoint is required");
                this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
                this.clientSecret = builder.clientSecret;
                this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
                this.scope = builder.scope;
                this.sessionCookieName = builder.sessionCookieName;
                this.sessionTimeout = builder.sessionTimeout;
                this.useExistingClientSecret = builder.useExistingClientSecret;
            }

            @Override
            public final java.lang.String getAuthorizationEndpoint() {
                return this.authorizationEndpoint;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public final java.lang.String getTokenEndpoint() {
                return this.tokenEndpoint;
            }

            @Override
            public final java.lang.String getUserInfoEndpoint() {
                return this.userInfoEndpoint;
            }

            @Override
            public final java.lang.Object getAuthenticationRequestExtraParams() {
                return this.authenticationRequestExtraParams;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getOnUnauthenticatedRequest() {
                return this.onUnauthenticatedRequest;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public final java.lang.String getSessionCookieName() {
                return this.sessionCookieName;
            }

            @Override
            public final java.lang.String getSessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            public final java.lang.Object getUseExistingClientSecret() {
                return this.useExistingClientSecret;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("issuer", om.valueToTree(this.getIssuer()));
                data.set("tokenEndpoint", om.valueToTree(this.getTokenEndpoint()));
                data.set("userInfoEndpoint", om.valueToTree(this.getUserInfoEndpoint()));
                if (this.getAuthenticationRequestExtraParams() != null) {
                    data.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                }
                if (this.getClientSecret() != null) {
                    data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                }
                if (this.getOnUnauthenticatedRequest() != null) {
                    data.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSessionCookieName() != null) {
                    data.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                }
                if (this.getSessionTimeout() != null) {
                    data.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                }
                if (this.getUseExistingClientSecret() != null) {
                    data.set("useExistingClientSecret", om.valueToTree(this.getUseExistingClientSecret()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.AuthenticateOidcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticateOidcConfigProperty.Jsii$Proxy that = (AuthenticateOidcConfigProperty.Jsii$Proxy) o;

                if (!authorizationEndpoint.equals(that.authorizationEndpoint)) return false;
                if (!clientId.equals(that.clientId)) return false;
                if (!issuer.equals(that.issuer)) return false;
                if (!tokenEndpoint.equals(that.tokenEndpoint)) return false;
                if (!userInfoEndpoint.equals(that.userInfoEndpoint)) return false;
                if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
                if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) return false;
                if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
                if (this.sessionTimeout != null ? !this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout != null) return false;
                return this.useExistingClientSecret != null ? this.useExistingClientSecret.equals(that.useExistingClientSecret) : that.useExistingClientSecret == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationEndpoint.hashCode();
                result = 31 * result + (this.clientId.hashCode());
                result = 31 * result + (this.issuer.hashCode());
                result = 31 * result + (this.tokenEndpoint.hashCode());
                result = 31 * result + (this.userInfoEndpoint.hashCode());
                result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
                result = 31 * result + (this.clientSecret != null ? this.clientSecret.hashCode() : 0);
                result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
                result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
                result = 31 * result + (this.useExistingClientSecret != null ? this.useExistingClientSecret.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an SSL server certificate to use as the default certificate for a secure listener.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * CertificateProperty certificateProperty = CertificateProperty.builder()
     *         .certificateArn("certificateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.CertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificate.html#cfn-elasticloadbalancingv2-listener-certificate-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificate.html#cfn-elasticloadbalancingv2-listener-certificate-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateProperty> {
            java.lang.String certificateArn;

            /**
             * Sets the value of {@link CertificateProperty#getCertificateArn}
             * @param certificateArn The Amazon Resource Name (ARN) of the certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateProperty {
            private final java.lang.String certificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = builder.certificateArn;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.CertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateProperty.Jsii$Proxy that = (CertificateProperty.Jsii$Proxy) o;

                return this.certificateArn != null ? this.certificateArn.equals(that.certificateArn) : that.certificateArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn != null ? this.certificateArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies information required when returning a custom HTTP response.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * FixedResponseConfigProperty fixedResponseConfigProperty = FixedResponseConfigProperty.builder()
     *         .statusCode("statusCode")
     *         // the properties below are optional
     *         .contentType("contentType")
     *         .messageBody("messageBody")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.FixedResponseConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FixedResponseConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FixedResponseConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP response code (2XX, 4XX, or 5XX).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * The content type.
         * <p>
         * Valid Values: text/plain | text/css | text/html | application/javascript | application/json
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
            return null;
        }

        /**
         * The message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageBody() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FixedResponseConfigProperty> {
            java.lang.String statusCode;
            java.lang.String contentType;
            java.lang.String messageBody;

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getStatusCode}
             * @param statusCode The HTTP response code (2XX, 4XX, or 5XX). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getContentType}
             * @param contentType The content type.
             *                    Valid Values: text/plain | text/css | text/html | application/javascript | application/json
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getMessageBody}
             * @param messageBody The message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageBody(java.lang.String messageBody) {
                this.messageBody = messageBody;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedResponseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FixedResponseConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FixedResponseConfigProperty {
            private final java.lang.String statusCode;
            private final java.lang.String contentType;
            private final java.lang.String messageBody;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageBody = software.amazon.jsii.Kernel.get(this, "messageBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
                this.contentType = builder.contentType;
                this.messageBody = builder.messageBody;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            public final java.lang.String getMessageBody() {
                return this.messageBody;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getContentType() != null) {
                    data.set("contentType", om.valueToTree(this.getContentType()));
                }
                if (this.getMessageBody() != null) {
                    data.set("messageBody", om.valueToTree(this.getMessageBody()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.FixedResponseConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FixedResponseConfigProperty.Jsii$Proxy that = (FixedResponseConfigProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
                return this.messageBody != null ? this.messageBody.equals(that.messageBody) : that.messageBody == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
                result = 31 * result + (this.messageBody != null ? this.messageBody.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information for creating an action that distributes requests among one or more target groups.
     * <p>
     * For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code> . If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code> , you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * ForwardConfigProperty forwardConfigProperty = ForwardConfigProperty.builder()
     *         .targetGroups(List.of(TargetGroupTupleProperty.builder()
     *                 .targetGroupArn("targetGroupArn")
     *                 .weight(123)
     *                 .build()))
     *         .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
     *                 .durationSeconds(123)
     *                 .enabled(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.ForwardConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ForwardConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForwardConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about how traffic will be distributed between multiple target groups in a forward rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroups() {
            return null;
        }

        /**
         * Information about the target group stickiness for a rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroupstickinessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroupstickinessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupStickinessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForwardConfigProperty> {
            java.lang.Object targetGroups;
            java.lang.Object targetGroupStickinessConfig;

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroups}
             * @param targetGroups Information about how traffic will be distributed between multiple target groups in a forward rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(software.amazon.awscdk.IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroups}
             * @param targetGroups Information about how traffic will be distributed between multiple target groups in a forward rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(java.util.List<? extends java.lang.Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroupStickinessConfig}
             * @param targetGroupStickinessConfig Information about the target group stickiness for a rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupStickinessConfig(software.amazon.awscdk.IResolvable targetGroupStickinessConfig) {
                this.targetGroupStickinessConfig = targetGroupStickinessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroupStickinessConfig}
             * @param targetGroupStickinessConfig Information about the target group stickiness for a rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupStickinessConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.TargetGroupStickinessConfigProperty targetGroupStickinessConfig) {
                this.targetGroupStickinessConfig = targetGroupStickinessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForwardConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForwardConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForwardConfigProperty {
            private final java.lang.Object targetGroups;
            private final java.lang.Object targetGroupStickinessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetGroupStickinessConfig = software.amazon.jsii.Kernel.get(this, "targetGroupStickinessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetGroups = builder.targetGroups;
                this.targetGroupStickinessConfig = builder.targetGroupStickinessConfig;
            }

            @Override
            public final java.lang.Object getTargetGroups() {
                return this.targetGroups;
            }

            @Override
            public final java.lang.Object getTargetGroupStickinessConfig() {
                return this.targetGroupStickinessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetGroups() != null) {
                    data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                }
                if (this.getTargetGroupStickinessConfig() != null) {
                    data.set("targetGroupStickinessConfig", om.valueToTree(this.getTargetGroupStickinessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.ForwardConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForwardConfigProperty.Jsii$Proxy that = (ForwardConfigProperty.Jsii$Proxy) o;

                if (this.targetGroups != null ? !this.targetGroups.equals(that.targetGroups) : that.targetGroups != null) return false;
                return this.targetGroupStickinessConfig != null ? this.targetGroupStickinessConfig.equals(that.targetGroupStickinessConfig) : that.targetGroupStickinessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetGroups != null ? this.targetGroups.hashCode() : 0;
                result = 31 * result + (this.targetGroupStickinessConfig != null ? this.targetGroupStickinessConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a listener attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * ListenerAttributeProperty listenerAttributeProperty = ListenerAttributeProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-listenerattribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-listenerattribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.ListenerAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenerAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListenerAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the attribute.
         * <p>
         * The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
         * <p>
         * <ul>
         * <li><code>tcp.idle_timeout.seconds</code> - The tcp idle timeout value, in seconds. The valid range is 60-6000 seconds. The default is 350 seconds.</li>
         * </ul>
         * <p>
         * The following attributes are only supported by Application Load Balancers.
         * <p>
         * <ul>
         * <li><code>routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Serial-Number</em> HTTP request header.</li>
         * <li><code>routing.http.request.x_amzn_mtls_clientcert_issuer.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Issuer</em> HTTP request header.</li>
         * <li><code>routing.http.request.x_amzn_mtls_clientcert_subject.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Subject</em> HTTP request header.</li>
         * <li><code>routing.http.request.x_amzn_mtls_clientcert_validity.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Validity</em> HTTP request header.</li>
         * <li><code>routing.http.request.x_amzn_mtls_clientcert_leaf.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Leaf</em> HTTP request header.</li>
         * <li><code>routing.http.request.x_amzn_mtls_clientcert.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert</em> HTTP request header.</li>
         * <li><code>routing.http.request.x_amzn_tls_version.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Tls-Version</em> HTTP request header.</li>
         * <li><code>routing.http.request.x_amzn_tls_cipher_suite.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Tls-Cipher-Suite</em> HTTP request header.</li>
         * <li><code>routing.http.response.server.enabled</code> - Enables you to allow or remove the HTTP response server header.</li>
         * <li><code>routing.http.response.strict_transport_security.header_value</code> - Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS.</li>
         * <li><code>routing.http.response.access_control_allow_origin.header_value</code> - Specifies which origins are allowed to access the server.</li>
         * <li><code>routing.http.response.access_control_allow_methods.header_value</code> - Returns which HTTP methods are allowed when accessing the server from a different origin.</li>
         * <li><code>routing.http.response.access_control_allow_headers.header_value</code> - Specifies which headers can be used during the request.</li>
         * <li><code>routing.http.response.access_control_allow_credentials.header_value</code> - Indicates whether the browser should include credentials such as cookies or authentication when making requests.</li>
         * <li><code>routing.http.response.access_control_expose_headers.header_value</code> - Returns which headers the browser can expose to the requesting client.</li>
         * <li><code>routing.http.response.access_control_max_age.header_value</code> - Specifies how long the results of a preflight request can be cached, in seconds.</li>
         * <li><code>routing.http.response.content_security_policy.header_value</code> - Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats.</li>
         * <li><code>routing.http.response.x_content_type_options.header_value</code> - Indicates whether the MIME types advertised in the <em>Content-Type</em> headers should be followed and not be changed.</li>
         * <li><code>routing.http.response.x_frame_options.header_value</code> - Indicates whether the browser is allowed to render a page in a <em>frame</em> , <em>iframe</em> , <em>embed</em> or <em>object</em> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-listenerattribute.html#cfn-elasticloadbalancingv2-listener-listenerattribute-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-listenerattribute.html#cfn-elasticloadbalancingv2-listener-listenerattribute-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The value of the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-listenerattribute.html#cfn-elasticloadbalancingv2-listener-listenerattribute-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-listenerattribute.html#cfn-elasticloadbalancingv2-listener-listenerattribute-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListenerAttributeProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ListenerAttributeProperty#getKey}
             * @param key The name of the attribute.
             *            The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
             *            <p>
             *            <ul>
             *            <li><code>tcp.idle_timeout.seconds</code> - The tcp idle timeout value, in seconds. The valid range is 60-6000 seconds. The default is 350 seconds.</li>
             *            </ul>
             *            <p>
             *            The following attributes are only supported by Application Load Balancers.
             *            <p>
             *            <ul>
             *            <li><code>routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Serial-Number</em> HTTP request header.</li>
             *            <li><code>routing.http.request.x_amzn_mtls_clientcert_issuer.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Issuer</em> HTTP request header.</li>
             *            <li><code>routing.http.request.x_amzn_mtls_clientcert_subject.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Subject</em> HTTP request header.</li>
             *            <li><code>routing.http.request.x_amzn_mtls_clientcert_validity.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Validity</em> HTTP request header.</li>
             *            <li><code>routing.http.request.x_amzn_mtls_clientcert_leaf.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert-Leaf</em> HTTP request header.</li>
             *            <li><code>routing.http.request.x_amzn_mtls_clientcert.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Mtls-Clientcert</em> HTTP request header.</li>
             *            <li><code>routing.http.request.x_amzn_tls_version.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Tls-Version</em> HTTP request header.</li>
             *            <li><code>routing.http.request.x_amzn_tls_cipher_suite.header_name</code> - Enables you to modify the header name of the <em>X-Amzn-Tls-Cipher-Suite</em> HTTP request header.</li>
             *            <li><code>routing.http.response.server.enabled</code> - Enables you to allow or remove the HTTP response server header.</li>
             *            <li><code>routing.http.response.strict_transport_security.header_value</code> - Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS.</li>
             *            <li><code>routing.http.response.access_control_allow_origin.header_value</code> - Specifies which origins are allowed to access the server.</li>
             *            <li><code>routing.http.response.access_control_allow_methods.header_value</code> - Returns which HTTP methods are allowed when accessing the server from a different origin.</li>
             *            <li><code>routing.http.response.access_control_allow_headers.header_value</code> - Specifies which headers can be used during the request.</li>
             *            <li><code>routing.http.response.access_control_allow_credentials.header_value</code> - Indicates whether the browser should include credentials such as cookies or authentication when making requests.</li>
             *            <li><code>routing.http.response.access_control_expose_headers.header_value</code> - Returns which headers the browser can expose to the requesting client.</li>
             *            <li><code>routing.http.response.access_control_max_age.header_value</code> - Specifies how long the results of a preflight request can be cached, in seconds.</li>
             *            <li><code>routing.http.response.content_security_policy.header_value</code> - Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats.</li>
             *            <li><code>routing.http.response.x_content_type_options.header_value</code> - Indicates whether the MIME types advertised in the <em>Content-Type</em> headers should be followed and not be changed.</li>
             *            <li><code>routing.http.response.x_frame_options.header_value</code> - Indicates whether the browser is allowed to render a page in a <em>frame</em> , <em>iframe</em> , <em>embed</em> or <em>object</em> .</li>
             *            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ListenerAttributeProperty#getValue}
             * @param value The value of the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenerAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListenerAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListenerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenerAttributeProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.ListenerAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenerAttributeProperty.Jsii$Proxy that = (ListenerAttributeProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The mutual authentication configuration information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * MutualAuthenticationProperty mutualAuthenticationProperty = MutualAuthenticationProperty.builder()
     *         .advertiseTrustStoreCaNames("advertiseTrustStoreCaNames")
     *         .ignoreClientCertificateExpiry(false)
     *         .mode("mode")
     *         .trustStoreArn("trustStoreArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.MutualAuthenticationProperty")
    @software.amazon.jsii.Jsii.Proxy(MutualAuthenticationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MutualAuthenticationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether trust store CA certificate names are advertised.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html#cfn-elasticloadbalancingv2-listener-mutualauthentication-advertisetruststorecanames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html#cfn-elasticloadbalancingv2-listener-mutualauthentication-advertisetruststorecanames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdvertiseTrustStoreCaNames() {
            return null;
        }

        /**
         * Indicates whether expired client certificates are ignored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html#cfn-elasticloadbalancingv2-listener-mutualauthentication-ignoreclientcertificateexpiry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html#cfn-elasticloadbalancingv2-listener-mutualauthentication-ignoreclientcertificateexpiry</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnoreClientCertificateExpiry() {
            return null;
        }

        /**
         * The client certificate handling method.
         * <p>
         * Options are <code>off</code> , <code>passthrough</code> or <code>verify</code> . The default value is <code>off</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html#cfn-elasticloadbalancingv2-listener-mutualauthentication-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html#cfn-elasticloadbalancingv2-listener-mutualauthentication-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the trust store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html#cfn-elasticloadbalancingv2-listener-mutualauthentication-truststorearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-mutualauthentication.html#cfn-elasticloadbalancingv2-listener-mutualauthentication-truststorearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrustStoreArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MutualAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MutualAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MutualAuthenticationProperty> {
            java.lang.String advertiseTrustStoreCaNames;
            java.lang.Object ignoreClientCertificateExpiry;
            java.lang.String mode;
            java.lang.String trustStoreArn;

            /**
             * Sets the value of {@link MutualAuthenticationProperty#getAdvertiseTrustStoreCaNames}
             * @param advertiseTrustStoreCaNames Indicates whether trust store CA certificate names are advertised.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advertiseTrustStoreCaNames(java.lang.String advertiseTrustStoreCaNames) {
                this.advertiseTrustStoreCaNames = advertiseTrustStoreCaNames;
                return this;
            }

            /**
             * Sets the value of {@link MutualAuthenticationProperty#getIgnoreClientCertificateExpiry}
             * @param ignoreClientCertificateExpiry Indicates whether expired client certificates are ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreClientCertificateExpiry(java.lang.Boolean ignoreClientCertificateExpiry) {
                this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
                return this;
            }

            /**
             * Sets the value of {@link MutualAuthenticationProperty#getIgnoreClientCertificateExpiry}
             * @param ignoreClientCertificateExpiry Indicates whether expired client certificates are ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreClientCertificateExpiry(software.amazon.awscdk.IResolvable ignoreClientCertificateExpiry) {
                this.ignoreClientCertificateExpiry = ignoreClientCertificateExpiry;
                return this;
            }

            /**
             * Sets the value of {@link MutualAuthenticationProperty#getMode}
             * @param mode The client certificate handling method.
             *             Options are <code>off</code> , <code>passthrough</code> or <code>verify</code> . The default value is <code>off</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link MutualAuthenticationProperty#getTrustStoreArn}
             * @param trustStoreArn The Amazon Resource Name (ARN) of the trust store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustStoreArn(java.lang.String trustStoreArn) {
                this.trustStoreArn = trustStoreArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MutualAuthenticationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MutualAuthenticationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MutualAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MutualAuthenticationProperty {
            private final java.lang.String advertiseTrustStoreCaNames;
            private final java.lang.Object ignoreClientCertificateExpiry;
            private final java.lang.String mode;
            private final java.lang.String trustStoreArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.advertiseTrustStoreCaNames = software.amazon.jsii.Kernel.get(this, "advertiseTrustStoreCaNames", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ignoreClientCertificateExpiry = software.amazon.jsii.Kernel.get(this, "ignoreClientCertificateExpiry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trustStoreArn = software.amazon.jsii.Kernel.get(this, "trustStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.advertiseTrustStoreCaNames = builder.advertiseTrustStoreCaNames;
                this.ignoreClientCertificateExpiry = builder.ignoreClientCertificateExpiry;
                this.mode = builder.mode;
                this.trustStoreArn = builder.trustStoreArn;
            }

            @Override
            public final java.lang.String getAdvertiseTrustStoreCaNames() {
                return this.advertiseTrustStoreCaNames;
            }

            @Override
            public final java.lang.Object getIgnoreClientCertificateExpiry() {
                return this.ignoreClientCertificateExpiry;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.String getTrustStoreArn() {
                return this.trustStoreArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdvertiseTrustStoreCaNames() != null) {
                    data.set("advertiseTrustStoreCaNames", om.valueToTree(this.getAdvertiseTrustStoreCaNames()));
                }
                if (this.getIgnoreClientCertificateExpiry() != null) {
                    data.set("ignoreClientCertificateExpiry", om.valueToTree(this.getIgnoreClientCertificateExpiry()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getTrustStoreArn() != null) {
                    data.set("trustStoreArn", om.valueToTree(this.getTrustStoreArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.MutualAuthenticationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MutualAuthenticationProperty.Jsii$Proxy that = (MutualAuthenticationProperty.Jsii$Proxy) o;

                if (this.advertiseTrustStoreCaNames != null ? !this.advertiseTrustStoreCaNames.equals(that.advertiseTrustStoreCaNames) : that.advertiseTrustStoreCaNames != null) return false;
                if (this.ignoreClientCertificateExpiry != null ? !this.ignoreClientCertificateExpiry.equals(that.ignoreClientCertificateExpiry) : that.ignoreClientCertificateExpiry != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.trustStoreArn != null ? this.trustStoreArn.equals(that.trustStoreArn) : that.trustStoreArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.advertiseTrustStoreCaNames != null ? this.advertiseTrustStoreCaNames.hashCode() : 0;
                result = 31 * result + (this.ignoreClientCertificateExpiry != null ? this.ignoreClientCertificateExpiry.hashCode() : 0);
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.trustStoreArn != null ? this.trustStoreArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a redirect action.
     * <p>
     * A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not modify retain their original values.
     * <p>
     * You can reuse URI components using the following reserved keywords:
     * <p>
     * <ul>
     * <li>#{protocol}</li>
     * <li>#{host}</li>
     * <li>#{port}</li>
     * <li>#{path} (the leading "/" is removed)</li>
     * <li>#{query}</li>
     * </ul>
     * <p>
     * For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to "#{query}&amp;value=xyz".
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * RedirectConfigProperty redirectConfigProperty = RedirectConfigProperty.builder()
     *         .statusCode("statusCode")
     *         // the properties below are optional
     *         .host("host")
     *         .path("path")
     *         .port("port")
     *         .protocol("protocol")
     *         .query("query")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.RedirectConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RedirectConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP redirect code.
         * <p>
         * The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * The hostname.
         * <p>
         * This component is not percent-encoded. The hostname can contain #{host}.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
            return null;
        }

        /**
         * The absolute path, starting with the leading "/".
         * <p>
         * This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * The port.
         * <p>
         * You can specify a value from 1 to 65535 or #{port}.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * The protocol.
         * <p>
         * You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The query parameters, URL-encoded when necessary, but not percent-encoded.
         * <p>
         * Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuery() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedirectConfigProperty> {
            java.lang.String statusCode;
            java.lang.String host;
            java.lang.String path;
            java.lang.String port;
            java.lang.String protocol;
            java.lang.String query;

            /**
             * Sets the value of {@link RedirectConfigProperty#getStatusCode}
             * @param statusCode The HTTP redirect code. This parameter is required.
             *                   The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getHost}
             * @param host The hostname.
             *             This component is not percent-encoded. The hostname can contain #{host}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getPath}
             * @param path The absolute path, starting with the leading "/".
             *             This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getPort}
             * @param port The port.
             *             You can specify a value from 1 to 65535 or #{port}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getProtocol}
             * @param protocol The protocol.
             *                 You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getQuery}
             * @param query The query parameters, URL-encoded when necessary, but not percent-encoded.
             *              Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder query(java.lang.String query) {
                this.query = query;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedirectConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectConfigProperty {
            private final java.lang.String statusCode;
            private final java.lang.String host;
            private final java.lang.String path;
            private final java.lang.String port;
            private final java.lang.String protocol;
            private final java.lang.String query;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.query = software.amazon.jsii.Kernel.get(this, "query", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
                this.host = builder.host;
                this.path = builder.path;
                this.port = builder.port;
                this.protocol = builder.protocol;
                this.query = builder.query;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getQuery() {
                return this.query;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getQuery() != null) {
                    data.set("query", om.valueToTree(this.getQuery()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.RedirectConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectConfigProperty.Jsii$Proxy that = (RedirectConfigProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                return this.query != null ? this.query.equals(that.query) : that.query == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the target group stickiness for a rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * TargetGroupStickinessConfigProperty targetGroupStickinessConfigProperty = TargetGroupStickinessConfigProperty.builder()
     *         .durationSeconds(123)
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.TargetGroupStickinessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupStickinessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupStickinessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time period, in seconds, during which requests from a client should be routed to the same target group.
         * <p>
         * The range is 1-604800 seconds (7 days).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-durationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-durationseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationSeconds() {
            return null;
        }

        /**
         * Indicates whether target group stickiness is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupStickinessConfigProperty> {
            java.lang.Number durationSeconds;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getDurationSeconds}
             * @param durationSeconds The time period, in seconds, during which requests from a client should be routed to the same target group.
             *                        The range is 1-604800 seconds (7 days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationSeconds(java.lang.Number durationSeconds) {
                this.durationSeconds = durationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getEnabled}
             * @param enabled Indicates whether target group stickiness is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getEnabled}
             * @param enabled Indicates whether target group stickiness is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupStickinessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupStickinessConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupStickinessConfigProperty {
            private final java.lang.Number durationSeconds;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationSeconds = software.amazon.jsii.Kernel.get(this, "durationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationSeconds = builder.durationSeconds;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Number getDurationSeconds() {
                return this.durationSeconds;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationSeconds() != null) {
                    data.set("durationSeconds", om.valueToTree(this.getDurationSeconds()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.TargetGroupStickinessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupStickinessConfigProperty.Jsii$Proxy that = (TargetGroupStickinessConfigProperty.Jsii$Proxy) o;

                if (this.durationSeconds != null ? !this.durationSeconds.equals(that.durationSeconds) : that.durationSeconds != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationSeconds != null ? this.durationSeconds.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about how traffic will be distributed between multiple target groups in a forward rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * TargetGroupTupleProperty targetGroupTupleProperty = TargetGroupTupleProperty.builder()
     *         .targetGroupArn("targetGroupArn")
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.TargetGroupTupleProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupTupleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupTupleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the target group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-targetgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-targetgrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * The weight.
         * <p>
         * The range is 0 to 999.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupTupleProperty> {
            java.lang.String targetGroupArn;
            java.lang.Number weight;

            /**
             * Sets the value of {@link TargetGroupTupleProperty#getTargetGroupArn}
             * @param targetGroupArn The Amazon Resource Name (ARN) of the target group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupTupleProperty#getWeight}
             * @param weight The weight.
             *               The range is 0 to 999.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupTupleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupTupleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupTupleProperty {
            private final java.lang.String targetGroupArn;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetGroupArn = software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetGroupArn = builder.targetGroupArn;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListener.TargetGroupTupleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupTupleProperty.Jsii$Proxy that = (TargetGroupTupleProperty.Jsii$Proxy) o;

                if (this.targetGroupArn != null ? !this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0;
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps.Builder();
        }

        /**
         * The actions for the default rule. You cannot define a condition for a default rule.
         * <p>
         * To create additional rules for an Application Load Balancer, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html">AWS::ElasticLoadBalancingV2::ListenerRule</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions</a>
         * @param defaultActions The actions for the default rule. You cannot define a condition for a default rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultActions(final software.amazon.awscdk.IResolvable defaultActions) {
            this.props.defaultActions(defaultActions);
            return this;
        }
        /**
         * The actions for the default rule. You cannot define a condition for a default rule.
         * <p>
         * To create additional rules for an Application Load Balancer, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html">AWS::ElasticLoadBalancingV2::ListenerRule</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions</a>
         * @param defaultActions The actions for the default rule. You cannot define a condition for a default rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultActions(final java.util.List<? extends java.lang.Object> defaultActions) {
            this.props.defaultActions(defaultActions);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the load balancer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn</a>
         * @param loadBalancerArn The Amazon Resource Name (ARN) of the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(final java.lang.String loadBalancerArn) {
            this.props.loadBalancerArn(loadBalancerArn);
            return this;
        }

        /**
         * [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-alpnpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-alpnpolicy</a>
         * @param alpnPolicy [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alpnPolicy(final java.util.List<java.lang.String> alpnPolicy) {
            this.props.alpnPolicy(alpnPolicy);
            return this;
        }

        /**
         * The default SSL server certificate for a secure listener.
         * <p>
         * You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         * <p>
         * To create a certificate list for a secure listener, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html">AWS::ElasticLoadBalancingV2::ListenerCertificate</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates</a>
         * @param certificates The default SSL server certificate for a secure listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(final software.amazon.awscdk.IResolvable certificates) {
            this.props.certificates(certificates);
            return this;
        }
        /**
         * The default SSL server certificate for a secure listener.
         * <p>
         * You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         * <p>
         * To create a certificate list for a secure listener, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html">AWS::ElasticLoadBalancingV2::ListenerCertificate</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates</a>
         * @param certificates The default SSL server certificate for a secure listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(final java.util.List<? extends java.lang.Object> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        /**
         * The listener attributes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-listenerattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-listenerattributes</a>
         * @param listenerAttributes The listener attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerAttributes(final software.amazon.awscdk.IResolvable listenerAttributes) {
            this.props.listenerAttributes(listenerAttributes);
            return this;
        }
        /**
         * The listener attributes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-listenerattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-listenerattributes</a>
         * @param listenerAttributes The listener attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerAttributes(final java.util.List<? extends java.lang.Object> listenerAttributes) {
            this.props.listenerAttributes(listenerAttributes);
            return this;
        }

        /**
         * The mutual authentication configuration information.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-mutualauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-mutualauthentication</a>
         * @param mutualAuthentication The mutual authentication configuration information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualAuthentication(final software.amazon.awscdk.IResolvable mutualAuthentication) {
            this.props.mutualAuthentication(mutualAuthentication);
            return this;
        }
        /**
         * The mutual authentication configuration information.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-mutualauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-mutualauthentication</a>
         * @param mutualAuthentication The mutual authentication configuration information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualAuthentication(final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.MutualAuthenticationProperty mutualAuthentication) {
            this.props.mutualAuthentication(mutualAuthentication);
            return this;
        }

        /**
         * The port on which the load balancer is listening.
         * <p>
         * You can't specify a port for a Gateway Load Balancer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port</a>
         * @param port The port on which the load balancer is listening. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * The protocol for connections from clients to the load balancer.
         * <p>
         * For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You can't specify a protocol for a Gateway Load Balancer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol</a>
         * @param protocol The protocol for connections from clients to the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final java.lang.String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
         * <p>
         * Updating the security policy can result in interruptions if the load balancer is handling a high volume of traffic.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <em>Application Load Balancers Guide</em> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <em>Network Load Balancers Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy</a>
         * @param sslPolicy [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(final java.lang.String sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
