package software.amazon.awscdk.services.eks;

/**
 * Represents the attributes of an addon for an Amazon EKS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * AddonAttributes addonAttributes = AddonAttributes.builder()
 *         .addonName("addonName")
 *         .clusterName("clusterName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:12.075Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AddonAttributes")
@software.amazon.jsii.Jsii.Proxy(AddonAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddonAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the addon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddonName();

    /**
     * The name of the Amazon EKS cluster the addon is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * @return a {@link Builder} of {@link AddonAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddonAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddonAttributes> {
        java.lang.String addonName;
        java.lang.String clusterName;

        /**
         * Sets the value of {@link AddonAttributes#getAddonName}
         * @param addonName The name of the addon. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonName(java.lang.String addonName) {
            this.addonName = addonName;
            return this;
        }

        /**
         * Sets the value of {@link AddonAttributes#getClusterName}
         * @param clusterName The name of the Amazon EKS cluster the addon is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddonAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddonAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddonAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddonAttributes {
        private final java.lang.String addonName;
        private final java.lang.String clusterName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addonName = software.amazon.jsii.Kernel.get(this, "addonName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addonName = java.util.Objects.requireNonNull(builder.addonName, "addonName is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
        }

        @Override
        public final java.lang.String getAddonName() {
            return this.addonName;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addonName", om.valueToTree(this.getAddonName()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AddonAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddonAttributes.Jsii$Proxy that = (AddonAttributes.Jsii$Proxy) o;

            if (!addonName.equals(that.addonName)) return false;
            return this.clusterName.equals(that.clusterName);
        }

        @Override
        public final int hashCode() {
            int result = this.addonName.hashCode();
            result = 31 * result + (this.clusterName.hashCode());
            return result;
        }
    }
}
