package software.amazon.awscdk.services.ec2;

/**
 * Properties for looking up an existing managed prefix list.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationLoadBalancer alb;
 * IPrefixList cfOriginFacing = PrefixList.fromLookup(this, "CloudFrontOriginFacing", PrefixListLookupOptions.builder()
 *         .prefixListName("com.amazonaws.global.cloudfront.origin-facing")
 *         .build());
 * alb.connections.allowFrom(Peer.prefixList(cfOriginFacing.getPrefixListId()), Port.HTTP);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:11.316Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.PrefixListLookupOptions")
@software.amazon.jsii.Jsii.Proxy(PrefixListLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PrefixListLookupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the managed prefix list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrefixListName();

    /**
     * The address family of the managed prefix list.
     * <p>
     * Default: - Don't filter on addressFamily
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AddressFamily getAddressFamily() {
        return null;
    }

    /**
     * The ID of the AWS account that owns the managed prefix list.
     * <p>
     * Default: - Don't filter on ownerId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PrefixListLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PrefixListLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PrefixListLookupOptions> {
        java.lang.String prefixListName;
        software.amazon.awscdk.services.ec2.AddressFamily addressFamily;
        java.lang.String ownerId;

        /**
         * Sets the value of {@link PrefixListLookupOptions#getPrefixListName}
         * @param prefixListName The name of the managed prefix list. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixListName(java.lang.String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        /**
         * Sets the value of {@link PrefixListLookupOptions#getAddressFamily}
         * @param addressFamily The address family of the managed prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addressFamily(software.amazon.awscdk.services.ec2.AddressFamily addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        /**
         * Sets the value of {@link PrefixListLookupOptions#getOwnerId}
         * @param ownerId The ID of the AWS account that owns the managed prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerId(java.lang.String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PrefixListLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PrefixListLookupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PrefixListLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrefixListLookupOptions {
        private final java.lang.String prefixListName;
        private final software.amazon.awscdk.services.ec2.AddressFamily addressFamily;
        private final java.lang.String ownerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prefixListName = software.amazon.jsii.Kernel.get(this, "prefixListName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addressFamily = software.amazon.jsii.Kernel.get(this, "addressFamily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AddressFamily.class));
            this.ownerId = software.amazon.jsii.Kernel.get(this, "ownerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prefixListName = java.util.Objects.requireNonNull(builder.prefixListName, "prefixListName is required");
            this.addressFamily = builder.addressFamily;
            this.ownerId = builder.ownerId;
        }

        @Override
        public final java.lang.String getPrefixListName() {
            return this.prefixListName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.AddressFamily getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final java.lang.String getOwnerId() {
            return this.ownerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("prefixListName", om.valueToTree(this.getPrefixListName()));
            if (this.getAddressFamily() != null) {
                data.set("addressFamily", om.valueToTree(this.getAddressFamily()));
            }
            if (this.getOwnerId() != null) {
                data.set("ownerId", om.valueToTree(this.getOwnerId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.PrefixListLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PrefixListLookupOptions.Jsii$Proxy that = (PrefixListLookupOptions.Jsii$Proxy) o;

            if (!prefixListName.equals(that.prefixListName)) return false;
            if (this.addressFamily != null ? !this.addressFamily.equals(that.addressFamily) : that.addressFamily != null) return false;
            return this.ownerId != null ? this.ownerId.equals(that.ownerId) : that.ownerId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.prefixListName.hashCode();
            result = 31 * result + (this.addressFamily != null ? this.addressFamily.hashCode() : 0);
            result = 31 * result + (this.ownerId != null ? this.ownerId.hashCode() : 0);
            return result;
        }
    }
}
