package software.amazon.awscdk.services.dynamodb;

/**
 * The <code>AWS::DynamoDB::Table</code> resource creates a DynamoDB table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_CreateTable.html">CreateTable</a> in the <em>Amazon DynamoDB API Reference</em> .
 * <p>
 * You should be aware of the following behaviors when working with DynamoDB tables:
 * <p>
 * <ul>
 * <li>AWS CloudFormation typically creates DynamoDB tables in parallel. However, if your template includes multiple DynamoDB tables with indexes, you must declare dependencies so that the tables are created sequentially. Amazon DynamoDB limits the number of tables with secondary indexes that are in the creating state. If you create multiple tables with indexes at the same time, DynamoDB returns an error and the stack operation fails. For an example, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#aws-resource-dynamodb-table--examples--DynamoDB_Table_with_a_DependsOn_Attribute">DynamoDB Table with a DependsOn Attribute</a> .</li>
 * </ul>
 * <p>
 * <blockquote>
 * <p>
 * Our guidance is to use the latest schema documented for your AWS CloudFormation templates. This schema supports the provisioning of all table settings below. When using this schema in your AWS CloudFormation templates, please ensure that your Identity and Access Management ( IAM ) policies are updated with appropriate permissions to allow for the authorization of these setting changes.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * Object policyDocument;
 * CfnTable cfnTable = CfnTable.Builder.create(this, "MyCfnTable")
 *         .keySchema(List.of(KeySchemaProperty.builder()
 *                 .attributeName("attributeName")
 *                 .keyType("keyType")
 *                 .build()))
 *         // the properties below are optional
 *         .attributeDefinitions(List.of(AttributeDefinitionProperty.builder()
 *                 .attributeName("attributeName")
 *                 .attributeType("attributeType")
 *                 .build()))
 *         .billingMode("billingMode")
 *         .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .deletionProtectionEnabled(false)
 *         .globalSecondaryIndexes(List.of(GlobalSecondaryIndexProperty.builder()
 *                 .indexName("indexName")
 *                 .keySchema(List.of(KeySchemaProperty.builder()
 *                         .attributeName("attributeName")
 *                         .keyType("keyType")
 *                         .build()))
 *                 .projection(ProjectionProperty.builder()
 *                         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *                         .projectionType("projectionType")
 *                         .build())
 *                 // the properties below are optional
 *                 .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .onDemandThroughput(OnDemandThroughputProperty.builder()
 *                         .maxReadRequestUnits(123)
 *                         .maxWriteRequestUnits(123)
 *                         .build())
 *                 .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                         .readCapacityUnits(123)
 *                         .writeCapacityUnits(123)
 *                         .build())
 *                 .warmThroughput(WarmThroughputProperty.builder()
 *                         .readUnitsPerSecond(123)
 *                         .writeUnitsPerSecond(123)
 *                         .build())
 *                 .build()))
 *         .importSourceSpecification(ImportSourceSpecificationProperty.builder()
 *                 .inputFormat("inputFormat")
 *                 .s3BucketSource(S3BucketSourceProperty.builder()
 *                         .s3Bucket("s3Bucket")
 *                         // the properties below are optional
 *                         .s3BucketOwner("s3BucketOwner")
 *                         .s3KeyPrefix("s3KeyPrefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .inputCompressionType("inputCompressionType")
 *                 .inputFormatOptions(InputFormatOptionsProperty.builder()
 *                         .csv(CsvProperty.builder()
 *                                 .delimiter("delimiter")
 *                                 .headerList(List.of("headerList"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .kinesisStreamSpecification(KinesisStreamSpecificationProperty.builder()
 *                 .streamArn("streamArn")
 *                 // the properties below are optional
 *                 .approximateCreationDateTimePrecision("approximateCreationDateTimePrecision")
 *                 .build())
 *         .localSecondaryIndexes(List.of(LocalSecondaryIndexProperty.builder()
 *                 .indexName("indexName")
 *                 .keySchema(List.of(KeySchemaProperty.builder()
 *                         .attributeName("attributeName")
 *                         .keyType("keyType")
 *                         .build()))
 *                 .projection(ProjectionProperty.builder()
 *                         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *                         .projectionType("projectionType")
 *                         .build())
 *                 .build()))
 *         .onDemandThroughput(OnDemandThroughputProperty.builder()
 *                 .maxReadRequestUnits(123)
 *                 .maxWriteRequestUnits(123)
 *                 .build())
 *         .pointInTimeRecoverySpecification(PointInTimeRecoverySpecificationProperty.builder()
 *                 .pointInTimeRecoveryEnabled(false)
 *                 .recoveryPeriodInDays(123)
 *                 .build())
 *         .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                 .readCapacityUnits(123)
 *                 .writeCapacityUnits(123)
 *                 .build())
 *         .resourcePolicy(ResourcePolicyProperty.builder()
 *                 .policyDocument(policyDocument)
 *                 .build())
 *         .sseSpecification(SSESpecificationProperty.builder()
 *                 .sseEnabled(false)
 *                 // the properties below are optional
 *                 .kmsMasterKeyId("kmsMasterKeyId")
 *                 .sseType("sseType")
 *                 .build())
 *         .streamSpecification(StreamSpecificationProperty.builder()
 *                 .streamViewType("streamViewType")
 *                 // the properties below are optional
 *                 .resourcePolicy(ResourcePolicyProperty.builder()
 *                         .policyDocument(policyDocument)
 *                         .build())
 *                 .build())
 *         .tableClass("tableClass")
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeToLiveSpecification(TimeToLiveSpecificationProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .attributeName("attributeName")
 *                 .build())
 *         .warmThroughput(WarmThroughputProperty.builder()
 *                 .readUnitsPerSecond(123)
 *                 .writeUnitsPerSecond(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:10.526Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable")
public class CfnTable extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dynamodb.CfnTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the DynamoDB table, such as <code>arn:aws:dynamodb:us-east-2:123456789012:table/myDynamoDBTable</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the DynamoDB stream, such as <code>arn:aws:dynamodb:us-east-1:123456789012:table/testddbstack-myDynamoDBTable-012A1SL7SMP5Q/stream/2015-11-30T20:10:00.000</code> .
     * <p>
     * <blockquote>
     * <p>
     * You must specify the <code>StreamSpecification</code> property to use this attribute.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStreamArn() {
        return software.amazon.jsii.Kernel.get(this, "attrStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies the attributes that make up the primary key for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema() {
        return software.amazon.jsii.Kernel.get(this, "keySchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the attributes that make up the primary key for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeySchema(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
    }

    /**
     * Specifies the attributes that make up the primary key for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeySchema(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnTable.KeySchemaProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnTable.KeySchemaProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
    }

    /**
     * A list of attributes that describe the key schema for the table and indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAttributeDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "attributeDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of attributes that describe the key schema for the table and indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributeDefinitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributeDefinitions", value);
    }

    /**
     * A list of attributes that describe the key schema for the table and indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributeDefinitions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnTable.AttributeDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnTable.AttributeDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "attributeDefinitions", value);
    }

    /**
     * Specify how you are charged for read and write throughput and how you manage capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBillingMode() {
        return software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify how you are charged for read and write throughput and how you manage capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "billingMode", value);
    }

    /**
     * The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContributorInsightsSpecification() {
        return software.amazon.jsii.Kernel.get(this, "contributorInsightsSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContributorInsightsSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contributorInsightsSpecification", value);
    }

    /**
     * The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContributorInsightsSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.ContributorInsightsSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "contributorInsightsSpecification", value);
    }

    /**
     * Determines if a table is protected from deletion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtectionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Determines if a table is protected from deletion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtectionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtectionEnabled", value);
    }

    /**
     * Determines if a table is protected from deletion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtectionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtectionEnabled", value);
    }

    /**
     * Global secondary indexes to be created on the table.
     * <p>
     * You can create up to 20 global secondary indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGlobalSecondaryIndexes() {
        return software.amazon.jsii.Kernel.get(this, "globalSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Global secondary indexes to be created on the table.
     * <p>
     * You can create up to 20 global secondary indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalSecondaryIndexes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "globalSecondaryIndexes", value);
    }

    /**
     * Global secondary indexes to be created on the table.
     * <p>
     * You can create up to 20 global secondary indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalSecondaryIndexes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnTable.GlobalSecondaryIndexProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnTable.GlobalSecondaryIndexProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "globalSecondaryIndexes", value);
    }

    /**
     * Specifies the properties of data being imported from the S3 bucket source to the" table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getImportSourceSpecification() {
        return software.amazon.jsii.Kernel.get(this, "importSourceSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the properties of data being imported from the S3 bucket source to the" table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImportSourceSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "importSourceSpecification", value);
    }

    /**
     * Specifies the properties of data being imported from the S3 bucket source to the" table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImportSourceSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.ImportSourceSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "importSourceSpecification", value);
    }

    /**
     * The Kinesis Data Streams configuration for the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamSpecification() {
        return software.amazon.jsii.Kernel.get(this, "kinesisStreamSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Kinesis Data Streams configuration for the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisStreamSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisStreamSpecification", value);
    }

    /**
     * The Kinesis Data Streams configuration for the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisStreamSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.KinesisStreamSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisStreamSpecification", value);
    }

    /**
     * Local secondary indexes to be created on the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLocalSecondaryIndexes() {
        return software.amazon.jsii.Kernel.get(this, "localSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Local secondary indexes to be created on the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocalSecondaryIndexes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "localSecondaryIndexes", value);
    }

    /**
     * Local secondary indexes to be created on the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocalSecondaryIndexes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnTable.LocalSecondaryIndexProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnTable.LocalSecondaryIndexProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "localSecondaryIndexes", value);
    }

    /**
     * Sets the maximum number of read and write units for the specified on-demand table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandThroughput() {
        return software.amazon.jsii.Kernel.get(this, "onDemandThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Sets the maximum number of read and write units for the specified on-demand table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnDemandThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onDemandThroughput", value);
    }

    /**
     * Sets the maximum number of read and write units for the specified on-demand table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnDemandThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.OnDemandThroughputProperty value) {
        software.amazon.jsii.Kernel.set(this, "onDemandThroughput", value);
    }

    /**
     * The settings used to enable point in time recovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoverySpecification() {
        return software.amazon.jsii.Kernel.get(this, "pointInTimeRecoverySpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings used to enable point in time recovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPointInTimeRecoverySpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pointInTimeRecoverySpecification", value);
    }

    /**
     * The settings used to enable point in time recovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPointInTimeRecoverySpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "pointInTimeRecoverySpecification", value);
    }

    /**
     * Throughput for the specified table, which consists of values for <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedThroughput() {
        return software.amazon.jsii.Kernel.get(this, "provisionedThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Throughput for the specified table, which consists of values for <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "provisionedThroughput", value);
    }

    /**
     * Throughput for the specified table, which consists of values for <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty value) {
        software.amazon.jsii.Kernel.set(this, "provisionedThroughput", value);
    }

    /**
     * A resource-based policy document that contains permissions to add to the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourcePolicy() {
        return software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A resource-based policy document that contains permissions to add to the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourcePolicy", value);
    }

    /**
     * A resource-based policy document that contains permissions to add to the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.ResourcePolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourcePolicy", value);
    }

    /**
     * Specifies the settings to enable server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the settings to enable server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSseSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sseSpecification", value);
    }

    /**
     * Specifies the settings to enable server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSseSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sseSpecification", value);
    }

    /**
     * The settings for the DynamoDB table stream, which capture changes to items stored in the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStreamSpecification() {
        return software.amazon.jsii.Kernel.get(this, "streamSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for the DynamoDB table stream, which capture changes to items stored in the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "streamSpecification", value);
    }

    /**
     * The settings for the DynamoDB table stream, which capture changes to items stored in the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.StreamSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "streamSpecification", value);
    }

    /**
     * The table class of the new table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableClass() {
        return software.amazon.jsii.Kernel.get(this, "tableClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The table class of the new table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableClass(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableClass", value);
    }

    /**
     * A name for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Specifies the Time to Live (TTL) settings for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTimeToLiveSpecification() {
        return software.amazon.jsii.Kernel.get(this, "timeToLiveSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the Time to Live (TTL) settings for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeToLiveSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "timeToLiveSpecification", value);
    }

    /**
     * Specifies the Time to Live (TTL) settings for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeToLiveSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.TimeToLiveSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "timeToLiveSpecification", value);
    }

    /**
     * Represents the warm throughput (in read units per second and write units per second) for creating a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWarmThroughput() {
        return software.amazon.jsii.Kernel.get(this, "warmThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents the warm throughput (in read units per second and write units per second) for creating a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWarmThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "warmThroughput", value);
    }

    /**
     * Represents the warm throughput (in read units per second and write units per second) for creating a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWarmThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnTable.WarmThroughputProperty value) {
        software.amazon.jsii.Kernel.set(this, "warmThroughput", value);
    }
    /**
     * Represents an attribute for describing the schema for the table and indexes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * AttributeDefinitionProperty attributeDefinitionProperty = AttributeDefinitionProperty.builder()
     *         .attributeName("attributeName")
     *         .attributeType("attributeType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-attributedefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-attributedefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.AttributeDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-attributedefinition.html#cfn-dynamodb-table-attributedefinition-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-attributedefinition.html#cfn-dynamodb-table-attributedefinition-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * The data type for the attribute, where:.
         * <p>
         * <ul>
         * <li><code>S</code> - the attribute is of type String</li>
         * <li><code>N</code> - the attribute is of type Number</li>
         * <li><code>B</code> - the attribute is of type Binary</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-attributedefinition.html#cfn-dynamodb-table-attributedefinition-attributetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-attributedefinition.html#cfn-dynamodb-table-attributedefinition-attributetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeType();

        /**
         * @return a {@link Builder} of {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeDefinitionProperty> {
            java.lang.String attributeName;
            java.lang.String attributeType;

            /**
             * Sets the value of {@link AttributeDefinitionProperty#getAttributeName}
             * @param attributeName A name for the attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of {@link AttributeDefinitionProperty#getAttributeType}
             * @param attributeType The data type for the attribute, where:. This parameter is required.
             *                      <ul>
             *                      <li><code>S</code> - the attribute is of type String</li>
             *                      <li><code>N</code> - the attribute is of type Number</li>
             *                      <li><code>B</code> - the attribute is of type Binary</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeType(java.lang.String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeDefinitionProperty {
            private final java.lang.String attributeName;
            private final java.lang.String attributeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributeType = software.amazon.jsii.Kernel.get(this, "attributeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
                this.attributeType = java.util.Objects.requireNonNull(builder.attributeType, "attributeType is required");
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public final java.lang.String getAttributeType() {
                return this.attributeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeName", om.valueToTree(this.getAttributeName()));
                data.set("attributeType", om.valueToTree(this.getAttributeType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.AttributeDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeDefinitionProperty.Jsii$Proxy that = (AttributeDefinitionProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.attributeType.equals(that.attributeType);
            }

            @Override
            public final int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.attributeType.hashCode());
                return result;
            }
        }
    }
    /**
     * The settings used to enable or disable CloudWatch Contributor Insights.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ContributorInsightsSpecificationProperty contributorInsightsSpecificationProperty = ContributorInsightsSpecificationProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-contributorinsightsspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-contributorinsightsspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.ContributorInsightsSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ContributorInsightsSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContributorInsightsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-contributorinsightsspecification.html#cfn-dynamodb-table-contributorinsightsspecification-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-contributorinsightsspecification.html#cfn-dynamodb-table-contributorinsightsspecification-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link ContributorInsightsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContributorInsightsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContributorInsightsSpecificationProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link ContributorInsightsSpecificationProperty#getEnabled}
             * @param enabled Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ContributorInsightsSpecificationProperty#getEnabled}
             * @param enabled Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContributorInsightsSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContributorInsightsSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContributorInsightsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContributorInsightsSpecificationProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.ContributorInsightsSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContributorInsightsSpecificationProperty.Jsii$Proxy that = (ContributorInsightsSpecificationProperty.Jsii$Proxy) o;

                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                return result;
            }
        }
    }
    /**
     * The options for imported source files in CSV format.
     * <p>
     * The values are Delimiter and HeaderList.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * CsvProperty csvProperty = CsvProperty.builder()
     *         .delimiter("delimiter")
     *         .headerList(List.of("headerList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-csv.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-csv.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.CsvProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The delimiter used for separating items in the CSV file being imported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-csv.html#cfn-dynamodb-table-csv-delimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-csv.html#cfn-dynamodb-table-csv-delimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * List of the headers used to specify a common header for all source CSV files being imported.
         * <p>
         * If this field is specified then the first line of each CSV file is treated as data instead of the header. If this field is not specified the the first line of each CSV file is treated as the header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-csv.html#cfn-dynamodb-table-csv-headerlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-csv.html#cfn-dynamodb-table-csv-headerlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaderList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvProperty> {
            java.lang.String delimiter;
            java.util.List<java.lang.String> headerList;

            /**
             * Sets the value of {@link CsvProperty#getDelimiter}
             * @param delimiter The delimiter used for separating items in the CSV file being imported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link CsvProperty#getHeaderList}
             * @param headerList List of the headers used to specify a common header for all source CSV files being imported.
             *                   If this field is specified then the first line of each CSV file is treated as data instead of the header. If this field is not specified the the first line of each CSV file is treated as the header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerList(java.util.List<java.lang.String> headerList) {
                this.headerList = headerList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvProperty {
            private final java.lang.String delimiter;
            private final java.util.List<java.lang.String> headerList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerList = software.amazon.jsii.Kernel.get(this, "headerList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delimiter = builder.delimiter;
                this.headerList = builder.headerList;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.util.List<java.lang.String> getHeaderList() {
                return this.headerList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getHeaderList() != null) {
                    data.set("headerList", om.valueToTree(this.getHeaderList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.CsvProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvProperty.Jsii$Proxy that = (CsvProperty.Jsii$Proxy) o;

                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                return this.headerList != null ? this.headerList.equals(that.headerList) : that.headerList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.delimiter != null ? this.delimiter.hashCode() : 0;
                result = 31 * result + (this.headerList != null ? this.headerList.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the properties of a global secondary index.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * GlobalSecondaryIndexProperty globalSecondaryIndexProperty = GlobalSecondaryIndexProperty.builder()
     *         .indexName("indexName")
     *         .keySchema(List.of(KeySchemaProperty.builder()
     *                 .attributeName("attributeName")
     *                 .keyType("keyType")
     *                 .build()))
     *         .projection(ProjectionProperty.builder()
     *                 .nonKeyAttributes(List.of("nonKeyAttributes"))
     *                 .projectionType("projectionType")
     *                 .build())
     *         // the properties below are optional
     *         .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .onDemandThroughput(OnDemandThroughputProperty.builder()
     *                 .maxReadRequestUnits(123)
     *                 .maxWriteRequestUnits(123)
     *                 .build())
     *         .provisionedThroughput(ProvisionedThroughputProperty.builder()
     *                 .readCapacityUnits(123)
     *                 .writeCapacityUnits(123)
     *                 .build())
     *         .warmThroughput(WarmThroughputProperty.builder()
     *                 .readUnitsPerSecond(123)
     *                 .writeUnitsPerSecond(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.GlobalSecondaryIndexProperty")
    @software.amazon.jsii.Jsii.Proxy(GlobalSecondaryIndexProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlobalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the global secondary index.
         * <p>
         * The name must be unique among all other indexes on this table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-indexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> .
         * <p>
         * The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         * <p>
         * <blockquote>
         * <p>
         * The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-keyschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema();

        /**
         * Represents attributes that are copied (projected) from the table into the global secondary index.
         * <p>
         * These are in addition to the primary key attributes and index key attributes, which are automatically projected.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-projection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-projection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProjection();

        /**
         * The settings used to enable or disable CloudWatch Contributor Insights for the specified global secondary index.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-contributorinsightsspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-contributorinsightsspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContributorInsightsSpecification() {
            return null;
        }

        /**
         * The maximum number of read and write units for the specified global secondary index.
         * <p>
         * If you use this parameter, you must specify <code>MaxReadRequestUnits</code> , <code>MaxWriteRequestUnits</code> , or both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-ondemandthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-ondemandthroughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandThroughput() {
            return null;
        }

        /**
         * Represents the provisioned throughput settings for the specified global secondary index.
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <em>Amazon DynamoDB Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-provisionedthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-provisionedthroughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedThroughput() {
            return null;
        }

        /**
         * Represents the warm throughput value (in read units per second and write units per second) for the specified secondary index.
         * <p>
         * If you use this parameter, you must specify <code>ReadUnitsPerSecond</code> , <code>WriteUnitsPerSecond</code> , or both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-warmthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-globalsecondaryindex.html#cfn-dynamodb-table-globalsecondaryindex-warmthroughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWarmThroughput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlobalSecondaryIndexProperty> {
            java.lang.String indexName;
            java.lang.Object keySchema;
            java.lang.Object projection;
            java.lang.Object contributorInsightsSpecification;
            java.lang.Object onDemandThroughput;
            java.lang.Object provisionedThroughput;
            java.lang.Object warmThroughput;

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getIndexName}
             * @param indexName The name of the global secondary index. This parameter is required.
             *                  The name must be unique among all other indexes on this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getKeySchema}
             * @param keySchema The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> . This parameter is required.
             *                  The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySchema(software.amazon.awscdk.IResolvable keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getKeySchema}
             * @param keySchema The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> . This parameter is required.
             *                  The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySchema(java.util.List<? extends java.lang.Object> keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getProjection}
             * @param projection Represents attributes that are copied (projected) from the table into the global secondary index. This parameter is required.
             *                   These are in addition to the primary key attributes and index key attributes, which are automatically projected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projection(software.amazon.awscdk.IResolvable projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getProjection}
             * @param projection Represents attributes that are copied (projected) from the table into the global secondary index. This parameter is required.
             *                   These are in addition to the primary key attributes and index key attributes, which are automatically projected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projection(software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getContributorInsightsSpecification}
             * @param contributorInsightsSpecification The settings used to enable or disable CloudWatch Contributor Insights for the specified global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contributorInsightsSpecification(software.amazon.awscdk.IResolvable contributorInsightsSpecification) {
                this.contributorInsightsSpecification = contributorInsightsSpecification;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getContributorInsightsSpecification}
             * @param contributorInsightsSpecification The settings used to enable or disable CloudWatch Contributor Insights for the specified global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contributorInsightsSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.ContributorInsightsSpecificationProperty contributorInsightsSpecification) {
                this.contributorInsightsSpecification = contributorInsightsSpecification;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getOnDemandThroughput}
             * @param onDemandThroughput The maximum number of read and write units for the specified global secondary index.
             *                           If you use this parameter, you must specify <code>MaxReadRequestUnits</code> , <code>MaxWriteRequestUnits</code> , or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandThroughput(software.amazon.awscdk.IResolvable onDemandThroughput) {
                this.onDemandThroughput = onDemandThroughput;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getOnDemandThroughput}
             * @param onDemandThroughput The maximum number of read and write units for the specified global secondary index.
             *                           If you use this parameter, you must specify <code>MaxReadRequestUnits</code> , <code>MaxWriteRequestUnits</code> , or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandThroughput(software.amazon.awscdk.services.dynamodb.CfnTable.OnDemandThroughputProperty onDemandThroughput) {
                this.onDemandThroughput = onDemandThroughput;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getProvisionedThroughput}
             * @param provisionedThroughput Represents the provisioned throughput settings for the specified global secondary index.
             *                              For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <em>Amazon DynamoDB Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedThroughput(software.amazon.awscdk.IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getProvisionedThroughput}
             * @param provisionedThroughput Represents the provisioned throughput settings for the specified global secondary index.
             *                              For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <em>Amazon DynamoDB Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedThroughput(software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getWarmThroughput}
             * @param warmThroughput Represents the warm throughput value (in read units per second and write units per second) for the specified secondary index.
             *                       If you use this parameter, you must specify <code>ReadUnitsPerSecond</code> , <code>WriteUnitsPerSecond</code> , or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmThroughput(software.amazon.awscdk.IResolvable warmThroughput) {
                this.warmThroughput = warmThroughput;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getWarmThroughput}
             * @param warmThroughput Represents the warm throughput value (in read units per second and write units per second) for the specified secondary index.
             *                       If you use this parameter, you must specify <code>ReadUnitsPerSecond</code> , <code>WriteUnitsPerSecond</code> , or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmThroughput(software.amazon.awscdk.services.dynamodb.CfnTable.WarmThroughputProperty warmThroughput) {
                this.warmThroughput = warmThroughput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlobalSecondaryIndexProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalSecondaryIndexProperty {
            private final java.lang.String indexName;
            private final java.lang.Object keySchema;
            private final java.lang.Object projection;
            private final java.lang.Object contributorInsightsSpecification;
            private final java.lang.Object onDemandThroughput;
            private final java.lang.Object provisionedThroughput;
            private final java.lang.Object warmThroughput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keySchema = software.amazon.jsii.Kernel.get(this, "keySchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.projection = software.amazon.jsii.Kernel.get(this, "projection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contributorInsightsSpecification = software.amazon.jsii.Kernel.get(this, "contributorInsightsSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onDemandThroughput = software.amazon.jsii.Kernel.get(this, "onDemandThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.provisionedThroughput = software.amazon.jsii.Kernel.get(this, "provisionedThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.warmThroughput = software.amazon.jsii.Kernel.get(this, "warmThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.keySchema = java.util.Objects.requireNonNull(builder.keySchema, "keySchema is required");
                this.projection = java.util.Objects.requireNonNull(builder.projection, "projection is required");
                this.contributorInsightsSpecification = builder.contributorInsightsSpecification;
                this.onDemandThroughput = builder.onDemandThroughput;
                this.provisionedThroughput = builder.provisionedThroughput;
                this.warmThroughput = builder.warmThroughput;
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.Object getKeySchema() {
                return this.keySchema;
            }

            @Override
            public final java.lang.Object getProjection() {
                return this.projection;
            }

            @Override
            public final java.lang.Object getContributorInsightsSpecification() {
                return this.contributorInsightsSpecification;
            }

            @Override
            public final java.lang.Object getOnDemandThroughput() {
                return this.onDemandThroughput;
            }

            @Override
            public final java.lang.Object getProvisionedThroughput() {
                return this.provisionedThroughput;
            }

            @Override
            public final java.lang.Object getWarmThroughput() {
                return this.warmThroughput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("keySchema", om.valueToTree(this.getKeySchema()));
                data.set("projection", om.valueToTree(this.getProjection()));
                if (this.getContributorInsightsSpecification() != null) {
                    data.set("contributorInsightsSpecification", om.valueToTree(this.getContributorInsightsSpecification()));
                }
                if (this.getOnDemandThroughput() != null) {
                    data.set("onDemandThroughput", om.valueToTree(this.getOnDemandThroughput()));
                }
                if (this.getProvisionedThroughput() != null) {
                    data.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
                }
                if (this.getWarmThroughput() != null) {
                    data.set("warmThroughput", om.valueToTree(this.getWarmThroughput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.GlobalSecondaryIndexProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlobalSecondaryIndexProperty.Jsii$Proxy that = (GlobalSecondaryIndexProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!keySchema.equals(that.keySchema)) return false;
                if (!projection.equals(that.projection)) return false;
                if (this.contributorInsightsSpecification != null ? !this.contributorInsightsSpecification.equals(that.contributorInsightsSpecification) : that.contributorInsightsSpecification != null) return false;
                if (this.onDemandThroughput != null ? !this.onDemandThroughput.equals(that.onDemandThroughput) : that.onDemandThroughput != null) return false;
                if (this.provisionedThroughput != null ? !this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput != null) return false;
                return this.warmThroughput != null ? this.warmThroughput.equals(that.warmThroughput) : that.warmThroughput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.keySchema.hashCode());
                result = 31 * result + (this.projection.hashCode());
                result = 31 * result + (this.contributorInsightsSpecification != null ? this.contributorInsightsSpecification.hashCode() : 0);
                result = 31 * result + (this.onDemandThroughput != null ? this.onDemandThroughput.hashCode() : 0);
                result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
                result = 31 * result + (this.warmThroughput != null ? this.warmThroughput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the properties of data being imported from the S3 bucket source to the table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ImportSourceSpecificationProperty importSourceSpecificationProperty = ImportSourceSpecificationProperty.builder()
     *         .inputFormat("inputFormat")
     *         .s3BucketSource(S3BucketSourceProperty.builder()
     *                 .s3Bucket("s3Bucket")
     *                 // the properties below are optional
     *                 .s3BucketOwner("s3BucketOwner")
     *                 .s3KeyPrefix("s3KeyPrefix")
     *                 .build())
     *         // the properties below are optional
     *         .inputCompressionType("inputCompressionType")
     *         .inputFormatOptions(InputFormatOptionsProperty.builder()
     *                 .csv(CsvProperty.builder()
     *                         .delimiter("delimiter")
     *                         .headerList(List.of("headerList"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.ImportSourceSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImportSourceSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImportSourceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The format of the source data.
         * <p>
         * Valid values for <code>ImportFormat</code> are <code>CSV</code> , <code>DYNAMODB_JSON</code> or <code>ION</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html#cfn-dynamodb-table-importsourcespecification-inputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html#cfn-dynamodb-table-importsourcespecification-inputformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputFormat();

        /**
         * The S3 bucket that provides the source for the import.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html#cfn-dynamodb-table-importsourcespecification-s3bucketsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html#cfn-dynamodb-table-importsourcespecification-s3bucketsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3BucketSource();

        /**
         * Type of compression to be used on the input coming from the imported table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html#cfn-dynamodb-table-importsourcespecification-inputcompressiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html#cfn-dynamodb-table-importsourcespecification-inputcompressiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputCompressionType() {
            return null;
        }

        /**
         * Additional properties that specify how the input is formatted,.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html#cfn-dynamodb-table-importsourcespecification-inputformatoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-importsourcespecification.html#cfn-dynamodb-table-importsourcespecification-inputformatoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputFormatOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImportSourceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImportSourceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImportSourceSpecificationProperty> {
            java.lang.String inputFormat;
            java.lang.Object s3BucketSource;
            java.lang.String inputCompressionType;
            java.lang.Object inputFormatOptions;

            /**
             * Sets the value of {@link ImportSourceSpecificationProperty#getInputFormat}
             * @param inputFormat The format of the source data. This parameter is required.
             *                    Valid values for <code>ImportFormat</code> are <code>CSV</code> , <code>DYNAMODB_JSON</code> or <code>ION</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputFormat(java.lang.String inputFormat) {
                this.inputFormat = inputFormat;
                return this;
            }

            /**
             * Sets the value of {@link ImportSourceSpecificationProperty#getS3BucketSource}
             * @param s3BucketSource The S3 bucket that provides the source for the import. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketSource(software.amazon.awscdk.IResolvable s3BucketSource) {
                this.s3BucketSource = s3BucketSource;
                return this;
            }

            /**
             * Sets the value of {@link ImportSourceSpecificationProperty#getS3BucketSource}
             * @param s3BucketSource The S3 bucket that provides the source for the import. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketSource(software.amazon.awscdk.services.dynamodb.CfnTable.S3BucketSourceProperty s3BucketSource) {
                this.s3BucketSource = s3BucketSource;
                return this;
            }

            /**
             * Sets the value of {@link ImportSourceSpecificationProperty#getInputCompressionType}
             * @param inputCompressionType Type of compression to be used on the input coming from the imported table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputCompressionType(java.lang.String inputCompressionType) {
                this.inputCompressionType = inputCompressionType;
                return this;
            }

            /**
             * Sets the value of {@link ImportSourceSpecificationProperty#getInputFormatOptions}
             * @param inputFormatOptions Additional properties that specify how the input is formatted,.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputFormatOptions(software.amazon.awscdk.IResolvable inputFormatOptions) {
                this.inputFormatOptions = inputFormatOptions;
                return this;
            }

            /**
             * Sets the value of {@link ImportSourceSpecificationProperty#getInputFormatOptions}
             * @param inputFormatOptions Additional properties that specify how the input is formatted,.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputFormatOptions(software.amazon.awscdk.services.dynamodb.CfnTable.InputFormatOptionsProperty inputFormatOptions) {
                this.inputFormatOptions = inputFormatOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImportSourceSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImportSourceSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImportSourceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImportSourceSpecificationProperty {
            private final java.lang.String inputFormat;
            private final java.lang.Object s3BucketSource;
            private final java.lang.String inputCompressionType;
            private final java.lang.Object inputFormatOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputFormat = software.amazon.jsii.Kernel.get(this, "inputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketSource = software.amazon.jsii.Kernel.get(this, "s3BucketSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputCompressionType = software.amazon.jsii.Kernel.get(this, "inputCompressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputFormatOptions = software.amazon.jsii.Kernel.get(this, "inputFormatOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputFormat = java.util.Objects.requireNonNull(builder.inputFormat, "inputFormat is required");
                this.s3BucketSource = java.util.Objects.requireNonNull(builder.s3BucketSource, "s3BucketSource is required");
                this.inputCompressionType = builder.inputCompressionType;
                this.inputFormatOptions = builder.inputFormatOptions;
            }

            @Override
            public final java.lang.String getInputFormat() {
                return this.inputFormat;
            }

            @Override
            public final java.lang.Object getS3BucketSource() {
                return this.s3BucketSource;
            }

            @Override
            public final java.lang.String getInputCompressionType() {
                return this.inputCompressionType;
            }

            @Override
            public final java.lang.Object getInputFormatOptions() {
                return this.inputFormatOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputFormat", om.valueToTree(this.getInputFormat()));
                data.set("s3BucketSource", om.valueToTree(this.getS3BucketSource()));
                if (this.getInputCompressionType() != null) {
                    data.set("inputCompressionType", om.valueToTree(this.getInputCompressionType()));
                }
                if (this.getInputFormatOptions() != null) {
                    data.set("inputFormatOptions", om.valueToTree(this.getInputFormatOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.ImportSourceSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImportSourceSpecificationProperty.Jsii$Proxy that = (ImportSourceSpecificationProperty.Jsii$Proxy) o;

                if (!inputFormat.equals(that.inputFormat)) return false;
                if (!s3BucketSource.equals(that.s3BucketSource)) return false;
                if (this.inputCompressionType != null ? !this.inputCompressionType.equals(that.inputCompressionType) : that.inputCompressionType != null) return false;
                return this.inputFormatOptions != null ? this.inputFormatOptions.equals(that.inputFormatOptions) : that.inputFormatOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputFormat.hashCode();
                result = 31 * result + (this.s3BucketSource.hashCode());
                result = 31 * result + (this.inputCompressionType != null ? this.inputCompressionType.hashCode() : 0);
                result = 31 * result + (this.inputFormatOptions != null ? this.inputFormatOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The format options for the data that was imported into the target table.
     * <p>
     * There is one value, CsvOption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * InputFormatOptionsProperty inputFormatOptionsProperty = InputFormatOptionsProperty.builder()
     *         .csv(CsvProperty.builder()
     *                 .delimiter("delimiter")
     *                 .headerList(List.of("headerList"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-inputformatoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-inputformatoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.InputFormatOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(InputFormatOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputFormatOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The options for imported source files in CSV format.
         * <p>
         * The values are Delimiter and HeaderList.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-inputformatoptions.html#cfn-dynamodb-table-inputformatoptions-csv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-inputformatoptions.html#cfn-dynamodb-table-inputformatoptions-csv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsv() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputFormatOptionsProperty> {
            java.lang.Object csv;

            /**
             * Sets the value of {@link InputFormatOptionsProperty#getCsv}
             * @param csv The options for imported source files in CSV format.
             *            The values are Delimiter and HeaderList.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.IResolvable csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link InputFormatOptionsProperty#getCsv}
             * @param csv The options for imported source files in CSV format.
             *            The values are Delimiter and HeaderList.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.services.dynamodb.CfnTable.CsvProperty csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputFormatOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputFormatOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputFormatOptionsProperty {
            private final java.lang.Object csv;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csv = software.amazon.jsii.Kernel.get(this, "csv", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csv = builder.csv;
            }

            @Override
            public final java.lang.Object getCsv() {
                return this.csv;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsv() != null) {
                    data.set("csv", om.valueToTree(this.getCsv()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.InputFormatOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputFormatOptionsProperty.Jsii$Proxy that = (InputFormatOptionsProperty.Jsii$Proxy) o;

                return this.csv != null ? this.csv.equals(that.csv) : that.csv == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csv != null ? this.csv.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Represents <em>a single element</em> of a key schema.
     * <p>
     * A key schema specifies the attributes that make up the primary key of a table, or the key attributes of an index.
     * <p>
     * A <code>KeySchemaElement</code> represents exactly one attribute of the primary key. For example, a simple primary key would be represented by one <code>KeySchemaElement</code> (for the partition key). A composite primary key would require one <code>KeySchemaElement</code> for the partition key, and another <code>KeySchemaElement</code> for the sort key.
     * <p>
     * A <code>KeySchemaElement</code> must be a scalar, top-level attribute (not a nested attribute). The data type must be one of String, Number, or Binary. The attribute cannot be nested within a List or a Map.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * KeySchemaProperty keySchemaProperty = KeySchemaProperty.builder()
     *         .attributeName("attributeName")
     *         .keyType("keyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-keyschema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-keyschema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.KeySchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(KeySchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeySchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a key attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-keyschema.html#cfn-dynamodb-table-keyschema-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-keyschema.html#cfn-dynamodb-table-keyschema-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * The role that this key attribute will assume:.
         * <p>
         * <ul>
         * <li><code>HASH</code> - partition key</li>
         * <li><code>RANGE</code> - sort key</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The partition key of an item is also known as its <em>hash attribute</em> . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         * <p>
         * The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-keyschema.html#cfn-dynamodb-table-keyschema-keytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-keyschema.html#cfn-dynamodb-table-keyschema-keytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyType();

        /**
         * @return a {@link Builder} of {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeySchemaProperty> {
            java.lang.String attributeName;
            java.lang.String keyType;

            /**
             * Sets the value of {@link KeySchemaProperty#getAttributeName}
             * @param attributeName The name of a key attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of {@link KeySchemaProperty#getKeyType}
             * @param keyType The role that this key attribute will assume:. This parameter is required.
             *                <ul>
             *                <li><code>HASH</code> - partition key</li>
             *                <li><code>RANGE</code> - sort key</li>
             *                </ul>
             *                <p>
             *                <blockquote>
             *                <p>
             *                The partition key of an item is also known as its <em>hash attribute</em> . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                <p>
             *                The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeySchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySchemaProperty {
            private final java.lang.String attributeName;
            private final java.lang.String keyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
                this.keyType = java.util.Objects.requireNonNull(builder.keyType, "keyType is required");
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeName", om.valueToTree(this.getAttributeName()));
                data.set("keyType", om.valueToTree(this.getKeyType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.KeySchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeySchemaProperty.Jsii$Proxy that = (KeySchemaProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.keyType.equals(that.keyType);
            }

            @Override
            public final int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.keyType.hashCode());
                return result;
            }
        }
    }
    /**
     * The Kinesis Data Streams configuration for the specified table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * KinesisStreamSpecificationProperty kinesisStreamSpecificationProperty = KinesisStreamSpecificationProperty.builder()
     *         .streamArn("streamArn")
     *         // the properties below are optional
     *         .approximateCreationDateTimePrecision("approximateCreationDateTimePrecision")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-kinesisstreamspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-kinesisstreamspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.KinesisStreamSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN for a specific Kinesis data stream.
         * <p>
         * Length Constraints: Minimum length of 37. Maximum length of 1024.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-kinesisstreamspecification.html#cfn-dynamodb-table-kinesisstreamspecification-streamarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-kinesisstreamspecification.html#cfn-dynamodb-table-kinesisstreamspecification-streamarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamArn();

        /**
         * The precision for the time and date that the stream was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-kinesisstreamspecification.html#cfn-dynamodb-table-kinesisstreamspecification-approximatecreationdatetimeprecision">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-kinesisstreamspecification.html#cfn-dynamodb-table-kinesisstreamspecification-approximatecreationdatetimeprecision</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApproximateCreationDateTimePrecision() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamSpecificationProperty> {
            java.lang.String streamArn;
            java.lang.String approximateCreationDateTimePrecision;

            /**
             * Sets the value of {@link KinesisStreamSpecificationProperty#getStreamArn}
             * @param streamArn The ARN for a specific Kinesis data stream. This parameter is required.
             *                  Length Constraints: Minimum length of 37. Maximum length of 1024.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamArn(java.lang.String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisStreamSpecificationProperty#getApproximateCreationDateTimePrecision}
             * @param approximateCreationDateTimePrecision The precision for the time and date that the stream was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approximateCreationDateTimePrecision(java.lang.String approximateCreationDateTimePrecision) {
                this.approximateCreationDateTimePrecision = approximateCreationDateTimePrecision;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisStreamSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamSpecificationProperty {
            private final java.lang.String streamArn;
            private final java.lang.String approximateCreationDateTimePrecision;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamArn = software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.approximateCreationDateTimePrecision = software.amazon.jsii.Kernel.get(this, "approximateCreationDateTimePrecision", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamArn = java.util.Objects.requireNonNull(builder.streamArn, "streamArn is required");
                this.approximateCreationDateTimePrecision = builder.approximateCreationDateTimePrecision;
            }

            @Override
            public final java.lang.String getStreamArn() {
                return this.streamArn;
            }

            @Override
            public final java.lang.String getApproximateCreationDateTimePrecision() {
                return this.approximateCreationDateTimePrecision;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamArn", om.valueToTree(this.getStreamArn()));
                if (this.getApproximateCreationDateTimePrecision() != null) {
                    data.set("approximateCreationDateTimePrecision", om.valueToTree(this.getApproximateCreationDateTimePrecision()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.KinesisStreamSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamSpecificationProperty.Jsii$Proxy that = (KinesisStreamSpecificationProperty.Jsii$Proxy) o;

                if (!streamArn.equals(that.streamArn)) return false;
                return this.approximateCreationDateTimePrecision != null ? this.approximateCreationDateTimePrecision.equals(that.approximateCreationDateTimePrecision) : that.approximateCreationDateTimePrecision == null;
            }

            @Override
            public final int hashCode() {
                int result = this.streamArn.hashCode();
                result = 31 * result + (this.approximateCreationDateTimePrecision != null ? this.approximateCreationDateTimePrecision.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the properties of a local secondary index.
     * <p>
     * A local secondary index can only be created when its parent table is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * LocalSecondaryIndexProperty localSecondaryIndexProperty = LocalSecondaryIndexProperty.builder()
     *         .indexName("indexName")
     *         .keySchema(List.of(KeySchemaProperty.builder()
     *                 .attributeName("attributeName")
     *                 .keyType("keyType")
     *                 .build()))
     *         .projection(ProjectionProperty.builder()
     *                 .nonKeyAttributes(List.of("nonKeyAttributes"))
     *                 .projectionType("projectionType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-localsecondaryindex.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-localsecondaryindex.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.LocalSecondaryIndexProperty")
    @software.amazon.jsii.Jsii.Proxy(LocalSecondaryIndexProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the local secondary index.
         * <p>
         * The name must be unique among all other indexes on this table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-localsecondaryindex.html#cfn-dynamodb-table-localsecondaryindex-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-localsecondaryindex.html#cfn-dynamodb-table-localsecondaryindex-indexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> .
         * <p>
         * The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         * <p>
         * <blockquote>
         * <p>
         * The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-localsecondaryindex.html#cfn-dynamodb-table-localsecondaryindex-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-localsecondaryindex.html#cfn-dynamodb-table-localsecondaryindex-keyschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema();

        /**
         * Represents attributes that are copied (projected) from the table into the local secondary index.
         * <p>
         * These are in addition to the primary key attributes and index key attributes, which are automatically projected.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-localsecondaryindex.html#cfn-dynamodb-table-localsecondaryindex-projection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-localsecondaryindex.html#cfn-dynamodb-table-localsecondaryindex-projection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProjection();

        /**
         * @return a {@link Builder} of {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocalSecondaryIndexProperty> {
            java.lang.String indexName;
            java.lang.Object keySchema;
            java.lang.Object projection;

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getIndexName}
             * @param indexName The name of the local secondary index. This parameter is required.
             *                  The name must be unique among all other indexes on this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getKeySchema}
             * @param keySchema The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> . This parameter is required.
             *                  The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySchema(software.amazon.awscdk.IResolvable keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getKeySchema}
             * @param keySchema The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> . This parameter is required.
             *                  The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySchema(java.util.List<? extends java.lang.Object> keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getProjection}
             * @param projection Represents attributes that are copied (projected) from the table into the local secondary index. This parameter is required.
             *                   These are in addition to the primary key attributes and index key attributes, which are automatically projected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projection(software.amazon.awscdk.IResolvable projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getProjection}
             * @param projection Represents attributes that are copied (projected) from the table into the local secondary index. This parameter is required.
             *                   These are in addition to the primary key attributes and index key attributes, which are automatically projected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projection(software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocalSecondaryIndexProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalSecondaryIndexProperty {
            private final java.lang.String indexName;
            private final java.lang.Object keySchema;
            private final java.lang.Object projection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keySchema = software.amazon.jsii.Kernel.get(this, "keySchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.projection = software.amazon.jsii.Kernel.get(this, "projection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.keySchema = java.util.Objects.requireNonNull(builder.keySchema, "keySchema is required");
                this.projection = java.util.Objects.requireNonNull(builder.projection, "projection is required");
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.Object getKeySchema() {
                return this.keySchema;
            }

            @Override
            public final java.lang.Object getProjection() {
                return this.projection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("keySchema", om.valueToTree(this.getKeySchema()));
                data.set("projection", om.valueToTree(this.getProjection()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.LocalSecondaryIndexProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocalSecondaryIndexProperty.Jsii$Proxy that = (LocalSecondaryIndexProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!keySchema.equals(that.keySchema)) return false;
                return this.projection.equals(that.projection);
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.keySchema.hashCode());
                result = 31 * result + (this.projection.hashCode());
                return result;
            }
        }
    }
    /**
     * Sets the maximum number of read and write units for the specified on-demand table.
     * <p>
     * If you use this property, you must specify <code>MaxReadRequestUnits</code> , <code>MaxWriteRequestUnits</code> , or both.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * OnDemandThroughputProperty onDemandThroughputProperty = OnDemandThroughputProperty.builder()
     *         .maxReadRequestUnits(123)
     *         .maxWriteRequestUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ondemandthroughput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ondemandthroughput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.OnDemandThroughputProperty")
    @software.amazon.jsii.Jsii.Proxy(OnDemandThroughputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnDemandThroughputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of read request units for the specified table.
         * <p>
         * To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of <code>MaxReadRequestUnits</code> as greater than or equal to 1. To remove the maximum <code>OnDemandThroughput</code> that is currently set on your table, set the value of <code>MaxReadRequestUnits</code> to -1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ondemandthroughput.html#cfn-dynamodb-table-ondemandthroughput-maxreadrequestunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ondemandthroughput.html#cfn-dynamodb-table-ondemandthroughput-maxreadrequestunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReadRequestUnits() {
            return null;
        }

        /**
         * Maximum number of write request units for the specified table.
         * <p>
         * To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of <code>MaxWriteRequestUnits</code> as greater than or equal to 1. To remove the maximum <code>OnDemandThroughput</code> that is currently set on your table, set the value of <code>MaxWriteRequestUnits</code> to -1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ondemandthroughput.html#cfn-dynamodb-table-ondemandthroughput-maxwriterequestunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ondemandthroughput.html#cfn-dynamodb-table-ondemandthroughput-maxwriterequestunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxWriteRequestUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnDemandThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnDemandThroughputProperty> {
            java.lang.Number maxReadRequestUnits;
            java.lang.Number maxWriteRequestUnits;

            /**
             * Sets the value of {@link OnDemandThroughputProperty#getMaxReadRequestUnits}
             * @param maxReadRequestUnits Maximum number of read request units for the specified table.
             *                            To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of <code>MaxReadRequestUnits</code> as greater than or equal to 1. To remove the maximum <code>OnDemandThroughput</code> that is currently set on your table, set the value of <code>MaxReadRequestUnits</code> to -1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxReadRequestUnits(java.lang.Number maxReadRequestUnits) {
                this.maxReadRequestUnits = maxReadRequestUnits;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandThroughputProperty#getMaxWriteRequestUnits}
             * @param maxWriteRequestUnits Maximum number of write request units for the specified table.
             *                             To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of <code>MaxWriteRequestUnits</code> as greater than or equal to 1. To remove the maximum <code>OnDemandThroughput</code> that is currently set on your table, set the value of <code>MaxWriteRequestUnits</code> to -1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxWriteRequestUnits(java.lang.Number maxWriteRequestUnits) {
                this.maxWriteRequestUnits = maxWriteRequestUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnDemandThroughputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnDemandThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandThroughputProperty {
            private final java.lang.Number maxReadRequestUnits;
            private final java.lang.Number maxWriteRequestUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxReadRequestUnits = software.amazon.jsii.Kernel.get(this, "maxReadRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxWriteRequestUnits = software.amazon.jsii.Kernel.get(this, "maxWriteRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxReadRequestUnits = builder.maxReadRequestUnits;
                this.maxWriteRequestUnits = builder.maxWriteRequestUnits;
            }

            @Override
            public final java.lang.Number getMaxReadRequestUnits() {
                return this.maxReadRequestUnits;
            }

            @Override
            public final java.lang.Number getMaxWriteRequestUnits() {
                return this.maxWriteRequestUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxReadRequestUnits() != null) {
                    data.set("maxReadRequestUnits", om.valueToTree(this.getMaxReadRequestUnits()));
                }
                if (this.getMaxWriteRequestUnits() != null) {
                    data.set("maxWriteRequestUnits", om.valueToTree(this.getMaxWriteRequestUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.OnDemandThroughputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandThroughputProperty.Jsii$Proxy that = (OnDemandThroughputProperty.Jsii$Proxy) o;

                if (this.maxReadRequestUnits != null ? !this.maxReadRequestUnits.equals(that.maxReadRequestUnits) : that.maxReadRequestUnits != null) return false;
                return this.maxWriteRequestUnits != null ? this.maxWriteRequestUnits.equals(that.maxWriteRequestUnits) : that.maxWriteRequestUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxReadRequestUnits != null ? this.maxReadRequestUnits.hashCode() : 0;
                result = 31 * result + (this.maxWriteRequestUnits != null ? this.maxWriteRequestUnits.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings used to enable point in time recovery.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * PointInTimeRecoverySpecificationProperty pointInTimeRecoverySpecificationProperty = PointInTimeRecoverySpecificationProperty.builder()
     *         .pointInTimeRecoveryEnabled(false)
     *         .recoveryPeriodInDays(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PointInTimeRecoverySpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PointInTimeRecoverySpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoveryEnabled() {
            return null;
        }

        /**
         * The number of preceding days for which continuous backups are taken and maintained.
         * <p>
         * Your table data is only recoverable to any point-in-time from within the configured recovery period. This parameter is optional. If no value is provided, the value will default to 35.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-recoveryperiodindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-recoveryperiodindays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRecoveryPeriodInDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PointInTimeRecoverySpecificationProperty> {
            java.lang.Object pointInTimeRecoveryEnabled;
            java.lang.Number recoveryPeriodInDays;

            /**
             * Sets the value of {@link PointInTimeRecoverySpecificationProperty#getPointInTimeRecoveryEnabled}
             * @param pointInTimeRecoveryEnabled Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pointInTimeRecoveryEnabled(java.lang.Boolean pointInTimeRecoveryEnabled) {
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PointInTimeRecoverySpecificationProperty#getPointInTimeRecoveryEnabled}
             * @param pointInTimeRecoveryEnabled Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pointInTimeRecoveryEnabled(software.amazon.awscdk.IResolvable pointInTimeRecoveryEnabled) {
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PointInTimeRecoverySpecificationProperty#getRecoveryPeriodInDays}
             * @param recoveryPeriodInDays The number of preceding days for which continuous backups are taken and maintained.
             *                             Your table data is only recoverable to any point-in-time from within the configured recovery period. This parameter is optional. If no value is provided, the value will default to 35.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryPeriodInDays(java.lang.Number recoveryPeriodInDays) {
                this.recoveryPeriodInDays = recoveryPeriodInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PointInTimeRecoverySpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PointInTimeRecoverySpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PointInTimeRecoverySpecificationProperty {
            private final java.lang.Object pointInTimeRecoveryEnabled;
            private final java.lang.Number recoveryPeriodInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pointInTimeRecoveryEnabled = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoveryEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recoveryPeriodInDays = software.amazon.jsii.Kernel.get(this, "recoveryPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pointInTimeRecoveryEnabled = builder.pointInTimeRecoveryEnabled;
                this.recoveryPeriodInDays = builder.recoveryPeriodInDays;
            }

            @Override
            public final java.lang.Object getPointInTimeRecoveryEnabled() {
                return this.pointInTimeRecoveryEnabled;
            }

            @Override
            public final java.lang.Number getRecoveryPeriodInDays() {
                return this.recoveryPeriodInDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPointInTimeRecoveryEnabled() != null) {
                    data.set("pointInTimeRecoveryEnabled", om.valueToTree(this.getPointInTimeRecoveryEnabled()));
                }
                if (this.getRecoveryPeriodInDays() != null) {
                    data.set("recoveryPeriodInDays", om.valueToTree(this.getRecoveryPeriodInDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PointInTimeRecoverySpecificationProperty.Jsii$Proxy that = (PointInTimeRecoverySpecificationProperty.Jsii$Proxy) o;

                if (this.pointInTimeRecoveryEnabled != null ? !this.pointInTimeRecoveryEnabled.equals(that.pointInTimeRecoveryEnabled) : that.pointInTimeRecoveryEnabled != null) return false;
                return this.recoveryPeriodInDays != null ? this.recoveryPeriodInDays.equals(that.recoveryPeriodInDays) : that.recoveryPeriodInDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pointInTimeRecoveryEnabled != null ? this.pointInTimeRecoveryEnabled.hashCode() : 0;
                result = 31 * result + (this.recoveryPeriodInDays != null ? this.recoveryPeriodInDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents attributes that are copied (projected) from the table into an index.
     * <p>
     * These are in addition to the primary key attributes and index key attributes, which are automatically projected.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ProjectionProperty projectionProperty = ProjectionProperty.builder()
     *         .nonKeyAttributes(List.of("nonKeyAttributes"))
     *         .projectionType("projectionType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-projection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-projection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.ProjectionProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents the non-key attribute names which will be projected into the index.
         * <p>
         * For global and local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total. This limit only applies when you specify the ProjectionType of <code>INCLUDE</code> . You still can specify the ProjectionType of <code>ALL</code> to project all attributes from the source table, even if the table has more than 100 attributes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-projection.html#cfn-dynamodb-table-projection-nonkeyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-projection.html#cfn-dynamodb-table-projection-nonkeyattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNonKeyAttributes() {
            return null;
        }

        /**
         * The set of attributes that are projected into the index:.
         * <p>
         * <ul>
         * <li><code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</li>
         * <li><code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code> , the secondary index will include other non-key attributes that you specify.</li>
         * <li><code>ALL</code> - All of the table attributes are projected into the index.</li>
         * </ul>
         * <p>
         * When using the DynamoDB console, <code>ALL</code> is selected by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-projection.html#cfn-dynamodb-table-projection-projectiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-projection.html#cfn-dynamodb-table-projection-projectiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProjectionType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectionProperty> {
            java.util.List<java.lang.String> nonKeyAttributes;
            java.lang.String projectionType;

            /**
             * Sets the value of {@link ProjectionProperty#getNonKeyAttributes}
             * @param nonKeyAttributes Represents the non-key attribute names which will be projected into the index.
             *                         For global and local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total. This limit only applies when you specify the ProjectionType of <code>INCLUDE</code> . You still can specify the ProjectionType of <code>ALL</code> to project all attributes from the source table, even if the table has more than 100 attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonKeyAttributes(java.util.List<java.lang.String> nonKeyAttributes) {
                this.nonKeyAttributes = nonKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ProjectionProperty#getProjectionType}
             * @param projectionType The set of attributes that are projected into the index:.
             *                       <ul>
             *                       <li><code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</li>
             *                       <li><code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code> , the secondary index will include other non-key attributes that you specify.</li>
             *                       <li><code>ALL</code> - All of the table attributes are projected into the index.</li>
             *                       </ul>
             *                       <p>
             *                       When using the DynamoDB console, <code>ALL</code> is selected by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectionType(java.lang.String projectionType) {
                this.projectionType = projectionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectionProperty {
            private final java.util.List<java.lang.String> nonKeyAttributes;
            private final java.lang.String projectionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nonKeyAttributes = software.amazon.jsii.Kernel.get(this, "nonKeyAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.projectionType = software.amazon.jsii.Kernel.get(this, "projectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nonKeyAttributes = builder.nonKeyAttributes;
                this.projectionType = builder.projectionType;
            }

            @Override
            public final java.util.List<java.lang.String> getNonKeyAttributes() {
                return this.nonKeyAttributes;
            }

            @Override
            public final java.lang.String getProjectionType() {
                return this.projectionType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNonKeyAttributes() != null) {
                    data.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
                }
                if (this.getProjectionType() != null) {
                    data.set("projectionType", om.valueToTree(this.getProjectionType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.ProjectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectionProperty.Jsii$Proxy that = (ProjectionProperty.Jsii$Proxy) o;

                if (this.nonKeyAttributes != null ? !this.nonKeyAttributes.equals(that.nonKeyAttributes) : that.nonKeyAttributes != null) return false;
                return this.projectionType != null ? this.projectionType.equals(that.projectionType) : that.projectionType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nonKeyAttributes != null ? this.nonKeyAttributes.hashCode() : 0;
                result = 31 * result + (this.projectionType != null ? this.projectionType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Throughput for the specified table, which consists of values for <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> .
     * <p>
     * For more information about the contents of a provisioned throughput structure, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html">Amazon DynamoDB Table ProvisionedThroughput</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ProvisionedThroughputProperty provisionedThroughputProperty = ProvisionedThroughputProperty.builder()
     *         .readCapacityUnits(123)
     *         .writeCapacityUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-provisionedthroughput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-provisionedthroughput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.ProvisionedThroughputProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedThroughputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html">Specifying Read and Write Requirements</a> in the <em>Amazon DynamoDB Developer Guide</em> .
         * <p>
         * If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-provisionedthroughput.html#cfn-dynamodb-table-provisionedthroughput-readcapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-provisionedthroughput.html#cfn-dynamodb-table-provisionedthroughput-readcapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getReadCapacityUnits();

        /**
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html">Specifying Read and Write Requirements</a> in the <em>Amazon DynamoDB Developer Guide</em> .
         * <p>
         * If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-provisionedthroughput.html#cfn-dynamodb-table-provisionedthroughput-writecapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-provisionedthroughput.html#cfn-dynamodb-table-provisionedthroughput-writecapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWriteCapacityUnits();

        /**
         * @return a {@link Builder} of {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedThroughputProperty> {
            java.lang.Number readCapacityUnits;
            java.lang.Number writeCapacityUnits;

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getReadCapacityUnits}
             * @param readCapacityUnits The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code> . This parameter is required.
             *                          For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html">Specifying Read and Write Requirements</a> in the <em>Amazon DynamoDB Developer Guide</em> .
             *                          <p>
             *                          If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityUnits(java.lang.Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getWriteCapacityUnits}
             * @param writeCapacityUnits The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code> . This parameter is required.
             *                           For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html">Specifying Read and Write Requirements</a> in the <em>Amazon DynamoDB Developer Guide</em> .
             *                           <p>
             *                           If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeCapacityUnits(java.lang.Number writeCapacityUnits) {
                this.writeCapacityUnits = writeCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedThroughputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedThroughputProperty {
            private final java.lang.Number readCapacityUnits;
            private final java.lang.Number writeCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.readCapacityUnits = software.amazon.jsii.Kernel.get(this, "readCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.writeCapacityUnits = software.amazon.jsii.Kernel.get(this, "writeCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readCapacityUnits = java.util.Objects.requireNonNull(builder.readCapacityUnits, "readCapacityUnits is required");
                this.writeCapacityUnits = java.util.Objects.requireNonNull(builder.writeCapacityUnits, "writeCapacityUnits is required");
            }

            @Override
            public final java.lang.Number getReadCapacityUnits() {
                return this.readCapacityUnits;
            }

            @Override
            public final java.lang.Number getWriteCapacityUnits() {
                return this.writeCapacityUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("readCapacityUnits", om.valueToTree(this.getReadCapacityUnits()));
                data.set("writeCapacityUnits", om.valueToTree(this.getWriteCapacityUnits()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.ProvisionedThroughputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedThroughputProperty.Jsii$Proxy that = (ProvisionedThroughputProperty.Jsii$Proxy) o;

                if (!readCapacityUnits.equals(that.readCapacityUnits)) return false;
                return this.writeCapacityUnits.equals(that.writeCapacityUnits);
            }

            @Override
            public final int hashCode() {
                int result = this.readCapacityUnits.hashCode();
                result = 31 * result + (this.writeCapacityUnits.hashCode());
                return result;
            }
        }
    }
    /**
     * Creates or updates a resource-based policy document that contains the permissions for DynamoDB resources, such as a table, its indexes, and stream.
     * <p>
     * Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
     * <p>
     * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
     * <p>
     * While defining resource-based policies in your CloudFormation templates, the following considerations apply:
     * <p>
     * <ul>
     * <li>The maximum size supported for a resource-based policy document in JSON format is 20 KB. DynamoDB counts whitespaces when calculating the size of a policy against this limit.</li>
     * <li>Resource-based policies don't support <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html#">drift detection</a> . If you update a policy outside of the CloudFormation stack template, you'll need to update the CloudFormation stack with the changes.</li>
     * <li>Resource-based policies don't support out-of-band changes. If you add, update, or delete a policy outside of the CloudFormation template, the change won't be overwritten if there are no changes to the policy within the template.</li>
     * </ul>
     * <p>
     * For example, say that your template contains a resource-based policy, which you later update outside of the template. If you don't make any changes to the policy in the template, the updated policy in DynamoDB won’t be synced with the policy in the template.
     * <p>
     * Conversely, say that your template doesn’t contain a resource-based policy, but you add a policy outside of the template. This policy won’t be removed from DynamoDB as long as you don’t add it to the template. When you add a policy to the template and update the stack, the existing policy in DynamoDB will be updated to match the one defined in the template.
     * <p>
     * For a full list of all considerations, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html">Resource-based policy considerations</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * Object policyDocument;
     * ResourcePolicyProperty resourcePolicyProperty = ResourcePolicyProperty.builder()
     *         .policyDocument(policyDocument)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-resourcepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-resourcepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.ResourcePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A resource-based policy document that contains permissions to add to the specified DynamoDB table, index, or both.
         * <p>
         * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-resourcepolicy.html#cfn-dynamodb-table-resourcepolicy-policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-resourcepolicy.html#cfn-dynamodb-table-resourcepolicy-policydocument</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDocument();

        /**
         * @return a {@link Builder} of {@link ResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePolicyProperty> {
            java.lang.Object policyDocument;

            /**
             * Sets the value of {@link ResourcePolicyProperty#getPolicyDocument}
             * @param policyDocument A resource-based policy document that contains permissions to add to the specified DynamoDB table, index, or both. This parameter is required.
             *                       In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyDocument(java.lang.Object policyDocument) {
                this.policyDocument = policyDocument;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePolicyProperty {
            private final java.lang.Object policyDocument;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyDocument = java.util.Objects.requireNonNull(builder.policyDocument, "policyDocument is required");
            }

            @Override
            public final java.lang.Object getPolicyDocument() {
                return this.policyDocument;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.ResourcePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePolicyProperty.Jsii$Proxy that = (ResourcePolicyProperty.Jsii$Proxy) o;

                return this.policyDocument.equals(that.policyDocument);
            }

            @Override
            public final int hashCode() {
                int result = this.policyDocument.hashCode();
                return result;
            }
        }
    }
    /**
     * The S3 bucket that is being imported from.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * S3BucketSourceProperty s3BucketSourceProperty = S3BucketSourceProperty.builder()
     *         .s3Bucket("s3Bucket")
     *         // the properties below are optional
     *         .s3BucketOwner("s3BucketOwner")
     *         .s3KeyPrefix("s3KeyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-s3bucketsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-s3bucketsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.S3BucketSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(S3BucketSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3BucketSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket that is being imported from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-s3bucketsource.html#cfn-dynamodb-table-s3bucketsource-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-s3bucketsource.html#cfn-dynamodb-table-s3bucketsource-s3bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * The account number of the S3 bucket that is being imported from.
         * <p>
         * If the bucket is owned by the requester this is optional.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-s3bucketsource.html#cfn-dynamodb-table-s3bucketsource-s3bucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-s3bucketsource.html#cfn-dynamodb-table-s3bucketsource-s3bucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketOwner() {
            return null;
        }

        /**
         * The key prefix shared by all S3 Objects that are being imported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-s3bucketsource.html#cfn-dynamodb-table-s3bucketsource-s3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-s3bucketsource.html#cfn-dynamodb-table-s3bucketsource-s3keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3BucketSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3BucketSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3BucketSourceProperty> {
            java.lang.String s3Bucket;
            java.lang.String s3BucketOwner;
            java.lang.String s3KeyPrefix;

            /**
             * Sets the value of {@link S3BucketSourceProperty#getS3Bucket}
             * @param s3Bucket The S3 bucket that is being imported from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketSourceProperty#getS3BucketOwner}
             * @param s3BucketOwner The account number of the S3 bucket that is being imported from.
             *                      If the bucket is owned by the requester this is optional.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketOwner(java.lang.String s3BucketOwner) {
                this.s3BucketOwner = s3BucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketSourceProperty#getS3KeyPrefix}
             * @param s3KeyPrefix The key prefix shared by all S3 Objects that are being imported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3BucketSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3BucketSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3BucketSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3BucketSourceProperty {
            private final java.lang.String s3Bucket;
            private final java.lang.String s3BucketOwner;
            private final java.lang.String s3KeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketOwner = software.amazon.jsii.Kernel.get(this, "s3BucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.s3BucketOwner = builder.s3BucketOwner;
                this.s3KeyPrefix = builder.s3KeyPrefix;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getS3BucketOwner() {
                return this.s3BucketOwner;
            }

            @Override
            public final java.lang.String getS3KeyPrefix() {
                return this.s3KeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                if (this.getS3BucketOwner() != null) {
                    data.set("s3BucketOwner", om.valueToTree(this.getS3BucketOwner()));
                }
                if (this.getS3KeyPrefix() != null) {
                    data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.S3BucketSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3BucketSourceProperty.Jsii$Proxy that = (S3BucketSourceProperty.Jsii$Proxy) o;

                if (!s3Bucket.equals(that.s3Bucket)) return false;
                if (this.s3BucketOwner != null ? !this.s3BucketOwner.equals(that.s3BucketOwner) : that.s3BucketOwner != null) return false;
                return this.s3KeyPrefix != null ? this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Bucket.hashCode();
                result = 31 * result + (this.s3BucketOwner != null ? this.s3BucketOwner.hashCode() : 0);
                result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the settings used to enable server-side encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * SSESpecificationProperty sSESpecificationProperty = SSESpecificationProperty.builder()
     *         .sseEnabled(false)
     *         // the properties below are optional
     *         .kmsMasterKeyId("kmsMasterKeyId")
     *         .sseType("sseType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.SSESpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SSESpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SSESpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether server-side encryption is done using an AWS managed key or an AWS owned key.
         * <p>
         * If enabled (true), server-side encryption type is set to <code>KMS</code> and an AWS managed key is used ( AWS KMS charges apply). If disabled (false) or not specified, server-side encryption is set to AWS owned key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSseEnabled();

        /**
         * The AWS KMS key that should be used for the AWS KMS encryption.
         * <p>
         * To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-kmsmasterkeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-kmsmasterkeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
            return null;
        }

        /**
         * Server-side encryption type. The only supported value is:.
         * <p>
         * <ul>
         * <li><code>KMS</code> - Server-side encryption that uses AWS Key Management Service . The key is stored in your account and is managed by AWS KMS ( AWS KMS charges apply).</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-ssetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-ssetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSseType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SSESpecificationProperty> {
            java.lang.Object sseEnabled;
            java.lang.String kmsMasterKeyId;
            java.lang.String sseType;

            /**
             * Sets the value of {@link SSESpecificationProperty#getSseEnabled}
             * @param sseEnabled Indicates whether server-side encryption is done using an AWS managed key or an AWS owned key. This parameter is required.
             *                   If enabled (true), server-side encryption type is set to <code>KMS</code> and an AWS managed key is used ( AWS KMS charges apply). If disabled (false) or not specified, server-side encryption is set to AWS owned key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseEnabled(java.lang.Boolean sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SSESpecificationProperty#getSseEnabled}
             * @param sseEnabled Indicates whether server-side encryption is done using an AWS managed key or an AWS owned key. This parameter is required.
             *                   If enabled (true), server-side encryption type is set to <code>KMS</code> and an AWS managed key is used ( AWS KMS charges apply). If disabled (false) or not specified, server-side encryption is set to AWS owned key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseEnabled(software.amazon.awscdk.IResolvable sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SSESpecificationProperty#getKmsMasterKeyId}
             * @param kmsMasterKeyId The AWS KMS key that should be used for the AWS KMS encryption.
             *                       To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            /**
             * Sets the value of {@link SSESpecificationProperty#getSseType}
             * @param sseType Server-side encryption type. The only supported value is:.
             *                <ul>
             *                <li><code>KMS</code> - Server-side encryption that uses AWS Key Management Service . The key is stored in your account and is managed by AWS KMS ( AWS KMS charges apply).</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseType(java.lang.String sseType) {
                this.sseType = sseType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSESpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SSESpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SSESpecificationProperty {
            private final java.lang.Object sseEnabled;
            private final java.lang.String kmsMasterKeyId;
            private final java.lang.String sseType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sseEnabled = software.amazon.jsii.Kernel.get(this, "sseEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsMasterKeyId = software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sseType = software.amazon.jsii.Kernel.get(this, "sseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseEnabled = java.util.Objects.requireNonNull(builder.sseEnabled, "sseEnabled is required");
                this.kmsMasterKeyId = builder.kmsMasterKeyId;
                this.sseType = builder.sseType;
            }

            @Override
            public final java.lang.Object getSseEnabled() {
                return this.sseEnabled;
            }

            @Override
            public final java.lang.String getKmsMasterKeyId() {
                return this.kmsMasterKeyId;
            }

            @Override
            public final java.lang.String getSseType() {
                return this.sseType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sseEnabled", om.valueToTree(this.getSseEnabled()));
                if (this.getKmsMasterKeyId() != null) {
                    data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
                }
                if (this.getSseType() != null) {
                    data.set("sseType", om.valueToTree(this.getSseType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.SSESpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SSESpecificationProperty.Jsii$Proxy that = (SSESpecificationProperty.Jsii$Proxy) o;

                if (!sseEnabled.equals(that.sseEnabled)) return false;
                if (this.kmsMasterKeyId != null ? !this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId != null) return false;
                return this.sseType != null ? this.sseType.equals(that.sseType) : that.sseType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sseEnabled.hashCode();
                result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
                result = 31 * result + (this.sseType != null ? this.sseType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the DynamoDB Streams configuration for a table in DynamoDB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * Object policyDocument;
     * StreamSpecificationProperty streamSpecificationProperty = StreamSpecificationProperty.builder()
     *         .streamViewType("streamViewType")
     *         // the properties below are optional
     *         .resourcePolicy(ResourcePolicyProperty.builder()
     *                 .policyDocument(policyDocument)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-streamspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-streamspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.StreamSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table.
         * <p>
         * Valid values for <code>StreamViewType</code> are:
         * <p>
         * <ul>
         * <li><code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</li>
         * <li><code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</li>
         * <li><code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</li>
         * <li><code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-streamspecification.html#cfn-dynamodb-table-streamspecification-streamviewtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-streamspecification.html#cfn-dynamodb-table-streamspecification-streamviewtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamViewType();

        /**
         * Creates or updates a resource-based policy document that contains the permissions for DynamoDB resources, such as a table's streams.
         * <p>
         * Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
         * <p>
         * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-streamspecification.html#cfn-dynamodb-table-streamspecification-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-streamspecification.html#cfn-dynamodb-table-streamspecification-resourcepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourcePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamSpecificationProperty> {
            java.lang.String streamViewType;
            java.lang.Object resourcePolicy;

            /**
             * Sets the value of {@link StreamSpecificationProperty#getStreamViewType}
             * @param streamViewType When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table. This parameter is required.
             *                       Valid values for <code>StreamViewType</code> are:
             *                       <p>
             *                       <ul>
             *                       <li><code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</li>
             *                       <li><code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</li>
             *                       <li><code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</li>
             *                       <li><code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamViewType(java.lang.String streamViewType) {
                this.streamViewType = streamViewType;
                return this;
            }

            /**
             * Sets the value of {@link StreamSpecificationProperty#getResourcePolicy}
             * @param resourcePolicy Creates or updates a resource-based policy document that contains the permissions for DynamoDB resources, such as a table's streams.
             *                       Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
             *                       <p>
             *                       In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.IResolvable resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Sets the value of {@link StreamSpecificationProperty#getResourcePolicy}
             * @param resourcePolicy Creates or updates a resource-based policy document that contains the permissions for DynamoDB resources, such as a table's streams.
             *                       Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
             *                       <p>
             *                       In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.services.dynamodb.CfnTable.ResourcePolicyProperty resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamSpecificationProperty {
            private final java.lang.String streamViewType;
            private final java.lang.Object resourcePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamViewType = software.amazon.jsii.Kernel.get(this, "streamViewType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamViewType = java.util.Objects.requireNonNull(builder.streamViewType, "streamViewType is required");
                this.resourcePolicy = builder.resourcePolicy;
            }

            @Override
            public final java.lang.String getStreamViewType() {
                return this.streamViewType;
            }

            @Override
            public final java.lang.Object getResourcePolicy() {
                return this.resourcePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamViewType", om.valueToTree(this.getStreamViewType()));
                if (this.getResourcePolicy() != null) {
                    data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.StreamSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamSpecificationProperty.Jsii$Proxy that = (StreamSpecificationProperty.Jsii$Proxy) o;

                if (!streamViewType.equals(that.streamViewType)) return false;
                return this.resourcePolicy != null ? this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.streamViewType.hashCode();
                result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the settings used to enable or disable Time to Live (TTL) for the specified table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * TimeToLiveSpecificationProperty timeToLiveSpecificationProperty = TimeToLiveSpecificationProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .attributeName("attributeName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-timetolivespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-timetolivespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.TimeToLiveSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeToLiveSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeToLiveSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether TTL is to be enabled (true) or disabled (false) on the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-timetolivespecification.html#cfn-dynamodb-table-timetolivespecification-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-timetolivespecification.html#cfn-dynamodb-table-timetolivespecification-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The name of the TTL attribute used to store the expiration time for items in the table.
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>The <code>AttributeName</code> property is required when enabling the TTL, or when TTL is already enabled.</li>
         * <li>To update this property, you must first disable TTL and then enable TTL with the new attribute name.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-timetolivespecification.html#cfn-dynamodb-table-timetolivespecification-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-timetolivespecification.html#cfn-dynamodb-table-timetolivespecification-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttributeName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeToLiveSpecificationProperty> {
            java.lang.Object enabled;
            java.lang.String attributeName;

            /**
             * Sets the value of {@link TimeToLiveSpecificationProperty#getEnabled}
             * @param enabled Indicates whether TTL is to be enabled (true) or disabled (false) on the table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TimeToLiveSpecificationProperty#getEnabled}
             * @param enabled Indicates whether TTL is to be enabled (true) or disabled (false) on the table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TimeToLiveSpecificationProperty#getAttributeName}
             * @param attributeName The name of the TTL attribute used to store the expiration time for items in the table.
             *                      <blockquote>
             *                      <p>
             *                      <ul>
             *                      <li>The <code>AttributeName</code> property is required when enabling the TTL, or when TTL is already enabled.</li>
             *                      <li>To update this property, you must first disable TTL and then enable TTL with the new attribute name.</li>
             *                      </ul>
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeToLiveSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeToLiveSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeToLiveSpecificationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String attributeName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.attributeName = builder.attributeName;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAttributeName() != null) {
                    data.set("attributeName", om.valueToTree(this.getAttributeName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.TimeToLiveSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeToLiveSpecificationProperty.Jsii$Proxy that = (TimeToLiveSpecificationProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.attributeName != null ? this.attributeName.equals(that.attributeName) : that.attributeName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.attributeName != null ? this.attributeName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides visibility into the number of read and write operations your table or secondary index can instantaneously support.
     * <p>
     * The settings can be modified using the <code>UpdateTable</code> operation to meet the throughput requirements of an upcoming peak event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * WarmThroughputProperty warmThroughputProperty = WarmThroughputProperty.builder()
     *         .readUnitsPerSecond(123)
     *         .writeUnitsPerSecond(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-warmthroughput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-warmthroughput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnTable.WarmThroughputProperty")
    @software.amazon.jsii.Jsii.Proxy(WarmThroughputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WarmThroughputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents the number of read operations your base table can instantaneously support.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-warmthroughput.html#cfn-dynamodb-table-warmthroughput-readunitspersecond">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-warmthroughput.html#cfn-dynamodb-table-warmthroughput-readunitspersecond</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReadUnitsPerSecond() {
            return null;
        }

        /**
         * Represents the number of write operations your base table can instantaneously support.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-warmthroughput.html#cfn-dynamodb-table-warmthroughput-writeunitspersecond">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-warmthroughput.html#cfn-dynamodb-table-warmthroughput-writeunitspersecond</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWriteUnitsPerSecond() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WarmThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WarmThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WarmThroughputProperty> {
            java.lang.Number readUnitsPerSecond;
            java.lang.Number writeUnitsPerSecond;

            /**
             * Sets the value of {@link WarmThroughputProperty#getReadUnitsPerSecond}
             * @param readUnitsPerSecond Represents the number of read operations your base table can instantaneously support.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readUnitsPerSecond(java.lang.Number readUnitsPerSecond) {
                this.readUnitsPerSecond = readUnitsPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link WarmThroughputProperty#getWriteUnitsPerSecond}
             * @param writeUnitsPerSecond Represents the number of write operations your base table can instantaneously support.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeUnitsPerSecond(java.lang.Number writeUnitsPerSecond) {
                this.writeUnitsPerSecond = writeUnitsPerSecond;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WarmThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WarmThroughputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WarmThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WarmThroughputProperty {
            private final java.lang.Number readUnitsPerSecond;
            private final java.lang.Number writeUnitsPerSecond;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.readUnitsPerSecond = software.amazon.jsii.Kernel.get(this, "readUnitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.writeUnitsPerSecond = software.amazon.jsii.Kernel.get(this, "writeUnitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readUnitsPerSecond = builder.readUnitsPerSecond;
                this.writeUnitsPerSecond = builder.writeUnitsPerSecond;
            }

            @Override
            public final java.lang.Number getReadUnitsPerSecond() {
                return this.readUnitsPerSecond;
            }

            @Override
            public final java.lang.Number getWriteUnitsPerSecond() {
                return this.writeUnitsPerSecond;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReadUnitsPerSecond() != null) {
                    data.set("readUnitsPerSecond", om.valueToTree(this.getReadUnitsPerSecond()));
                }
                if (this.getWriteUnitsPerSecond() != null) {
                    data.set("writeUnitsPerSecond", om.valueToTree(this.getWriteUnitsPerSecond()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnTable.WarmThroughputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WarmThroughputProperty.Jsii$Proxy that = (WarmThroughputProperty.Jsii$Proxy) o;

                if (this.readUnitsPerSecond != null ? !this.readUnitsPerSecond.equals(that.readUnitsPerSecond) : that.readUnitsPerSecond != null) return false;
                return this.writeUnitsPerSecond != null ? this.writeUnitsPerSecond.equals(that.writeUnitsPerSecond) : that.writeUnitsPerSecond == null;
            }

            @Override
            public final int hashCode() {
                int result = this.readUnitsPerSecond != null ? this.readUnitsPerSecond.hashCode() : 0;
                result = 31 * result + (this.writeUnitsPerSecond != null ? this.writeUnitsPerSecond.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dynamodb.CfnTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dynamodb.CfnTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dynamodb.CfnTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dynamodb.CfnTableProps.Builder();
        }

        /**
         * Specifies the attributes that make up the primary key for the table.
         * <p>
         * The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema</a>
         * @param keySchema Specifies the attributes that make up the primary key for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySchema(final software.amazon.awscdk.IResolvable keySchema) {
            this.props.keySchema(keySchema);
            return this;
        }
        /**
         * Specifies the attributes that make up the primary key for the table.
         * <p>
         * The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema</a>
         * @param keySchema Specifies the attributes that make up the primary key for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySchema(final java.util.List<? extends java.lang.Object> keySchema) {
            this.props.keySchema(keySchema);
            return this;
        }

        /**
         * A list of attributes that describe the key schema for the table and indexes.
         * <p>
         * This property is required to create a DynamoDB table.
         * <p>
         * Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">Some interruptions</a> . Replacement if you edit an existing AttributeDefinition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedefinitions</a>
         * @param attributeDefinitions A list of attributes that describe the key schema for the table and indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeDefinitions(final software.amazon.awscdk.IResolvable attributeDefinitions) {
            this.props.attributeDefinitions(attributeDefinitions);
            return this;
        }
        /**
         * A list of attributes that describe the key schema for the table and indexes.
         * <p>
         * This property is required to create a DynamoDB table.
         * <p>
         * Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">Some interruptions</a> . Replacement if you edit an existing AttributeDefinition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedefinitions</a>
         * @param attributeDefinitions A list of attributes that describe the key schema for the table and indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeDefinitions(final java.util.List<? extends java.lang.Object> attributeDefinitions) {
            this.props.attributeDefinitions(attributeDefinitions);
            return this;
        }

        /**
         * Specify how you are charged for read and write throughput and how you manage capacity.
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for most DynamoDB workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html">On-demand capacity mode</a> .</li>
         * <li><code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for steady workloads with predictable growth where capacity requirements can be reliably forecasted. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html">Provisioned capacity mode</a> .</li>
         * </ul>
         * <p>
         * If not specified, the default is <code>PROVISIONED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode</a>
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final java.lang.String billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        /**
         * The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-contributorinsightsspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-contributorinsightsspecification</a>
         * @param contributorInsightsSpecification The settings used to enable or disable CloudWatch Contributor Insights for the specified table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsSpecification(final software.amazon.awscdk.IResolvable contributorInsightsSpecification) {
            this.props.contributorInsightsSpecification(contributorInsightsSpecification);
            return this;
        }
        /**
         * The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-contributorinsightsspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-contributorinsightsspecification</a>
         * @param contributorInsightsSpecification The settings used to enable or disable CloudWatch Contributor Insights for the specified table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.ContributorInsightsSpecificationProperty contributorInsightsSpecification) {
            this.props.contributorInsightsSpecification(contributorInsightsSpecification);
            return this;
        }

        /**
         * Determines if a table is protected from deletion.
         * <p>
         * When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection">Using deletion protection</a> in the <em>Amazon DynamoDB Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-deletionprotectionenabled</a>
         * @param deletionProtectionEnabled Determines if a table is protected from deletion. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(final java.lang.Boolean deletionProtectionEnabled) {
            this.props.deletionProtectionEnabled(deletionProtectionEnabled);
            return this;
        }
        /**
         * Determines if a table is protected from deletion.
         * <p>
         * When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection">Using deletion protection</a> in the <em>Amazon DynamoDB Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-deletionprotectionenabled</a>
         * @param deletionProtectionEnabled Determines if a table is protected from deletion. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(final software.amazon.awscdk.IResolvable deletionProtectionEnabled) {
            this.props.deletionProtectionEnabled(deletionProtectionEnabled);
            return this;
        }

        /**
         * Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
         * <p>
         * <blockquote>
         * <p>
         * If you update a table to include a new global secondary index, AWS CloudFormation initiates the index creation and then proceeds with the stack update. AWS CloudFormation doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is <code>ACTIVE</code> . You can track its status by using the DynamoDB <a href="https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html">DescribeTable</a> command.
         * <p>
         * If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index.
         * <p>
         * Updates are not supported. The following are exceptions:
         * <p>
         * <ul>
         * <li>If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.</li>
         * <li>You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-globalsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-globalsecondaryindexes</a>
         * @param globalSecondaryIndexes Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(final software.amazon.awscdk.IResolvable globalSecondaryIndexes) {
            this.props.globalSecondaryIndexes(globalSecondaryIndexes);
            return this;
        }
        /**
         * Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
         * <p>
         * <blockquote>
         * <p>
         * If you update a table to include a new global secondary index, AWS CloudFormation initiates the index creation and then proceeds with the stack update. AWS CloudFormation doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is <code>ACTIVE</code> . You can track its status by using the DynamoDB <a href="https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html">DescribeTable</a> command.
         * <p>
         * If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index.
         * <p>
         * Updates are not supported. The following are exceptions:
         * <p>
         * <ul>
         * <li>If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.</li>
         * <li>You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-globalsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-globalsecondaryindexes</a>
         * @param globalSecondaryIndexes Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(final java.util.List<? extends java.lang.Object> globalSecondaryIndexes) {
            this.props.globalSecondaryIndexes(globalSecondaryIndexes);
            return this;
        }

        /**
         * Specifies the properties of data being imported from the S3 bucket source to the" table.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>ImportSourceSpecification</code> property, and also specify either the <code>StreamSpecification</code> , the <code>TableClass</code> property, the <code>DeletionProtectionEnabled</code> property, or the <code>WarmThroughput</code> property, the IAM entity creating/updating stack must have <code>UpdateTable</code> permission.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-importsourcespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-importsourcespecification</a>
         * @param importSourceSpecification Specifies the properties of data being imported from the S3 bucket source to the" table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importSourceSpecification(final software.amazon.awscdk.IResolvable importSourceSpecification) {
            this.props.importSourceSpecification(importSourceSpecification);
            return this;
        }
        /**
         * Specifies the properties of data being imported from the S3 bucket source to the" table.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>ImportSourceSpecification</code> property, and also specify either the <code>StreamSpecification</code> , the <code>TableClass</code> property, the <code>DeletionProtectionEnabled</code> property, or the <code>WarmThroughput</code> property, the IAM entity creating/updating stack must have <code>UpdateTable</code> permission.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-importsourcespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-importsourcespecification</a>
         * @param importSourceSpecification Specifies the properties of data being imported from the S3 bucket source to the" table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importSourceSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.ImportSourceSpecificationProperty importSourceSpecification) {
            this.props.importSourceSpecification(importSourceSpecification);
            return this;
        }

        /**
         * The Kinesis Data Streams configuration for the specified table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-kinesisstreamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-kinesisstreamspecification</a>
         * @param kinesisStreamSpecification The Kinesis Data Streams configuration for the specified table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSpecification(final software.amazon.awscdk.IResolvable kinesisStreamSpecification) {
            this.props.kinesisStreamSpecification(kinesisStreamSpecification);
            return this;
        }
        /**
         * The Kinesis Data Streams configuration for the specified table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-kinesisstreamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-kinesisstreamspecification</a>
         * @param kinesisStreamSpecification The Kinesis Data Streams configuration for the specified table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.KinesisStreamSpecificationProperty kinesisStreamSpecification) {
            this.props.kinesisStreamSpecification(kinesisStreamSpecification);
            return this;
        }

        /**
         * Local secondary indexes to be created on the table.
         * <p>
         * You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-localsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-localsecondaryindexes</a>
         * @param localSecondaryIndexes Local secondary indexes to be created on the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(final software.amazon.awscdk.IResolvable localSecondaryIndexes) {
            this.props.localSecondaryIndexes(localSecondaryIndexes);
            return this;
        }
        /**
         * Local secondary indexes to be created on the table.
         * <p>
         * You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-localsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-localsecondaryindexes</a>
         * @param localSecondaryIndexes Local secondary indexes to be created on the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(final java.util.List<? extends java.lang.Object> localSecondaryIndexes) {
            this.props.localSecondaryIndexes(localSecondaryIndexes);
            return this;
        }

        /**
         * Sets the maximum number of read and write units for the specified on-demand table.
         * <p>
         * If you use this property, you must specify <code>MaxReadRequestUnits</code> , <code>MaxWriteRequestUnits</code> , or both.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ondemandthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ondemandthroughput</a>
         * @param onDemandThroughput Sets the maximum number of read and write units for the specified on-demand table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandThroughput(final software.amazon.awscdk.IResolvable onDemandThroughput) {
            this.props.onDemandThroughput(onDemandThroughput);
            return this;
        }
        /**
         * Sets the maximum number of read and write units for the specified on-demand table.
         * <p>
         * If you use this property, you must specify <code>MaxReadRequestUnits</code> , <code>MaxWriteRequestUnits</code> , or both.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ondemandthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ondemandthroughput</a>
         * @param onDemandThroughput Sets the maximum number of read and write units for the specified on-demand table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandThroughput(final software.amazon.awscdk.services.dynamodb.CfnTable.OnDemandThroughputProperty onDemandThroughput) {
            this.props.onDemandThroughput(onDemandThroughput);
            return this;
        }

        /**
         * The settings used to enable point in time recovery.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification</a>
         * @param pointInTimeRecoverySpecification The settings used to enable point in time recovery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(final software.amazon.awscdk.IResolvable pointInTimeRecoverySpecification) {
            this.props.pointInTimeRecoverySpecification(pointInTimeRecoverySpecification);
            return this;
        }
        /**
         * The settings used to enable point in time recovery.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification</a>
         * @param pointInTimeRecoverySpecification The settings used to enable point in time recovery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty pointInTimeRecoverySpecification) {
            this.props.pointInTimeRecoverySpecification(pointInTimeRecoverySpecification);
            return this;
        }

        /**
         * Throughput for the specified table, which consists of values for <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> .
         * <p>
         * For more information about the contents of a provisioned throughput structure, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html">Amazon DynamoDB Table ProvisionedThroughput</a> .
         * <p>
         * If you set <code>BillingMode</code> as <code>PROVISIONED</code> , you must specify this property. If you set <code>BillingMode</code> as <code>PAY_PER_REQUEST</code> , you cannot specify this property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput</a>
         * @param provisionedThroughput Throughput for the specified table, which consists of values for <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughput(final software.amazon.awscdk.IResolvable provisionedThroughput) {
            this.props.provisionedThroughput(provisionedThroughput);
            return this;
        }
        /**
         * Throughput for the specified table, which consists of values for <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> .
         * <p>
         * For more information about the contents of a provisioned throughput structure, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html">Amazon DynamoDB Table ProvisionedThroughput</a> .
         * <p>
         * If you set <code>BillingMode</code> as <code>PROVISIONED</code> , you must specify this property. If you set <code>BillingMode</code> as <code>PAY_PER_REQUEST</code> , you cannot specify this property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput</a>
         * @param provisionedThroughput Throughput for the specified table, which consists of values for <code>ReadCapacityUnits</code> and <code>WriteCapacityUnits</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughput(final software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty provisionedThroughput) {
            this.props.provisionedThroughput(provisionedThroughput);
            return this;
        }

        /**
         * A resource-based policy document that contains permissions to add to the specified table.
         * <p>
         * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
         * <p>
         * When you attach a resource-based policy while creating a table, the policy creation is <em>strongly consistent</em> . For information about the considerations that you should keep in mind while attaching a resource-based policy, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html">Resource-based policy considerations</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-resourcepolicy</a>
         * @param resourcePolicy A resource-based policy document that contains permissions to add to the specified table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(final software.amazon.awscdk.IResolvable resourcePolicy) {
            this.props.resourcePolicy(resourcePolicy);
            return this;
        }
        /**
         * A resource-based policy document that contains permissions to add to the specified table.
         * <p>
         * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
         * <p>
         * When you attach a resource-based policy while creating a table, the policy creation is <em>strongly consistent</em> . For information about the considerations that you should keep in mind while attaching a resource-based policy, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html">Resource-based policy considerations</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-resourcepolicy</a>
         * @param resourcePolicy A resource-based policy document that contains permissions to add to the specified table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(final software.amazon.awscdk.services.dynamodb.CfnTable.ResourcePolicyProperty resourcePolicy) {
            this.props.resourcePolicy(resourcePolicy);
            return this;
        }

        /**
         * Specifies the settings to enable server-side encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification</a>
         * @param sseSpecification Specifies the settings to enable server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(final software.amazon.awscdk.IResolvable sseSpecification) {
            this.props.sseSpecification(sseSpecification);
            return this;
        }
        /**
         * Specifies the settings to enable server-side encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification</a>
         * @param sseSpecification Specifies the settings to enable server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty sseSpecification) {
            this.props.sseSpecification(sseSpecification);
            return this;
        }

        /**
         * The settings for the DynamoDB table stream, which capture changes to items stored in the table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification</a>
         * @param streamSpecification The settings for the DynamoDB table stream, which capture changes to items stored in the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamSpecification(final software.amazon.awscdk.IResolvable streamSpecification) {
            this.props.streamSpecification(streamSpecification);
            return this;
        }
        /**
         * The settings for the DynamoDB table stream, which capture changes to items stored in the table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification</a>
         * @param streamSpecification The settings for the DynamoDB table stream, which capture changes to items stored in the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.StreamSpecificationProperty streamSpecification) {
            this.props.streamSpecification(streamSpecification);
            return this;
        }

        /**
         * The table class of the new table.
         * <p>
         * Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tableclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tableclass</a>
         * @param tableClass The table class of the new table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(final java.lang.String tableClass) {
            this.props.tableClass(tableClass);
            return this;
        }

        /**
         * A name for the table.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename</a>
         * @param tableName A name for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies the Time to Live (TTL) settings for the table.
         * <p>
         * <blockquote>
         * <p>
         * For detailed information about the limits in DynamoDB, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits in Amazon DynamoDB</a> in the Amazon DynamoDB Developer Guide.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification</a>
         * @param timeToLiveSpecification Specifies the Time to Live (TTL) settings for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveSpecification(final software.amazon.awscdk.IResolvable timeToLiveSpecification) {
            this.props.timeToLiveSpecification(timeToLiveSpecification);
            return this;
        }
        /**
         * Specifies the Time to Live (TTL) settings for the table.
         * <p>
         * <blockquote>
         * <p>
         * For detailed information about the limits in DynamoDB, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits in Amazon DynamoDB</a> in the Amazon DynamoDB Developer Guide.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification</a>
         * @param timeToLiveSpecification Specifies the Time to Live (TTL) settings for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.TimeToLiveSpecificationProperty timeToLiveSpecification) {
            this.props.timeToLiveSpecification(timeToLiveSpecification);
            return this;
        }

        /**
         * Represents the warm throughput (in read units per second and write units per second) for creating a table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-warmthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-warmthroughput</a>
         * @param warmThroughput Represents the warm throughput (in read units per second and write units per second) for creating a table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder warmThroughput(final software.amazon.awscdk.IResolvable warmThroughput) {
            this.props.warmThroughput(warmThroughput);
            return this;
        }
        /**
         * Represents the warm throughput (in read units per second and write units per second) for creating a table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-warmthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-warmthroughput</a>
         * @param warmThroughput Represents the warm throughput (in read units per second and write units per second) for creating a table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder warmThroughput(final software.amazon.awscdk.services.dynamodb.CfnTable.WarmThroughputProperty warmThroughput) {
            this.props.warmThroughput(warmThroughput);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dynamodb.CfnTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dynamodb.CfnTable build() {
            return new software.amazon.awscdk.services.dynamodb.CfnTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
