package software.amazon.awscdk.services.devicefarm;

/**
 * Properties for defining a <code>CfnVPCEConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.devicefarm.*;
 * CfnVPCEConfigurationProps cfnVPCEConfigurationProps = CfnVPCEConfigurationProps.builder()
 *         .serviceDnsName("serviceDnsName")
 *         .vpceConfigurationName("vpceConfigurationName")
 *         .vpceServiceName("vpceServiceName")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpceConfigurationDescription("vpceConfigurationDescription")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:10.264Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devicefarm.CfnVPCEConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCEConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCEConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DNS name that Device Farm will use to map to the private service you want to access.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-servicednsname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-servicednsname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceDnsName();

    /**
     * The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-vpceconfigurationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-vpceconfigurationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpceConfigurationName();

    /**
     * The name of the VPC endpoint service that you want to access from Device Farm.
     * <p>
     * The name follows the format <code>com.amazonaws.vpce.us-west-2.vpce-svc-id</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-vpceservicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-vpceservicename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpceServiceName();

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * An optional description that provides details about your VPC endpoint configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-vpceconfigurationdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-vpceconfiguration.html#cfn-devicefarm-vpceconfiguration-vpceconfigurationdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpceConfigurationDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCEConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCEConfigurationProps> {
        java.lang.String serviceDnsName;
        java.lang.String vpceConfigurationName;
        java.lang.String vpceServiceName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String vpceConfigurationDescription;

        /**
         * Sets the value of {@link CfnVPCEConfigurationProps#getServiceDnsName}
         * @param serviceDnsName The DNS name that Device Farm will use to map to the private service you want to access. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceDnsName(java.lang.String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEConfigurationProps#getVpceConfigurationName}
         * @param vpceConfigurationName The friendly name you give to your VPC endpoint configuration to manage your configurations more easily. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpceConfigurationName(java.lang.String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEConfigurationProps#getVpceServiceName}
         * @param vpceServiceName The name of the VPC endpoint service that you want to access from Device Farm. This parameter is required.
         *                        The name follows the format <code>com.amazonaws.vpce.us-west-2.vpce-svc-id</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpceServiceName(java.lang.String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEConfigurationProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEConfigurationProps#getVpceConfigurationDescription}
         * @param vpceConfigurationDescription An optional description that provides details about your VPC endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpceConfigurationDescription(java.lang.String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCEConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPCEConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEConfigurationProps {
        private final java.lang.String serviceDnsName;
        private final java.lang.String vpceConfigurationName;
        private final java.lang.String vpceServiceName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String vpceConfigurationDescription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceDnsName = software.amazon.jsii.Kernel.get(this, "serviceDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpceConfigurationName = software.amazon.jsii.Kernel.get(this, "vpceConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpceServiceName = software.amazon.jsii.Kernel.get(this, "vpceServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpceConfigurationDescription = software.amazon.jsii.Kernel.get(this, "vpceConfigurationDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceDnsName = java.util.Objects.requireNonNull(builder.serviceDnsName, "serviceDnsName is required");
            this.vpceConfigurationName = java.util.Objects.requireNonNull(builder.vpceConfigurationName, "vpceConfigurationName is required");
            this.vpceServiceName = java.util.Objects.requireNonNull(builder.vpceServiceName, "vpceServiceName is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpceConfigurationDescription = builder.vpceConfigurationDescription;
        }

        @Override
        public final java.lang.String getServiceDnsName() {
            return this.serviceDnsName;
        }

        @Override
        public final java.lang.String getVpceConfigurationName() {
            return this.vpceConfigurationName;
        }

        @Override
        public final java.lang.String getVpceServiceName() {
            return this.vpceServiceName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVpceConfigurationDescription() {
            return this.vpceConfigurationDescription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceDnsName", om.valueToTree(this.getServiceDnsName()));
            data.set("vpceConfigurationName", om.valueToTree(this.getVpceConfigurationName()));
            data.set("vpceServiceName", om.valueToTree(this.getVpceServiceName()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpceConfigurationDescription() != null) {
                data.set("vpceConfigurationDescription", om.valueToTree(this.getVpceConfigurationDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devicefarm.CfnVPCEConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEConfigurationProps.Jsii$Proxy that = (CfnVPCEConfigurationProps.Jsii$Proxy) o;

            if (!serviceDnsName.equals(that.serviceDnsName)) return false;
            if (!vpceConfigurationName.equals(that.vpceConfigurationName)) return false;
            if (!vpceServiceName.equals(that.vpceServiceName)) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpceConfigurationDescription != null ? this.vpceConfigurationDescription.equals(that.vpceConfigurationDescription) : that.vpceConfigurationDescription == null;
        }

        @Override
        public final int hashCode() {
            int result = this.serviceDnsName.hashCode();
            result = 31 * result + (this.vpceConfigurationName.hashCode());
            result = 31 * result + (this.vpceServiceName.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpceConfigurationDescription != null ? this.vpceConfigurationDescription.hashCode() : 0);
            return result;
        }
    }
}
