/**
 * <h1>AWS::CodeGuruProfiler Construct Library</h1>
 * <p>
 * Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides recommendations that can help you fine-tune your application performance.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Import to your project:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codeguruprofiler.*;
 * </pre></blockquote>
 * <p>
 * <h2>Basic usage</h2>
 * <p>
 * Here's how to setup a profiling group and give your compute role permissions to publish to the profiling group to the profiling agent can publish profiling information:
 * <p>
 * <blockquote><pre>
 * // The execution role of your application that publishes to the ProfilingGroup via CodeGuru Profiler Profiling Agent. (the following is merely an example)
 * Role publishAppRole = Role.Builder.create(this, "PublishAppRole")
 *         .assumedBy(new AccountRootPrincipal())
 *         .build();
 * 
 * ProfilingGroup profilingGroup = new ProfilingGroup(this, "MyProfilingGroup");
 * profilingGroup.grantPublish(publishAppRole);
 * </pre></blockquote>
 * <p>
 * <h2>Compute Platform configuration</h2>
 * <p>
 * Code Guru Profiler supports multiple compute environments.
 * They can be configured when creating a Profiling Group by using the <code>computePlatform</code> property:
 * <p>
 * <blockquote><pre>
 * ProfilingGroup profilingGroup = ProfilingGroup.Builder.create(this, "MyProfilingGroup")
 *         .computePlatform(ComputePlatform.AWS_LAMBDA)
 *         .build();
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.codeguruprofiler;
