package software.amazon.awscdk.services.cloudwatch;

/**
 * Unit for metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LogGroup logGroup;
 * MetricFilter mf = MetricFilter.Builder.create(this, "MetricFilter")
 *         .logGroup(logGroup)
 *         .metricNamespace("MyApp")
 *         .metricName("Latency")
 *         .filterPattern(FilterPattern.exists("$.latency"))
 *         .metricValue("$.latency")
 *         .dimensions(Map.of(
 *                 "ErrorCode", "$.errorCode"))
 *         .unit(Unit.MILLISECONDS)
 *         .build();
 * //expose a metric from the metric filter
 * Metric metric = mf.metric();
 * //you can use the metric to create a new alarm
 * //you can use the metric to create a new alarm
 * Alarm.Builder.create(this, "alarm from metric filter")
 *         .metric(metric)
 *         .threshold(100)
 *         .evaluationPeriods(2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:08.906Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Unit")
public enum Unit {
    /**
     * Seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SECONDS,
    /**
     * Microseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MICROSECONDS,
    /**
     * Milliseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MILLISECONDS,
    /**
     * Bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BYTES,
    /**
     * Kilobytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KILOBYTES,
    /**
     * Megabytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEGABYTES,
    /**
     * Gigabytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GIGABYTES,
    /**
     * Terabytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERABYTES,
    /**
     * Bits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BITS,
    /**
     * Kilobits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KILOBITS,
    /**
     * Megabits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEGABITS,
    /**
     * Gigabits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GIGABITS,
    /**
     * Terabits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERABITS,
    /**
     * Percent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERCENT,
    /**
     * Count.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COUNT,
    /**
     * Bytes/second (B/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BYTES_PER_SECOND,
    /**
     * Kilobytes/second (kB/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KILOBYTES_PER_SECOND,
    /**
     * Megabytes/second (MB/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEGABYTES_PER_SECOND,
    /**
     * Gigabytes/second (GB/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GIGABYTES_PER_SECOND,
    /**
     * Terabytes/second (TB/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERABYTES_PER_SECOND,
    /**
     * Bits/second (b/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BITS_PER_SECOND,
    /**
     * Kilobits/second (kb/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KILOBITS_PER_SECOND,
    /**
     * Megabits/second (Mb/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEGABITS_PER_SECOND,
    /**
     * Gigabits/second (Gb/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GIGABITS_PER_SECOND,
    /**
     * Terabits/second (Tb/s).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERABITS_PER_SECOND,
    /**
     * Count/second.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COUNT_PER_SECOND,
    /**
     * None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
