package software.amazon.awscdk.services.batch;

/**
 * Determines how this compute environment chooses instances to spawn.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * ManagedEc2EcsComputeEnvironment computeEnv = ManagedEc2EcsComputeEnvironment.Builder.create(this, "myEc2ComputeEnv")
 *         .vpc(vpc)
 *         .allocationStrategy(AllocationStrategy.BEST_FIT)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://aws.amazon.com/blogs/compute/optimizing-for-cost-availability-and-throughput-by-selecting-your-aws-batch-allocation-strategy/">https://aws.amazon.com/blogs/compute/optimizing-for-cost-availability-and-throughput-by-selecting-your-aws-batch-allocation-strategy/</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:07.790Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.AllocationStrategy")
public enum AllocationStrategy {
    /**
     * Batch chooses the lowest-cost instance type that fits all the jobs in the queue.
     * <p>
     * If instances of that type are not available, the queue will not choose a new type;
     * instead, it will wait for the instance to become available.
     * This can stall your <code>Queue</code>, with your compute environment only using part of its max capacity
     * (or none at all) until the <code>BEST_FIT</code> instance becomes available.
     * This allocation strategy keeps costs lower but can limit scaling.
     * <code>BEST_FIT</code> isn't supported when updating compute environments
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BEST_FIT,
    /**
     * This is the default Allocation Strategy if <code>spot</code> is <code>false</code> or unspecified.
     * <p>
     * This strategy will examine the Jobs in the queue and choose whichever instance type meets the requirements
     * of the jobs in the queue and with the lowest cost per vCPU, just as <code>BEST_FIT</code>.
     * However, if not all of the capacity can be filled with this instance type,
     * it will choose a new next-best instance type to run any jobs that couldn’t fit into the <code>BEST_FIT</code> capacity.
     * To make the most use of this allocation strategy,
     * it is recommended to use as many instance classes as is feasible for your workload.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BEST_FIT_PROGRESSIVE,
    /**
     * If your workflow tolerates interruptions, you should enable <code>spot</code> on your <code>ComputeEnvironment</code> and use <code>SPOT_CAPACITY_OPTIMIZED</code> (this is the default if <code>spot</code> is enabled).
     * <p>
     * This will tell Batch to choose the instance types from the ones you’ve specified that have
     * the most spot capacity available to minimize the chance of interruption.
     * To get the most benefit from your spot instances,
     * you should allow Batch to choose from as many different instance types as possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SPOT_CAPACITY_OPTIMIZED,
    /**
     * The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
     * <p>
     * The Batch team recommends this over <code>SPOT_CAPACITY_OPTIMIZED</code> in most instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SPOT_PRICE_CAPACITY_OPTIMIZED,
}
