package software.amazon.awscdk.services.appconfig;

/**
 * Defines a JSON Schema validator.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application;
 * Function fn;
 * HostedConfiguration.Builder.create(this, "MyHostedConfiguration")
 *         .application(application)
 *         .content(ConfigurationContent.fromInlineText("This is my configuration content."))
 *         .validators(List.of(JsonSchemaValidator.fromFile("schema.json"), LambdaValidator.fromFunction(fn)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:06.729Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.JsonSchemaValidator")
public abstract class JsonSchemaValidator extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appconfig.IValidator {

    protected JsonSchemaValidator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JsonSchemaValidator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected JsonSchemaValidator() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Defines a JSON Schema validator from a file.
     * <p>
     * @param inputPath The path to the file that defines the validator. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.JsonSchemaValidator fromFile(final @org.jetbrains.annotations.NotNull java.lang.String inputPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.JsonSchemaValidator.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.JsonSchemaValidator.class), new Object[] { java.util.Objects.requireNonNull(inputPath, "inputPath is required") });
    }

    /**
     * Defines a JSON Schema validator from inline code.
     * <p>
     * @param code The inline code that defines the validator. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.JsonSchemaValidator fromInline(final @org.jetbrains.annotations.NotNull java.lang.String code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.JsonSchemaValidator.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.JsonSchemaValidator.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * The content of the validator.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getContent();

    /**
     * The type of validator.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ValidatorType getType();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appconfig.JsonSchemaValidator implements software.amazon.awscdk.services.appconfig.IValidator.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The content of the validator.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getContent() {
            return software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of validator.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ValidatorType getType() {
            return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ValidatorType.class));
        }
    }
}
