package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a <code>CfnRestApi</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * Object body;
 * Object policy;
 * CfnRestApiProps cfnRestApiProps = CfnRestApiProps.builder()
 *         .apiKeySourceType("apiKeySourceType")
 *         .binaryMediaTypes(List.of("binaryMediaTypes"))
 *         .body(body)
 *         .bodyS3Location(S3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .eTag("eTag")
 *                 .key("key")
 *                 .version("version")
 *                 .build())
 *         .cloneFrom("cloneFrom")
 *         .description("description")
 *         .disableExecuteApiEndpoint(false)
 *         .endpointConfiguration(EndpointConfigurationProperty.builder()
 *                 .ipAddressType("ipAddressType")
 *                 .types(List.of("types"))
 *                 .vpcEndpointIds(List.of("vpcEndpointIds"))
 *                 .build())
 *         .failOnWarnings(false)
 *         .minimumCompressionSize(123)
 *         .mode("mode")
 *         .name("name")
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .policy(policy)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:06.329Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnRestApiProps")
@software.amazon.jsii.Jsii.Proxy(CfnRestApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRestApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The source of the API key for metering requests according to a usage plan.
     * <p>
     * Valid values are: <code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. <code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiKeySourceType() {
        return null;
    }

    /**
     * The list of binary media types supported by the RestApi.
     * <p>
     * By default, the RestApi supports only UTF-8-encoded text payloads.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBinaryMediaTypes() {
        return null;
    }

    /**
     * An OpenAPI specification that defines a set of RESTful APIs in JSON format.
     * <p>
     * For YAML templates, you can also provide the specification in YAML format.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBody() {
        return null;
    }

    /**
     * The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBodyS3Location() {
        return null;
    }

    /**
     * The ID of the RestApi that you want to clone from.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloneFrom() {
        return null;
    }

    /**
     * The description of the RestApi.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
     * <p>
     * By default, clients can invoke your API with the default <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-disableexecuteapiendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-disableexecuteapiendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableExecuteApiEndpoint() {
        return null;
    }

    /**
     * A list of the endpoint types and IP address types of the API.
     * <p>
     * Use this property when creating an API. When importing an existing API, specify the endpoint configuration types using the <code>Parameters</code> property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointConfiguration() {
        return null;
    }

    /**
     * A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered.
     * <p>
     * The default value is <code>false</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFailOnWarnings() {
        return null;
    }

    /**
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API.
     * <p>
     * When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumCompressionSize() {
        return null;
    }

    /**
     * This property applies only when you use OpenAPI to define your REST API.
     * <p>
     * The <code>Mode</code> determines how API Gateway handles resource updates.
     * <p>
     * Valid values are <code>overwrite</code> or <code>merge</code> .
     * <p>
     * For <code>overwrite</code> , the new API definition replaces the existing one. The existing API identifier remains unchanged.
     * <p>
     * For <code>merge</code> , the new API definition is merged with the existing API.
     * <p>
     * If you don't specify this property, a default value is chosen. For REST APIs created before March 29, 2021, the default is <code>overwrite</code> . For REST APIs created after March 29, 2021, the new API definition takes precedence, but any container types such as endpoint configurations and binary media types are merged with the existing API.
     * <p>
     * Use the default mode to define top-level <code>RestApi</code> properties in addition to using OpenAPI. Generally, it's preferred to use API Gateway's OpenAPI extensions to model these properties.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-mode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
        return null;
    }

    /**
     * The name of the RestApi.
     * <p>
     * A name is required if the REST API is not based on an OpenAPI specification.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Custom header parameters as part of the request.
     * <p>
     * For example, to exclude DocumentationParts from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * A policy document that contains the permissions for the <code>RestApi</code> resource.
     * <p>
     * To set the ARN for the policy, use the <code>!Join</code> intrinsic function with <code>""</code> as delimiter and values of <code>"execute-api:/"</code> and <code>"*"</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicy() {
        return null;
    }

    /**
     * The key-value map of strings.
     * <p>
     * The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code> . The tag value can be up to 256 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRestApiProps> {
        java.lang.String apiKeySourceType;
        java.util.List<java.lang.String> binaryMediaTypes;
        java.lang.Object body;
        java.lang.Object bodyS3Location;
        java.lang.String cloneFrom;
        java.lang.String description;
        java.lang.Object disableExecuteApiEndpoint;
        java.lang.Object endpointConfiguration;
        java.lang.Object failOnWarnings;
        java.lang.Number minimumCompressionSize;
        java.lang.String mode;
        java.lang.String name;
        java.lang.Object parameters;
        java.lang.Object policy;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRestApiProps#getApiKeySourceType}
         * @param apiKeySourceType The source of the API key for metering requests according to a usage plan.
         *                         Valid values are: <code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. <code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(java.lang.String apiKeySourceType) {
            this.apiKeySourceType = apiKeySourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getBinaryMediaTypes}
         * @param binaryMediaTypes The list of binary media types supported by the RestApi.
         *                         By default, the RestApi supports only UTF-8-encoded text payloads.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(java.util.List<java.lang.String> binaryMediaTypes) {
            this.binaryMediaTypes = binaryMediaTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getBody}
         * @param body An OpenAPI specification that defines a set of RESTful APIs in JSON format.
         *             For YAML templates, you can also provide the specification in YAML format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(java.lang.Object body) {
            this.body = body;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getBodyS3Location}
         * @param bodyS3Location The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(software.amazon.awscdk.IResolvable bodyS3Location) {
            this.bodyS3Location = bodyS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getBodyS3Location}
         * @param bodyS3Location The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty bodyS3Location) {
            this.bodyS3Location = bodyS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getCloneFrom}
         * @param cloneFrom The ID of the RestApi that you want to clone from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(java.lang.String cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getDescription}
         * @param description The description of the RestApi.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
         *                                  By default, clients can invoke your API with the default <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(java.lang.Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
         *                                  By default, clients can invoke your API with the default <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(software.amazon.awscdk.IResolvable disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getEndpointConfiguration}
         * @param endpointConfiguration A list of the endpoint types and IP address types of the API.
         *                              Use this property when creating an API. When importing an existing API, specify the endpoint configuration types using the <code>Parameters</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.IResolvable endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getEndpointConfiguration}
         * @param endpointConfiguration A list of the endpoint types and IP address types of the API.
         *                              Use this property when creating an API. When importing an existing API, specify the endpoint configuration types using the <code>Parameters</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getFailOnWarnings}
         * @param failOnWarnings A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered.
         *                       The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getFailOnWarnings}
         * @param failOnWarnings A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered.
         *                       The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(software.amazon.awscdk.IResolvable failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getMinimumCompressionSize}
         * @param minimumCompressionSize A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API.
         *                               When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(java.lang.Number minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getMode}
         * @param mode This property applies only when you use OpenAPI to define your REST API.
         *             The <code>Mode</code> determines how API Gateway handles resource updates.
         *             <p>
         *             Valid values are <code>overwrite</code> or <code>merge</code> .
         *             <p>
         *             For <code>overwrite</code> , the new API definition replaces the existing one. The existing API identifier remains unchanged.
         *             <p>
         *             For <code>merge</code> , the new API definition is merged with the existing API.
         *             <p>
         *             If you don't specify this property, a default value is chosen. For REST APIs created before March 29, 2021, the default is <code>overwrite</code> . For REST APIs created after March 29, 2021, the new API definition takes precedence, but any container types such as endpoint configurations and binary media types are merged with the existing API.
         *             <p>
         *             Use the default mode to define top-level <code>RestApi</code> properties in addition to using OpenAPI. Generally, it's preferred to use API Gateway's OpenAPI extensions to model these properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getName}
         * @param name The name of the RestApi.
         *             A name is required if the REST API is not based on an OpenAPI specification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getParameters}
         * @param parameters Custom header parameters as part of the request.
         *                   For example, to exclude DocumentationParts from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getParameters}
         * @param parameters Custom header parameters as part of the request.
         *                   For example, to exclude DocumentationParts from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getPolicy}
         * @param policy A policy document that contains the permissions for the <code>RestApi</code> resource.
         *               To set the ARN for the policy, use the <code>!Join</code> intrinsic function with <code>""</code> as delimiter and values of <code>"execute-api:/"</code> and <code>"*"</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestApiProps#getTags}
         * @param tags The key-value map of strings.
         *             The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code> . The tag value can be up to 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRestApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRestApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRestApiProps {
        private final java.lang.String apiKeySourceType;
        private final java.util.List<java.lang.String> binaryMediaTypes;
        private final java.lang.Object body;
        private final java.lang.Object bodyS3Location;
        private final java.lang.String cloneFrom;
        private final java.lang.String description;
        private final java.lang.Object disableExecuteApiEndpoint;
        private final java.lang.Object endpointConfiguration;
        private final java.lang.Object failOnWarnings;
        private final java.lang.Number minimumCompressionSize;
        private final java.lang.String mode;
        private final java.lang.String name;
        private final java.lang.Object parameters;
        private final java.lang.Object policy;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeySourceType = software.amazon.jsii.Kernel.get(this, "apiKeySourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.binaryMediaTypes = software.amazon.jsii.Kernel.get(this, "binaryMediaTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bodyS3Location = software.amazon.jsii.Kernel.get(this, "bodyS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cloneFrom = software.amazon.jsii.Kernel.get(this, "cloneFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableExecuteApiEndpoint = software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointConfiguration = software.amazon.jsii.Kernel.get(this, "endpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.failOnWarnings = software.amazon.jsii.Kernel.get(this, "failOnWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.minimumCompressionSize = software.amazon.jsii.Kernel.get(this, "minimumCompressionSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeySourceType = builder.apiKeySourceType;
            this.binaryMediaTypes = builder.binaryMediaTypes;
            this.body = builder.body;
            this.bodyS3Location = builder.bodyS3Location;
            this.cloneFrom = builder.cloneFrom;
            this.description = builder.description;
            this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
            this.endpointConfiguration = builder.endpointConfiguration;
            this.failOnWarnings = builder.failOnWarnings;
            this.minimumCompressionSize = builder.minimumCompressionSize;
            this.mode = builder.mode;
            this.name = builder.name;
            this.parameters = builder.parameters;
            this.policy = builder.policy;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getApiKeySourceType() {
            return this.apiKeySourceType;
        }

        @Override
        public final java.util.List<java.lang.String> getBinaryMediaTypes() {
            return this.binaryMediaTypes;
        }

        @Override
        public final java.lang.Object getBody() {
            return this.body;
        }

        @Override
        public final java.lang.Object getBodyS3Location() {
            return this.bodyS3Location;
        }

        @Override
        public final java.lang.String getCloneFrom() {
            return this.cloneFrom;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        @Override
        public final java.lang.Object getEndpointConfiguration() {
            return this.endpointConfiguration;
        }

        @Override
        public final java.lang.Object getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public final java.lang.Number getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        @Override
        public final java.lang.String getMode() {
            return this.mode;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiKeySourceType() != null) {
                data.set("apiKeySourceType", om.valueToTree(this.getApiKeySourceType()));
            }
            if (this.getBinaryMediaTypes() != null) {
                data.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
            }
            if (this.getBody() != null) {
                data.set("body", om.valueToTree(this.getBody()));
            }
            if (this.getBodyS3Location() != null) {
                data.set("bodyS3Location", om.valueToTree(this.getBodyS3Location()));
            }
            if (this.getCloneFrom() != null) {
                data.set("cloneFrom", om.valueToTree(this.getCloneFrom()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisableExecuteApiEndpoint() != null) {
                data.set("disableExecuteApiEndpoint", om.valueToTree(this.getDisableExecuteApiEndpoint()));
            }
            if (this.getEndpointConfiguration() != null) {
                data.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
            }
            if (this.getFailOnWarnings() != null) {
                data.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getMinimumCompressionSize() != null) {
                data.set("minimumCompressionSize", om.valueToTree(this.getMinimumCompressionSize()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnRestApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRestApiProps.Jsii$Proxy that = (CfnRestApiProps.Jsii$Proxy) o;

            if (this.apiKeySourceType != null ? !this.apiKeySourceType.equals(that.apiKeySourceType) : that.apiKeySourceType != null) return false;
            if (this.binaryMediaTypes != null ? !this.binaryMediaTypes.equals(that.binaryMediaTypes) : that.binaryMediaTypes != null) return false;
            if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
            if (this.bodyS3Location != null ? !this.bodyS3Location.equals(that.bodyS3Location) : that.bodyS3Location != null) return false;
            if (this.cloneFrom != null ? !this.cloneFrom.equals(that.cloneFrom) : that.cloneFrom != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disableExecuteApiEndpoint != null ? !this.disableExecuteApiEndpoint.equals(that.disableExecuteApiEndpoint) : that.disableExecuteApiEndpoint != null) return false;
            if (this.endpointConfiguration != null ? !this.endpointConfiguration.equals(that.endpointConfiguration) : that.endpointConfiguration != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.minimumCompressionSize != null ? !this.minimumCompressionSize.equals(that.minimumCompressionSize) : that.minimumCompressionSize != null) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiKeySourceType != null ? this.apiKeySourceType.hashCode() : 0;
            result = 31 * result + (this.binaryMediaTypes != null ? this.binaryMediaTypes.hashCode() : 0);
            result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
            result = 31 * result + (this.bodyS3Location != null ? this.bodyS3Location.hashCode() : 0);
            result = 31 * result + (this.cloneFrom != null ? this.cloneFrom.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disableExecuteApiEndpoint != null ? this.disableExecuteApiEndpoint.hashCode() : 0);
            result = 31 * result + (this.endpointConfiguration != null ? this.endpointConfiguration.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.minimumCompressionSize != null ? this.minimumCompressionSize.hashCode() : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
