package software.amazon.awscdk.pipelines;

/**
 * A CDK Pipeline that uses CodePipeline to deploy CDK apps.
 * <p>
 * This is a <code>Pipeline</code> with its <code>engine</code> property set to
 * <code>CodePipelineEngine</code>, and exists for nicer ergonomics for
 * users that don't need to switch out engines.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline codePipeline;
 * Artifact sourceArtifact = new Artifact("MySourceArtifact");
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .codePipeline(codePipeline)
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineFileSet.fromArtifact(sourceArtifact))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:22.623Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CodePipeline")
public class CodePipeline extends software.amazon.awscdk.pipelines.PipelineBase {

    protected CodePipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodePipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodePipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Implemented by subclasses to do the actual pipeline construction.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void doBuildPipeline() {
        software.amazon.jsii.Kernel.call(this, "doBuildPipeline", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * The CodePipeline pipeline that deploys the CDK app.
     * <p>
     * Only available after the pipeline has been built.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Pipeline getPipeline() {
        return software.amazon.jsii.Kernel.get(this, "pipeline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Pipeline.class));
    }

    /**
     * Whether SelfMutation is enabled for this CDK Pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getSelfMutationEnabled() {
        return software.amazon.jsii.Kernel.get(this, "selfMutationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The CodeBuild project that performs the SelfMutation.
     * <p>
     * Will throw an error if this is accessed before <code>buildPipeline()</code>
     * is called, or if selfMutation has been disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject getSelfMutationProject() {
        return software.amazon.jsii.Kernel.get(this, "selfMutationProject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IProject.class));
    }

    /**
     * The CodeBuild project that performs the Synth.
     * <p>
     * Only available after the pipeline has been built.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject getSynthProject() {
        return software.amazon.jsii.Kernel.get(this, "synthProject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IProject.class));
    }

    /**
     * Allow pipeline service role used for actions if no action role configured instead of creating a new role for each action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getUsePipelineRoleForActions() {
        return software.amazon.jsii.Kernel.get(this, "usePipelineRoleForActions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.pipelines.CodePipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.CodePipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.pipelines.CodePipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.pipelines.CodePipelineProps.Builder();
        }

        /**
         * The build step that produces the CDK Cloud Assembly.
         * <p>
         * The primary output of this step needs to be the <code>cdk.out</code> directory
         * generated by the <code>cdk synth</code> command.
         * <p>
         * If you use a <code>ShellStep</code> here and you don't configure an output directory,
         * the output directory will automatically be assumed to be <code>cdk.out</code>.
         * <p>
         * @return {@code this}
         * @param synth The build step that produces the CDK Cloud Assembly. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synth(final software.amazon.awscdk.pipelines.IFileSetProducer synth) {
            this.props.synth(synth);
            return this;
        }

        /**
         * An existing S3 Bucket to use for storing the pipeline's artifact.
         * <p>
         * Default: - A new S3 bucket will be created.
         * <p>
         * @return {@code this}
         * @param artifactBucket An existing S3 Bucket to use for storing the pipeline's artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBucket(final software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.props.artifactBucket(artifactBucket);
            return this;
        }

        /**
         * Additional customizations to apply to the asset publishing CodeBuild projects.
         * <p>
         * Default: - Only `codeBuildDefaults` are applied
         * <p>
         * @return {@code this}
         * @param assetPublishingCodeBuildDefaults Additional customizations to apply to the asset publishing CodeBuild projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetPublishingCodeBuildDefaults(final software.amazon.awscdk.pipelines.CodeBuildOptions assetPublishingCodeBuildDefaults) {
            this.props.assetPublishingCodeBuildDefaults(assetPublishingCodeBuildDefaults);
            return this;
        }

        /**
         * CDK CLI version to use in self-mutation and asset publishing steps.
         * <p>
         * If you want to lock the CDK CLI version used in the pipeline, by steps
         * that are automatically generated for you, specify the version here.
         * <p>
         * We recommend you do not specify this value, as not specifying it always
         * uses the latest CLI version which is backwards compatible with old versions.
         * <p>
         * If you do specify it, be aware that this version should always be equal to or higher than the
         * version of the CDK framework used by the CDK app, when the CDK commands are
         * run during your pipeline execution. When you change this version, the <em>next
         * time</em> the <code>SelfMutate</code> step runs it will still be using the CLI of the the
         * <em>previous</em> version that was in this property: it will only start using the
         * new version after <code>SelfMutate</code> completes successfully. That means that if
         * you want to update both framework and CLI version, you should update the
         * CLI version first, commit, push and deploy, and only then update the
         * framework version.
         * <p>
         * Default: - Latest version
         * <p>
         * @return {@code this}
         * @param cliVersion CDK CLI version to use in self-mutation and asset publishing steps. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cliVersion(final java.lang.String cliVersion) {
            this.props.cliVersion(cliVersion);
            return this;
        }

        /**
         * Customize the CodeBuild projects created for this pipeline.
         * <p>
         * Default: - All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_7_0
         * <p>
         * @return {@code this}
         * @param codeBuildDefaults Customize the CodeBuild projects created for this pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildDefaults(final software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults) {
            this.props.codeBuildDefaults(codeBuildDefaults);
            return this;
        }

        /**
         * An existing Pipeline to be reused and built upon.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - a new underlying pipeline is created.
         * <p>
         * @return {@code this}
         * @param codePipeline An existing Pipeline to be reused and built upon. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codePipeline(final software.amazon.awscdk.services.codepipeline.Pipeline codePipeline) {
            this.props.codePipeline(codePipeline);
            return this;
        }

        /**
         * Create KMS keys for the artifact buckets, allowing cross-account deployments.
         * <p>
         * The artifact buckets have to be encrypted to support deploying CDK apps to
         * another account, so if you want to do that or want to have your artifact
         * buckets encrypted, be sure to set this value to <code>true</code>.
         * <p>
         * Be aware there is a cost associated with maintaining the KMS keys.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param crossAccountKeys Create KMS keys for the artifact buckets, allowing cross-account deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountKeys(final java.lang.Boolean crossAccountKeys) {
            this.props.crossAccountKeys(crossAccountKeys);
            return this;
        }

        /**
         * A map of region to S3 bucket name used for cross-region CodePipeline.
         * <p>
         * For every Action that you specify targeting a different region than the Pipeline itself,
         * if you don't provide an explicit Bucket for that region using this property,
         * the construct will automatically create a Stack containing an S3 Bucket in that region.
         * Passed directly through to the {@link cp.Pipeline}.
         * <p>
         * Default: - no cross region replication buckets.
         * <p>
         * @return {@code this}
         * @param crossRegionReplicationBuckets A map of region to S3 bucket name used for cross-region CodePipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossRegionReplicationBuckets(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets) {
            this.props.crossRegionReplicationBuckets(crossRegionReplicationBuckets);
            return this;
        }

        /**
         * A list of credentials used to authenticate to Docker registries.
         * <p>
         * Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param dockerCredentials A list of credentials used to authenticate to Docker registries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerCredentials(final java.util.List<? extends software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials) {
            this.props.dockerCredentials(dockerCredentials);
            return this;
        }

        /**
         * Enable Docker for the self-mutate step.
         * <p>
         * Set this to true if the pipeline itself uses Docker container assets
         * (for example, if you use <code>LinuxBuildImage.fromAsset()</code> as the build
         * image of a CodeBuild step in the pipeline).
         * <p>
         * You do not need to set it if you build Docker image assets in the
         * application Stages and Stacks that are <em>deployed</em> by this pipeline.
         * <p>
         * Configures privileged mode for the self-mutation CodeBuild action.
         * <p>
         * If you are about to turn this on in an already-deployed Pipeline,
         * set the value to <code>true</code> first, commit and allow the pipeline to
         * self-update, and only then use the Docker asset in the pipeline.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param dockerEnabledForSelfMutation Enable Docker for the self-mutate step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerEnabledForSelfMutation(final java.lang.Boolean dockerEnabledForSelfMutation) {
            this.props.dockerEnabledForSelfMutation(dockerEnabledForSelfMutation);
            return this;
        }

        /**
         * Enable Docker for the 'synth' step.
         * <p>
         * Set this to true if you are using file assets that require
         * "bundling" anywhere in your application (meaning an asset
         * compilation step will be run with the tools provided by
         * a Docker image), both for the Pipeline stack as well as the
         * application stacks.
         * <p>
         * A common way to use bundling assets in your application is by
         * using the <code>aws-cdk-lib/aws-lambda-nodejs</code> library.
         * <p>
         * Configures privileged mode for the synth CodeBuild action.
         * <p>
         * If you are about to turn this on in an already-deployed Pipeline,
         * set the value to <code>true</code> first, commit and allow the pipeline to
         * self-update, and only then use the bundled asset.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param dockerEnabledForSynth Enable Docker for the 'synth' step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerEnabledForSynth(final java.lang.Boolean dockerEnabledForSynth) {
            this.props.dockerEnabledForSynth(dockerEnabledForSynth);
            return this;
        }

        /**
         * Enable KMS key rotation for the generated KMS keys.
         * <p>
         * By default KMS key rotation is disabled, but will add
         * additional costs when enabled.
         * <p>
         * Default: - false (key rotation is disabled)
         * <p>
         * @return {@code this}
         * @param enableKeyRotation Enable KMS key rotation for the generated KMS keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(final java.lang.Boolean enableKeyRotation) {
            this.props.enableKeyRotation(enableKeyRotation);
            return this;
        }

        /**
         * The name of the CodePipeline pipeline.
         * <p>
         * Default: - Automatically generated
         * <p>
         * @return {@code this}
         * @param pipelineName The name of the CodePipeline pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(final java.lang.String pipelineName) {
            this.props.pipelineName(pipelineName);
            return this;
        }

        /**
         * Type of the pipeline.
         * <p>
         * Default: - PipelineType.V2 if the feature flag `CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2`
         * is true, PipelineType.V1 otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html</a>
         * @param pipelineType Type of the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineType(final software.amazon.awscdk.services.codepipeline.PipelineType pipelineType) {
            this.props.pipelineType(pipelineType);
            return this;
        }

        /**
         * Publish assets in multiple CodeBuild projects.
         * <p>
         * If set to false, use one Project per type to publish all assets.
         * <p>
         * Publishing in parallel improves concurrency and may reduce publishing
         * latency, but may also increase overall provisioning time of the CodeBuild
         * projects.
         * <p>
         * Experiment and see what value works best for you.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param publishAssetsInParallel Publish assets in multiple CodeBuild projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishAssetsInParallel(final java.lang.Boolean publishAssetsInParallel) {
            this.props.publishAssetsInParallel(publishAssetsInParallel);
            return this;
        }

        /**
         * Reuse the same cross region support stack for all pipelines in the App.
         * <p>
         * Default: - true (Use the same support stack for all pipelines in App)
         * <p>
         * @return {@code this}
         * @param reuseCrossRegionSupportStacks Reuse the same cross region support stack for all pipelines in the App. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseCrossRegionSupportStacks(final java.lang.Boolean reuseCrossRegionSupportStacks) {
            this.props.reuseCrossRegionSupportStacks(reuseCrossRegionSupportStacks);
            return this;
        }

        /**
         * The IAM role to be assumed by this Pipeline.
         * <p>
         * Default: - A new role is created
         * <p>
         * @return {@code this}
         * @param role The IAM role to be assumed by this Pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Whether the pipeline will update itself.
         * <p>
         * This needs to be set to <code>true</code> to allow the pipeline to reconfigure
         * itself when assets or stages are being added to it, and <code>true</code> is the
         * recommended setting.
         * <p>
         * You can temporarily set this to <code>false</code> while you are iterating
         * on the pipeline itself and prefer to deploy changes using <code>cdk deploy</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param selfMutation Whether the pipeline will update itself. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfMutation(final java.lang.Boolean selfMutation) {
            this.props.selfMutation(selfMutation);
            return this;
        }

        /**
         * Additional customizations to apply to the self mutation CodeBuild projects.
         * <p>
         * Default: - Only `codeBuildDefaults` are applied
         * <p>
         * @return {@code this}
         * @param selfMutationCodeBuildDefaults Additional customizations to apply to the self mutation CodeBuild projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfMutationCodeBuildDefaults(final software.amazon.awscdk.pipelines.CodeBuildOptions selfMutationCodeBuildDefaults) {
            this.props.selfMutationCodeBuildDefaults(selfMutationCodeBuildDefaults);
            return this;
        }

        /**
         * Additional customizations to apply to the synthesize CodeBuild projects.
         * <p>
         * Default: - Only `codeBuildDefaults` are applied
         * <p>
         * @return {@code this}
         * @param synthCodeBuildDefaults Additional customizations to apply to the synthesize CodeBuild projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthCodeBuildDefaults(final software.amazon.awscdk.pipelines.CodeBuildOptions synthCodeBuildDefaults) {
            this.props.synthCodeBuildDefaults(synthCodeBuildDefaults);
            return this;
        }

        /**
         * Deploy every stack by creating a change set and executing it.
         * <p>
         * When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
         * to deploy the stack in one pipeline action.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param useChangeSets Deploy every stack by creating a change set and executing it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useChangeSets(final java.lang.Boolean useChangeSets) {
            this.props.useChangeSets(useChangeSets);
            return this;
        }

        /**
         * Use pipeline service role for actions if no action role configured.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param usePipelineRoleForActions Use pipeline service role for actions if no action role configured. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usePipelineRoleForActions(final java.lang.Boolean usePipelineRoleForActions) {
            this.props.usePipelineRoleForActions(usePipelineRoleForActions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.pipelines.CodePipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.pipelines.CodePipeline build() {
            return new software.amazon.awscdk.pipelines.CodePipeline(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
