/**
 * <h1>AWS Lambda Layer with AWS CLI</h1>
 * <p>
 * This module exports a single class called <code>AwsCliLayer</code> which is a <code>lambda.Layer</code> that bundles the AWS CLI.
 * <p>
 * Any Lambda Function that uses this layer must use a Python 3.x runtime.
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // AwsCliLayer bundles the AWS CLI in a lambda layer
 * import software.amazon.awscdk.lambdalayer.awscli.AwsCliLayer;
 * 
 * Function fn;
 * 
 * fn.addLayers(new AwsCliLayer(this, "AwsCliLayer"));
 * </pre></blockquote>
 * <p>
 * The CLI will be installed under <code>/opt/awscli/aws</code>.
 * <p>
 * <h2>Alternatives</h2>
 * <p>
 * This module bundles AWS cli v1. To use AWS cli v2, you can use the
 * external module <a href="https://github.com/cdklabs/awscdk-asset-awscli/tree/awscli-v2/main">awscdk-asset-awscli</a>.
 */
package software.amazon.awscdk.lambdalayer.awscli;
