package software.amazon.awscdk.aws_apigatewayv2_authorizers;

/**
 * Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.*;
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration;
 * UserPool userPool = new UserPool(this, "UserPool");
 * HttpUserPoolAuthorizer authorizer = new HttpUserPoolAuthorizer("BooksAuthorizer", userPool);
 * HttpApi api = new HttpApi(this, "HttpApi");
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:06.630Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizer")
public class HttpUserPoolAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer {

    protected HttpUserPoolAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpUserPoolAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initialize a Cognito user pool authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param pool The user pool to use for authorization. This parameter is required.
     * @param props Properties to configure the authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpUserPoolAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool pool, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(pool, "pool is required"), props });
    }

    /**
     * Initialize a Cognito user pool authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param pool The user pool to use for authorization. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpUserPoolAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool pool) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(pool, "pool is required") });
    }

    /**
     * Bind this authorizer to a specified Http route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The authorizationType used for UserPool Authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationType() {
        return software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the id of the authorizer if it's been constructed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerId() {
        return software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id The id of the underlying construct. This parameter is required.
         * @param pool The user pool to use for authorization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id, final software.amazon.awscdk.services.cognito.IUserPool pool) {
            return new Builder(id, pool);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.IUserPool pool;
        private software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizerProps.Builder props;

        private Builder(final java.lang.String id, final software.amazon.awscdk.services.cognito.IUserPool pool) {
            this.id = id;
            this.pool = pool;
        }

        /**
         * Friendly name of the authorizer.
         * <p>
         * Default: - same value as `id` passed in the constructor
         * <p>
         * @return {@code this}
         * @param authorizerName Friendly name of the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props().authorizerName(authorizerName);
            return this;
        }

        /**
         * The identity source for which authorization is requested.
         * <p>
         * Default: ['$request.header.Authorization']
         * <p>
         * @return {@code this}
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(final java.util.List<java.lang.String> identitySource) {
            this.props().identitySource(identitySource);
            return this;
        }

        /**
         * The user pool clients that should be used to authorize requests with the user pool.
         * <p>
         * Default: - a new client will be created for the given user pool
         * <p>
         * @return {@code this}
         * @param userPoolClients The user pool clients that should be used to authorize requests with the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolClients(final java.util.List<? extends software.amazon.awscdk.services.cognito.IUserPoolClient> userPoolClients) {
            this.props().userPoolClients(userPoolClients);
            return this;
        }

        /**
         * The AWS region in which the user pool is present.
         * <p>
         * Default: - same region as the Route the authorizer is attached to.
         * <p>
         * @return {@code this}
         * @param userPoolRegion The AWS region in which the user pool is present. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolRegion(final java.lang.String userPoolRegion) {
            this.props().userPoolRegion(userPoolRegion);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizer build() {
            return new software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizer(
                this.id,
                this.pool,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizerProps.Builder();
            }
            return this.props;
        }
    }
}
