/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.types.internal;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.reflections.Reflections;
import se.l4.commons.types.InstanceFactory;
import se.l4.commons.types.TypeFinder;

public class TypeFinderOverReflections
implements TypeFinder {
    private final Reflections reflections;
    private final InstanceFactory factory;

    public TypeFinderOverReflections(InstanceFactory factory, Reflections reflections) {
        this.factory = factory;
        this.reflections = reflections;
    }

    @Override
    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.reflections.getTypesAnnotatedWith(annotationType);
    }

    @Override
    public Set<? extends Object> getTypesAnnotatedWithAsInstances(Class<? extends Annotation> annotationType) {
        return this.create(this.getTypesAnnotatedWith(annotationType));
    }

    @Override
    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return this.reflections.getSubTypesOf(type);
    }

    @Override
    public <T> Set<? extends T> getSubTypesAsInstances(Class<T> type) {
        return this.create(this.getSubTypesOf(type));
    }

    private <T> Set<? extends T> create(Iterable<Class<? extends T>> types) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class<T> t : types) {
            if (Modifier.isAbstract(t.getModifiers()) || t.isInterface()) continue;
            T instance = this.factory.create(t);
            builder.add(instance);
        }
        return builder.build();
    }
}

