/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.standard;

import java.io.IOException;
import se.l4.commons.serialization.QualifiedName;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerCollection;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;
import se.l4.commons.serialization.format.ValueType;

public class DynamicSerializer
implements Serializer<Object> {
    private final SerializerCollection collection;
    private final SerializerFormatDefinition formatDefinition;

    public DynamicSerializer(SerializerCollection collection) {
        this.collection = collection;
        this.formatDefinition = SerializerFormatDefinition.builder().field("namespace").using(ValueType.STRING).field("name").using(ValueType.STRING).field("value").using(SerializerFormatDefinition.any()).build();
    }

    @Override
    public Object read(StreamingInput in) throws IOException {
        in.next(Token.OBJECT_START);
        String namespace = "";
        String name = null;
        Object result = null;
        boolean resultRead = false;
        while (in.peek() != Token.OBJECT_END) {
            String value;
            in.next(Token.KEY);
            String key = in.getString();
            if ("namespace".equals(key)) {
                in.next(Token.VALUE);
                namespace = value = in.getString();
                continue;
            }
            if ("name".equals(key)) {
                in.next(Token.VALUE);
                name = value = in.getString();
                continue;
            }
            if ("value".equals(key)) {
                if (name == null) {
                    throw new SerializationException("Name of type must come before dynamic value");
                }
                resultRead = true;
                Serializer<?> serializer = this.collection.find(namespace, name);
                if (serializer == null) {
                    in.skipValue();
                    continue;
                }
                result = serializer.read(in);
                continue;
            }
            in.skipValue();
        }
        if (!resultRead) {
            throw new SerializationException("Dynamic serialization requires a value");
        }
        in.next(Token.OBJECT_END);
        return result;
    }

    @Override
    public void write(Object object, String name, StreamingOutput stream) throws IOException {
        Serializer<?> serializer = this.collection.find(object.getClass());
        QualifiedName qname = this.collection.findName(serializer);
        if (qname == null) {
            throw new SerializationException("Tried to use dynamic serialization for " + object.getClass() + ", but type has no name");
        }
        stream.writeObjectStart(name);
        if (!qname.getNamespace().equals("")) {
            stream.write("namespace", qname.getNamespace());
        }
        stream.write("name", qname.getName());
        serializer.write(object, "value", stream);
        stream.writeObjectEnd(name);
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.formatDefinition;
    }
}

