/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.format;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import se.l4.commons.serialization.format.StreamingOutput;

public class JsonOutput
implements StreamingOutput {
    private static final int HEX_MASK = 15;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] BASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int LEVELS = 20;
    protected final Writer writer;
    private final boolean beautify;
    private boolean[] lists;
    private boolean[] hasData;
    private int level;
    private final char[] encoded;

    public JsonOutput(OutputStream out) {
        this(out, false);
    }

    public JsonOutput(OutputStream out, boolean beautify) {
        this(new OutputStreamWriter(out), beautify);
    }

    public JsonOutput(Writer writer) {
        this(writer, false);
    }

    public JsonOutput(Writer writer, boolean beautify) {
        this.writer = writer;
        this.beautify = beautify;
        this.lists = new boolean[20];
        this.hasData = new boolean[20];
        this.encoded = new char[4];
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    private void writeEscaped(String in) throws IOException {
        int n = in.length();
        for (int i = 0; i < n; ++i) {
            int c = in.charAt(i);
            if (c == 34 || c == 92) {
                this.writer.write(92);
                this.writer.write(c);
                continue;
            }
            if (c == 13) {
                this.writer.write(92);
                this.writer.write(114);
                continue;
            }
            if (c == 10) {
                this.writer.write(92);
                this.writer.write(110);
                continue;
            }
            if (c == 9) {
                this.writer.write(92);
                this.writer.write(116);
                continue;
            }
            if (c == 8) {
                this.writer.write(92);
                this.writer.write(98);
                continue;
            }
            if (c == 12) {
                this.writer.write(92);
                this.writer.write(102);
                continue;
            }
            if (c <= 31) {
                this.writer.write(92);
                this.writer.write(117);
                int v = c;
                int pos = 4;
                do {
                    this.encoded[--pos] = DIGITS[v & 0xF];
                } while ((v >>>= 4) != 0);
                for (int j = 0; j < pos; ++j) {
                    this.writer.write(48);
                }
                this.writer.write(this.encoded, pos, 4 - pos);
                continue;
            }
            this.writer.write(c);
        }
    }

    private void increaseLevel(boolean list) {
        ++this.level;
        if (this.hasData.length == this.level) {
            this.hasData = Arrays.copyOf(this.hasData, this.hasData.length * 2);
            this.lists = Arrays.copyOf(this.lists, this.hasData.length * 2);
        }
        this.hasData[this.level] = false;
        this.lists[this.level] = list;
    }

    private void decreaseLevel() throws IOException {
        --this.level;
        if (this.beautify && this.hasData[this.level]) {
            this.writer.write(10);
            for (int i = 0; i < this.level; ++i) {
                this.writer.write("\t");
            }
        }
    }

    private void startWrite() throws IOException {
        if (this.hasData[this.level]) {
            this.writer.write(44);
        }
        this.hasData[this.level] = true;
        if (this.beautify && this.level > 0) {
            this.writer.write(10);
            for (int i = 0; i < this.level; ++i) {
                this.writer.write(9);
            }
        }
    }

    private boolean shouldOutputName() {
        return this.level != 0 && !this.lists[this.level];
    }

    @Override
    public void writeObjectStart(String name) throws IOException {
        this.startWrite();
        if (this.shouldOutputName()) {
            this.writer.write(34);
            this.writeEscaped(name);
            this.writer.write(34);
            this.writer.write(58);
        }
        this.writer.write(123);
        this.increaseLevel(false);
    }

    @Override
    public void writeObjectEnd(String name) throws IOException {
        this.decreaseLevel();
        this.writer.write(125);
    }

    @Override
    public void writeListStart(String name) throws IOException {
        this.startWrite();
        if (this.shouldOutputName()) {
            this.writer.write(34);
            this.writeEscaped(name);
            this.writer.write(34);
            this.writer.write(58);
        }
        this.writer.write(91);
        this.increaseLevel(true);
    }

    @Override
    public void writeListEnd(String name) throws IOException {
        this.decreaseLevel();
        this.writer.write(93);
    }

    @Override
    public void write(String name, String value) throws IOException {
        this.startWrite();
        if (this.shouldOutputName()) {
            this.writer.write(34);
            this.writeEscaped(name);
            this.writer.write(34);
            this.writer.write(58);
        }
        if (value == null) {
            this.writer.write("null");
        } else {
            this.writer.write(34);
            this.writeEscaped(value);
            this.writer.write(34);
        }
    }

    private void writeUnescaped(String name, String value) throws IOException {
        this.startWrite();
        if (this.shouldOutputName()) {
            this.writer.write(34);
            this.writeEscaped(name);
            this.writer.write(34);
            this.writer.write(58);
        }
        if (value == null) {
            this.writer.write("null");
        } else {
            this.writer.write(value);
        }
    }

    @Override
    public void write(String name, int number) throws IOException {
        this.writeUnescaped(name, Integer.toString(number));
    }

    @Override
    public void write(String name, long number) throws IOException {
        this.writeUnescaped(name, Long.toString(number));
    }

    @Override
    public void write(String name, float number) throws IOException {
        this.writeUnescaped(name, Float.toString(number));
    }

    @Override
    public void write(String name, double number) throws IOException {
        this.writeUnescaped(name, Double.toString(number));
    }

    @Override
    public void write(String name, boolean bool) throws IOException {
        this.writeUnescaped(name, Boolean.toString(bool));
    }

    @Override
    public void write(String name, byte[] data) throws IOException {
        int i;
        this.startWrite();
        if (this.shouldOutputName()) {
            this.writer.write(34);
            this.writeEscaped(name);
            this.writer.write(34);
            this.writer.write(58);
        }
        if (data == null) {
            this.writer.write("null");
            return;
        }
        this.writer.write(34);
        int n = data.length - 2;
        for (i = 0; i < n; i += 3) {
            this.write(data, i, 3);
        }
        if (i < data.length) {
            this.write(data, i, data.length - i);
        }
        this.writer.write(34);
    }

    private void write(byte[] data, int pos, int len) throws IOException {
        char[] chars = BASE64;
        int loc = (len > 0 ? data[pos] << 24 >>> 8 : 0) | (len > 1 ? data[pos + 1] << 24 >>> 16 : 0) | (len > 2 ? data[pos + 2] << 24 >>> 24 : 0);
        switch (len) {
            case 3: {
                this.writer.write(chars[loc >>> 18]);
                this.writer.write(chars[loc >>> 12 & 0x3F]);
                this.writer.write(chars[loc >>> 6 & 0x3F]);
                this.writer.write(chars[loc & 0x3F]);
                break;
            }
            case 2: {
                this.writer.write(chars[loc >>> 18]);
                this.writer.write(chars[loc >>> 12 & 0x3F]);
                this.writer.write(chars[loc >>> 6 & 0x3F]);
                this.writer.write(61);
                break;
            }
            case 1: {
                this.writer.write(chars[loc >>> 18]);
                this.writer.write(chars[loc >>> 12 & 0x3F]);
                this.writer.write(61);
                this.writer.write(61);
            }
        }
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.write(name, (String)null);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

