/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.collections;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;

public class MapAsObjectSerializer<V>
implements Serializer<Map<String, V>> {
    private final Serializer<V> serializer;
    private final SerializerFormatDefinition formatDefinition;

    public MapAsObjectSerializer(Serializer<V> serializer) {
        this.serializer = serializer;
        this.formatDefinition = SerializerFormatDefinition.builder().field("*").using(serializer).build();
    }

    @Override
    public Map<String, V> read(StreamingInput in) throws IOException {
        in.next(Token.OBJECT_START);
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (in.peek() != Token.OBJECT_END) {
            in.next(Token.KEY);
            String key = in.getString();
            if (key.startsWith("_aurochs_:")) {
                in.skipValue();
                continue;
            }
            Object value = in.peek() == Token.NULL ? null : (Object)this.serializer.read(in);
            result.put(key, value);
        }
        in.next(Token.OBJECT_END);
        return result;
    }

    @Override
    public void write(Map<String, V> object, String name, StreamingOutput stream) throws IOException {
        stream.writeObjectStart(name);
        for (Map.Entry<String, V> e : object.entrySet()) {
            V value = e.getValue();
            if (value == null) {
                stream.writeNull(name);
                continue;
            }
            this.serializer.write(value, e.getKey(), stream);
        }
        stream.writeObjectEnd(name);
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.formatDefinition;
    }
}

