/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import se.l4.commons.io.Bytes;
import se.l4.commons.io.BytesBuilder;
import se.l4.commons.io.ExtendedDataInput;

public class ExtendedDataInputStream
extends DataInputStream
implements ExtendedDataInput {
    private static final int CHARS_SIZE = 1024;
    private static final ThreadLocal<char[]> CHARS = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };

    public ExtendedDataInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int readVInt() throws IOException {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            byte b = (byte)this.read();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new EOFException("Invalid integer");
    }

    @Override
    public long readVLong() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = (byte)this.read();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new EOFException("Invalid long");
    }

    @Override
    public String readString() throws IOException {
        int length = this.readVInt();
        char[] chars = length < 1024 ? CHARS.get() : new char[length];
        for (int i = 0; i < length; ++i) {
            int c = this.in.read() & 0xFF;
            int t = c >> 4;
            if (t > -1 && t < 8) {
                chars[i] = (char)c;
                continue;
            }
            if (t == 12 || t == 13) {
                chars[i] = (char)((c & 0x1F) << 6 | this.in.read() & 0x3F);
                continue;
            }
            if (t != 14) continue;
            chars[i] = (char)((c & 0xF) << 12 | (this.in.read() & 0x3F) << 6 | (this.in.read() & 0x3F) << 0);
        }
        return new String(chars, 0, length);
    }

    @Override
    public Bytes readBytes() throws IOException {
        BytesBuilder builder = Bytes.create();
        byte[] buffer = new byte[8192];
        int len;
        while ((len = this.readVInt()) != 0) {
            this.readFully(buffer, 0, len);
            builder.addChunk(buffer, 0, len);
        }
        return builder.build();
    }

    @Override
    public Bytes readTemporaryBytes() throws IOException {
        return new TemporaryBytes(this);
    }

    private static class TemporaryInputStream
    extends InputStream {
        private final ExtendedDataInput in;
        private int remaining;

        public TemporaryInputStream(ExtendedDataInput in) throws IOException {
            this.in = in;
            this.remaining = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.remaining == -1) {
                return -1;
            }
            if (this.remaining == 0) {
                this.remaining = this.in.readVInt();
                if (this.remaining == 0) {
                    this.remaining = -1;
                    return -1;
                }
            }
            --this.remaining;
            return this.in.readUnsignedByte();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.remaining == -1) {
                return -1;
            }
            if (this.remaining == 0) {
                this.remaining = this.in.readVInt();
                if (this.remaining == 0) {
                    this.remaining = -1;
                    return -1;
                }
            }
            len = Math.min(len, this.remaining);
            this.in.readFully(b, off, len);
            return len;
        }
    }

    private static class TemporaryBytes
    implements Bytes {
        private final ExtendedDataInput parent;

        public TemporaryBytes(ExtendedDataInput parent) {
            this.parent = parent;
        }

        @Override
        public InputStream asInputStream() throws IOException {
            return new TemporaryInputStream(this.parent);
        }

        @Override
        public byte[] toByteArray() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

