/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.io;

import java.io.IOException;
import java.io.InputStream;
import se.l4.commons.io.ByteArrayConsumer;
import se.l4.commons.io.BytesBuilder;
import se.l4.commons.io.BytesOverByteArray;
import se.l4.commons.io.ExtendedDataInput;
import se.l4.commons.io.ExtendedDataInputStream;
import se.l4.commons.io.ExtendedDataOutput;
import se.l4.commons.io.InputStreamBytes;
import se.l4.commons.io.IoConsumer;
import se.l4.commons.io.IoSupplier;

public interface Bytes {
    public InputStream asInputStream() throws IOException;

    public byte[] toByteArray() throws IOException;

    default public void asChunks(ByteArrayConsumer consumer) throws IOException {
        this.asChunks(4096, consumer);
    }

    default public void asChunks(int size, ByteArrayConsumer consumer) throws IOException {
        try (InputStream in = this.asInputStream();){
            int len;
            byte[] buf = new byte[size];
            while ((len = in.read(buf)) != -1) {
                consumer.consume(buf, 0, len);
            }
        }
    }

    default public ExtendedDataInput asDataInput() throws IOException {
        return new ExtendedDataInputStream(this.asInputStream());
    }

    public static Bytes empty() {
        return BytesOverByteArray.EMPTY;
    }

    public static Bytes create(byte[] byteArray) {
        return new BytesOverByteArray(byteArray);
    }

    public static Bytes create(IoSupplier<InputStream> stream) {
        return new InputStreamBytes(stream);
    }

    public static Bytes lazyViaDataOutput(IoConsumer<ExtendedDataOutput> creator) {
        return BytesBuilder.createViaLazyDataOutput(creator);
    }

    public static Bytes lazyViaDataOutput(IoConsumer<ExtendedDataOutput> creator, int expectedSize) {
        return BytesBuilder.createViaLazyDataOutput(creator, expectedSize);
    }

    public static Bytes viaDataOutput(IoConsumer<ExtendedDataOutput> creator) throws IOException {
        return BytesBuilder.createViaDataOutput(creator);
    }

    public static Bytes viaDataOutput(IoConsumer<ExtendedDataOutput> creator, int expectedSize) throws IOException {
        return BytesBuilder.createViaDataOutput(creator, expectedSize);
    }

    public static BytesBuilder create() {
        return new BytesBuilder();
    }
}

