/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal.streaming;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.l4.commons.config.internal.streaming.ListInput;
import se.l4.commons.config.internal.streaming.NullInput;
import se.l4.commons.config.internal.streaming.ValueInput;
import se.l4.commons.serialization.format.AbstractStreamingInput;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.Token;

public class MapInput
extends AbstractStreamingInput {
    private State state;
    private State previousState;
    private Token token;
    private Map.Entry<String, Object> entry;
    private Iterator<Map.Entry<String, Object>> iterator;
    private StreamingInput subInput;
    private String key;

    public MapInput(String key, Map<String, Object> root) {
        this.key = key;
        this.state = State.START;
        this.iterator = root.entrySet().iterator();
    }

    @Override
    public void close() throws IOException {
    }

    public static StreamingInput resolveInput(String key, Object data) {
        if (data instanceof Map) {
            return new MapInput(key, (Map)data);
        }
        if (data instanceof List) {
            return new ListInput(key, (List)data);
        }
        if (data == null) {
            return new NullInput(key);
        }
        return new ValueInput(key, data);
    }

    private StreamingInput resolveInput() {
        String newKey = this.key.isEmpty() ? this.entry.getKey() : this.key + '.' + this.entry.getKey();
        return MapInput.resolveInput(newKey, this.entry.getValue());
    }

    @Override
    protected IOException raiseException(String message) {
        return new IOException(this.key + ": " + message);
    }

    @Override
    public Token peek() throws IOException {
        switch (this.state) {
            case START: {
                return Token.OBJECT_START;
            }
            case KEY: {
                return Token.KEY;
            }
            case VALUE: {
                Token peeked = this.subInput.peek();
                if (peeked != null) {
                    return peeked;
                }
                this.advancePosition();
                return this.peek();
            }
            case END: {
                return Token.OBJECT_END;
            }
        }
        return null;
    }

    @Override
    public Token next0() throws IOException {
        switch (this.state) {
            case START: {
                this.advancePosition();
                this.token = Token.OBJECT_START;
                return this.token;
            }
            case KEY: {
                this.setState(State.VALUE);
                this.subInput = this.resolveInput();
                this.token = Token.KEY;
                return this.token;
            }
            case VALUE: {
                Token t = this.subInput.next();
                if (t == null) {
                    this.advancePosition();
                    return this.next();
                }
                this.setState(State.VALUE);
                this.token = t;
                return this.token;
            }
            case END: {
                this.setState(State.DONE);
                this.token = Token.OBJECT_END;
                return this.token;
            }
        }
        this.token = null;
        return null;
    }

    private void setState(State state) {
        this.previousState = this.state;
        this.state = state;
    }

    private void advancePosition() {
        if (this.iterator.hasNext()) {
            this.entry = this.iterator.next();
            this.setState(State.KEY);
        } else {
            this.setState(State.END);
        }
    }

    @Override
    public Token current() {
        return this.subInput != null ? this.subInput.current() : this.token;
    }

    @Override
    public Object getValue() {
        switch (this.previousState) {
            case KEY: {
                return this.entry.getKey();
            }
            case VALUE: {
                return this.subInput.getValue();
            }
        }
        return null;
    }

    @Override
    public String getString() {
        switch (this.previousState) {
            case KEY: {
                return this.entry.getKey();
            }
            case VALUE: {
                return this.subInput.getString();
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean() {
        switch (this.previousState) {
            case VALUE: {
                return this.subInput.getBoolean();
            }
        }
        return false;
    }

    @Override
    public double getDouble() {
        switch (this.previousState) {
            case VALUE: {
                return this.subInput.getDouble();
            }
        }
        return 0.0;
    }

    @Override
    public float getFloat() {
        switch (this.previousState) {
            case VALUE: {
                return this.subInput.getFloat();
            }
        }
        return 0.0f;
    }

    @Override
    public long getLong() {
        switch (this.previousState) {
            case VALUE: {
                return this.subInput.getLong();
            }
        }
        return 0L;
    }

    @Override
    public int getInt() {
        switch (this.previousState) {
            case VALUE: {
                return this.subInput.getInt();
            }
        }
        return 0;
    }

    @Override
    public short getShort() {
        switch (this.previousState) {
            case VALUE: {
                return this.subInput.getShort();
            }
        }
        return 0;
    }

    private static enum State {
        START,
        KEY,
        VALUE,
        END,
        DONE;

    }
}

