/*
 * Decompiled with CFR 0.152.
 */
package se.jguru.nazgul.tools.validation.api.expression;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import se.jguru.nazgul.tools.validation.api.exception.AbstractErrorMessageContainer;
import se.jguru.nazgul.tools.validation.api.exception.ErrorMessageContainer;
import se.jguru.nazgul.tools.validation.api.expression.ValidationExecutor;

public class ExpressionBuilder
implements ValidationExecutor {
    private final ErrorMessageContainer messageContainer;

    public ExpressionBuilder(ErrorMessageContainer messageContainer) throws IllegalArgumentException {
        Validate.notNull((Object)messageContainer, (String)"Cannot handle null messageContainer instance.", (Object[])new Object[0]);
        this.messageContainer = messageContainer;
    }

    @Override
    public void endExpressionAndValidate() throws AbstractErrorMessageContainer {
        this.messageContainer.endExpressionAndValidate();
    }

    public ExpressionBuilder addDescription(String desc) {
        this.messageContainer.addErrorMessage(desc);
        return this;
    }

    public ExpressionBuilder notNull(Object property, String name) {
        if (property == null) {
            this.messageContainer.addErrorMessage("Property '" + name + "' cannot be null");
        }
        return this;
    }

    public ExpressionBuilder notTrue(boolean expression, String name) {
        if (expression) {
            this.messageContainer.addErrorMessage("Expression '" + name + "' cannot be true.");
        }
        return this;
    }

    public ExpressionBuilder notNullOrEmpty(Object property, String name) {
        this.notNull(property, name);
        if (property instanceof String && ((String)property).isEmpty()) {
            this.messageContainer.addErrorMessage("Property '" + name + "' cannot be empty.");
        }
        if (property instanceof Collection && ((Collection)property).isEmpty()) {
            this.messageContainer.addErrorMessage("Collection '" + name + "' must contain elements.");
        }
        if (property instanceof Map && ((Map)property).isEmpty()) {
            this.messageContainer.addErrorMessage("Map '" + name + "' must contain elements.");
        }
        return this;
    }
}

