/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces.transformers.arrays2d;

import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.ArrayUtils;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import shadow.de.vandermeer.skb.interfaces.transformers.IsTransformer;

public interface Array2D_To_NormalizedArray
extends IsTransformer<String[][], String[][]> {
    public int getNumberOfColumns();

    @Override
    default public String[][] transform(String[][] ar) {
        IsTransformer.super.transform(ar);
        int rows = 0;
        for (int row = 0; row < ar.length; ++row) {
            rows = Math.max(rows, ArrayUtils.getLength(ar[row]));
        }
        if (rows == 0) {
            rows = 1;
        }
        String[][] ret = new String[this.getNumberOfColumns()][rows];
        for (int row = 0; row < ar.length; ++row) {
            int i;
            int curSize = 0;
            if (ar[row] != null && ar[row][0] != null) {
                curSize = ar[row][0].length();
            }
            if (ar[row] == null) {
                for (i = 0; i < rows; ++i) {
                    ret[row][i] = null;
                }
                continue;
            }
            if (ar[row].length == 0) {
                for (i = 0; i < rows; ++i) {
                    ret[row][i] = new StrBuilder().appendPadding(curSize, ' ').toString();
                }
                continue;
            }
            for (int col = 0; col < ar[row].length; ++col) {
                ret[row][col] = ar[row][col];
            }
            if (ar[row].length >= rows) continue;
            for (i = ar[row].length; i < rows; ++i) {
                ret[row][i] = new StrBuilder().appendPadding(curSize, ' ').toString();
            }
        }
        return ret;
    }

    public static Array2D_To_NormalizedArray create(final int columns) {
        return new Array2D_To_NormalizedArray(){

            @Override
            public int getNumberOfColumns() {
                return columns;
            }
        };
    }
}

