/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces.transformers;

import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.StringUtils;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import shadow.de.vandermeer.skb.interfaces.transformers.IsTransformer;

public interface Integer_To_RomanLiteral
extends IsTransformer<Integer, String> {
    public static final int[] NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    public static final String[] LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    @Override
    default public String transform(Integer number) {
        Validate.notNull(number);
        Validate.validState(-1 < number && number < 4001, "Roman literals are only supported between 0 and 4000, number was: " + number, new Object[0]);
        String ret = "";
        for (int i = 0; i < NUMBERS.length; ++i) {
            while (number >= NUMBERS[i]) {
                ret = ret + LETTERS[i];
                number = number - NUMBERS[i];
            }
        }
        return ret;
    }

    public static Integer_To_RomanLiteral create() {
        return new Integer_To_RomanLiteral(){};
    }

    public static String convert(Integer number) {
        return StringUtils.join(Integer_To_RomanLiteral.create().transform(number), "");
    }
}

