/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.stringtemplate.v4.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import se.bjurr.violations.violationsgitlib.org.stringtemplate.v4.misc.AmbiguousMatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeRegistry<V>
implements Map<Class<?>, V> {
    private final Map<Class<?>, V> backingStore = new HashMap();
    private final Map<Class<?>, Class<?>> cache = new HashMap();

    @Override
    public int size() {
        return this.backingStore.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingStore.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.cache.containsKey(key)) {
            return true;
        }
        if (!(key instanceof Class)) {
            return false;
        }
        return this.get((Class)key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        V value = this.backingStore.get(key);
        if (value != null) {
            return value;
        }
        Class<?> redirect = this.cache.get(key);
        if (redirect != null) {
            if (redirect == Void.TYPE) {
                return null;
            }
            return this.backingStore.get(redirect);
        }
        if (!(key instanceof Class)) {
            return null;
        }
        Class keyClass = (Class)key;
        ArrayList<Class> candidates = new ArrayList<Class>();
        for (Class<?> clazz : this.backingStore.keySet()) {
            if (!clazz.isAssignableFrom(keyClass)) continue;
            candidates.add(clazz);
        }
        if (candidates.isEmpty()) {
            this.cache.put(keyClass, Void.TYPE);
            return null;
        }
        if (candidates.size() == 1) {
            this.cache.put(keyClass, (Class<?>)candidates.get(0));
            return this.backingStore.get(candidates.get(0));
        }
        block1: for (int i = 0; i < candidates.size() - 1; ++i) {
            if (candidates.get(i) == null) continue;
            for (int j = i + 1; j < candidates.size(); ++j) {
                if (((Class)candidates.get(i)).isAssignableFrom((Class)candidates.get(j))) {
                    candidates.set(i, null);
                    continue block1;
                }
                if (!((Class)candidates.get(j)).isAssignableFrom((Class)candidates.get(i))) continue;
                candidates.set(j, null);
            }
        }
        int j = 0;
        for (int i = 0; i < candidates.size(); ++i) {
            Class current = (Class)candidates.get(i);
            if (current == null) continue;
            if (i != j) {
                candidates.set(j, current);
            }
            ++j;
        }
        assert (j > 0);
        if (j != 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("The class '%s' does not match a single item in the registry. The %d ambiguous matches are:", keyClass.getName(), j));
            for (int i = 0; i < j; ++i) {
                builder.append(String.format("%n    %s", ((Class)candidates.get(j)).getName()));
            }
            throw new AmbiguousMatchException(builder.toString());
        }
        this.cache.put(keyClass, (Class<?>)candidates.get(0));
        return this.backingStore.get(candidates.get(0));
    }

    @Override
    public V put(Class<?> key, V value) {
        V result = this.get(key);
        this.backingStore.put(key, value);
        this.handleAlteration(key);
        return result;
    }

    @Override
    public V remove(Object key) {
        if (!(key instanceof Class)) {
            return null;
        }
        Class clazz = (Class)key;
        V previous = this.get(clazz);
        if (this.backingStore.remove(clazz) != null) {
            this.handleAlteration(clazz);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends Class<?>, ? extends V> m) {
        for (Map.Entry<Class<?>, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.backingStore.clear();
        this.cache.clear();
    }

    @Override
    public Set<Class<?>> keySet() {
        return Collections.unmodifiableSet(this.backingStore.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.backingStore.values());
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        return Collections.unmodifiableSet(this.backingStore.entrySet());
    }

    protected void handleAlteration(Class<?> clazz) {
        for (Map.Entry<Class<?>, Class<?>> entry : this.cache.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            entry.setValue(null);
        }
    }
}

