/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.annotations.NonNull;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Config;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.TypedConfigGetter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.RefSpec;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.StringUtils;

public class DefaultTypedConfigGetter
implements TypedConfigGetter {
    @Override
    public boolean getBoolean(Config config, String section, String subsection, String name, boolean defaultValue) {
        String n = config.getRawString(section, subsection, name);
        if (n == null) {
            return defaultValue;
        }
        if (Config.isMissing(n)) {
            return true;
        }
        try {
            return StringUtils.toBoolean(n);
        }
        catch (IllegalArgumentException err) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidBooleanValue, section, name, n), err);
        }
    }

    @Override
    public <T extends Enum<?>> T getEnum(Config config, T[] all, String section, String subsection, String name, T defaultValue) {
        String value = config.getString(section, subsection, name);
        if (value == null) {
            return defaultValue;
        }
        if (all[0] instanceof Config.ConfigEnum) {
            T[] TArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                if (((Config.ConfigEnum)t).matchConfigValue(value)) {
                    return t;
                }
                ++n2;
            }
        }
        String n = value.replace(' ', '_');
        n = n.replace('-', '_');
        T trueState = null;
        T falseState = null;
        T[] TArray = all;
        int n3 = all.length;
        int n4 = 0;
        while (n4 < n3) {
            T e = TArray[n4];
            if (StringUtils.equalsIgnoreCase(((Enum)e).name(), n)) {
                return e;
            }
            if (StringUtils.equalsIgnoreCase(((Enum)e).name(), "TRUE")) {
                trueState = e;
            } else if (StringUtils.equalsIgnoreCase(((Enum)e).name(), "FALSE")) {
                falseState = e;
            }
            ++n4;
        }
        if (trueState != null && falseState != null) {
            try {
                return StringUtils.toBoolean(n) ? trueState : falseState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (subsection != null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, section, subsection, name, value));
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported2, section, name, value));
    }

    @Override
    public int getInt(Config config, String section, String subsection, String name, int defaultValue) {
        long val = config.getLong(section, subsection, name, defaultValue);
        if (Integer.MIN_VALUE <= val && val <= Integer.MAX_VALUE) {
            return (int)val;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().integerValueOutOfRange, section, name));
    }

    @Override
    public long getLong(Config config, String section, String subsection, String name, long defaultValue) {
        String str = config.getString(section, subsection, name);
        if (str == null) {
            return defaultValue;
        }
        String n = str.trim();
        if (n.length() == 0) {
            return defaultValue;
        }
        long mul = 1L;
        switch (StringUtils.toLowerCase(n.charAt(n.length() - 1))) {
            case 'g': {
                mul = 0x40000000L;
                break;
            }
            case 'm': {
                mul = 0x100000L;
                break;
            }
            case 'k': {
                mul = 1024L;
            }
        }
        if (mul > 1L) {
            n = n.substring(0, n.length() - 1).trim();
        }
        if (n.length() == 0) {
            return defaultValue;
        }
        try {
            return mul * Long.parseLong(n);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidIntegerValue, section, name, str), nfe);
        }
    }

    @Override
    public long getTimeUnit(Config config, String section, String subsection, String name, long defaultValue, TimeUnit wantUnit) {
        int inputMul;
        TimeUnit inputUnit;
        String valueString = config.getString(section, subsection, name);
        if (valueString == null) {
            return defaultValue;
        }
        String s = valueString.trim();
        if (s.length() == 0) {
            return defaultValue;
        }
        if (s.startsWith("-")) {
            throw DefaultTypedConfigGetter.notTimeUnit(section, subsection, name, valueString);
        }
        Matcher m = Pattern.compile("^(0|[1-9][0-9]*)\\s*(.*)$").matcher(valueString);
        if (!m.matches()) {
            return defaultValue;
        }
        String digits = m.group(1);
        String unitName = m.group(2).trim();
        if (unitName.isEmpty()) {
            inputUnit = wantUnit;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "ns", "nanoseconds")) {
            inputUnit = TimeUnit.NANOSECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "us", "microseconds")) {
            inputUnit = TimeUnit.MICROSECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "ms", "milliseconds")) {
            inputUnit = TimeUnit.MILLISECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "s", "sec", "second", "seconds")) {
            inputUnit = TimeUnit.SECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "m", "min", "minute", "minutes")) {
            inputUnit = TimeUnit.MINUTES;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "h", "hr", "hour", "hours")) {
            inputUnit = TimeUnit.HOURS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "d", "day", "days")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "w", "week", "weeks")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 7;
        } else if (DefaultTypedConfigGetter.match(unitName, "mon", "month", "months")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 30;
        } else if (DefaultTypedConfigGetter.match(unitName, "y", "year", "years")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 365;
        } else {
            throw DefaultTypedConfigGetter.notTimeUnit(section, subsection, name, valueString);
        }
        try {
            return wantUnit.convert(Long.parseLong(digits) * (long)inputMul, inputUnit);
        }
        catch (NumberFormatException nfe) {
            IllegalArgumentException iae = DefaultTypedConfigGetter.notTimeUnit(section, subsection, unitName, valueString);
            iae.initCause(nfe);
            throw iae;
        }
    }

    private static boolean match(String a, String ... cases) {
        String[] stringArray = cases;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            String b = stringArray[n2];
            if (b != null && b.equalsIgnoreCase(a)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IllegalArgumentException notTimeUnit(String section, String subsection, String name, String valueString) {
        if (subsection != null) {
            return new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeUnitValue3, section, subsection, name, valueString));
        }
        return new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeUnitValue2, section, name, valueString));
    }

    @Override
    @NonNull
    public List<RefSpec> getRefSpecs(Config config, String section, String subsection, String name) {
        String[] values = config.getStringList(section, subsection, name);
        ArrayList<RefSpec> result = new ArrayList<RefSpec>(values.length);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String spec = stringArray[n2];
            result.add(new RefSpec(spec));
            ++n2;
        }
        return result;
    }
}

