/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.com.googlecode.javaewah;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import se.bjurr.violations.violationsgitlib.com.googlecode.javaewah.BitmapStorage;
import se.bjurr.violations.violationsgitlib.com.googlecode.javaewah.BufferedAndIterator;
import se.bjurr.violations.violationsgitlib.com.googlecode.javaewah.BufferedIterator;
import se.bjurr.violations.violationsgitlib.com.googlecode.javaewah.BufferedORIterator;
import se.bjurr.violations.violationsgitlib.com.googlecode.javaewah.BufferedXORIterator;
import se.bjurr.violations.violationsgitlib.com.googlecode.javaewah.IteratingRLW;

public final class IteratorAggregation {
    public static final int DEFAULT_MAX_BUF_SIZE = 65536;

    private IteratorAggregation() {
    }

    public static IteratingRLW not(final IteratingRLW x) {
        return new IteratingRLW(){

            @Override
            public boolean next() {
                return x.next();
            }

            @Override
            public long getLiteralWordAt(int index) {
                return x.getLiteralWordAt(index) ^ 0xFFFFFFFFFFFFFFFFL;
            }

            @Override
            public int getNumberOfLiteralWords() {
                return x.getNumberOfLiteralWords();
            }

            @Override
            public boolean getRunningBit() {
                return !x.getRunningBit();
            }

            @Override
            public long size() {
                return x.size();
            }

            @Override
            public long getRunningLength() {
                return x.getRunningLength();
            }

            @Override
            public void discardFirstWords(long y) {
                x.discardFirstWords(y);
            }

            @Override
            public void discardRunningWords() {
                x.discardRunningWords();
            }

            @Override
            public IteratingRLW clone() throws CloneNotSupportedException {
                throw new CloneNotSupportedException();
            }

            @Override
            public void discardLiteralWords(long y) {
                x.discardLiteralWords(y);
            }
        };
    }

    public static IteratingRLW bufferedand(IteratingRLW ... al) {
        return IteratorAggregation.bufferedand(65536, al);
    }

    public static IteratingRLW bufferedand(int bufSize, IteratingRLW ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW> basell = new LinkedList<IteratingRLW>();
        Collections.addAll(basell, al);
        return new BufferedIterator(new BufferedAndIterator(basell, bufSize));
    }

    public static IteratingRLW bufferedor(IteratingRLW ... al) {
        return IteratorAggregation.bufferedor(65536, al);
    }

    public static IteratingRLW bufferedor(int bufSize, IteratingRLW ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW> basell = new LinkedList<IteratingRLW>();
        Collections.addAll(basell, al);
        return new BufferedIterator(new BufferedORIterator(basell, bufSize));
    }

    public static IteratingRLW bufferedxor(IteratingRLW ... al) {
        return IteratorAggregation.bufferedxor(65536, al);
    }

    public static IteratingRLW bufferedxor(int bufSize, IteratingRLW ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW> basell = new LinkedList<IteratingRLW>();
        Collections.addAll(basell, al);
        return new BufferedIterator(new BufferedXORIterator(basell, bufSize));
    }

    protected static void dischargeAsEmpty(BitmapStorage container, IteratingRLW i) {
        while (i.size() > 0L) {
            container.addStreamOfEmptyWords(false, i.size());
            i.next();
        }
    }

    protected static long discharge(BitmapStorage container, IteratingRLW i, long max) {
        long counter;
        long l;
        for (counter = 0L; i.size() > 0L && counter < max; counter += l) {
            long l1 = i.getRunningLength();
            if (l1 > 0L) {
                if (l1 + counter > max) {
                    l1 = max - counter;
                }
                container.addStreamOfEmptyWords(i.getRunningBit(), l1);
                counter += l1;
            }
            if ((l = (long)i.getNumberOfLiteralWords()) + counter > max) {
                l = max - counter;
            }
            int k = 0;
            while ((long)k < l) {
                container.addWord(i.getLiteralWordAt(k));
                ++k;
            }
            i.discardFirstWords(l + l1);
        }
        return counter;
    }

    protected static long dischargeNegated(BitmapStorage container, IteratingRLW i, long max) {
        long counter;
        long l;
        for (counter = 0L; i.size() > 0L && counter < max; counter += l) {
            long l1 = i.getRunningLength();
            if (l1 > 0L) {
                if (l1 + counter > max) {
                    l1 = max - counter;
                }
                container.addStreamOfEmptyWords(!i.getRunningBit(), l1);
                counter += l1;
            }
            if ((l = (long)i.getNumberOfLiteralWords()) + counter > max) {
                l = max - counter;
            }
            int k = 0;
            while ((long)k < l) {
                container.addWord(i.getLiteralWordAt(k) ^ 0xFFFFFFFFFFFFFFFFL);
                ++k;
            }
            i.discardFirstWords(l + l1);
        }
        return counter;
    }

    static void andToContainer(BitmapStorage container, int desiredrlwcount, IteratingRLW rlwi, IteratingRLW rlwj) {
        while (rlwi.size() > 0L && rlwj.size() > 0L && desiredrlwcount-- > 0) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingRLW predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW iteratingRLW = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                long index = IteratorAggregation.discharge(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            desiredrlwcount -= nbre_literal;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    static void andToContainer(BitmapStorage container, IteratingRLW rlwi, IteratingRLW rlwj) {
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingRLW predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW iteratingRLW = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                long index = IteratorAggregation.discharge(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    public static void xorToContainer(BitmapStorage container, int desiredrlwcount, IteratingRLW rlwi, IteratingRLW rlwj) {
        while (rlwi.size() > 0L && rlwj.size() > 0L && desiredrlwcount-- > 0) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                long index;
                IteratingRLW predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW iteratingRLW = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    index = IteratorAggregation.discharge(container, prey, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = IteratorAggregation.dischargeNegated(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            desiredrlwcount -= nbre_literal;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    protected static int inplaceor(long[] bitmap, IteratingRLW i) {
        long s;
        int pos = 0;
        while ((s = i.size()) > 0L) {
            int k;
            if ((long)pos + s < (long)bitmap.length) {
                int L = (int)i.getRunningLength();
                if (i.getRunningBit()) {
                    Arrays.fill(bitmap, pos, pos + L, -1L);
                }
                pos += L;
                int LR = i.getNumberOfLiteralWords();
                for (k = 0; k < LR; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] | i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howmany = bitmap.length - pos;
            int l = (int)i.getRunningLength();
            if (pos + l > bitmap.length) {
                if (i.getRunningBit()) {
                    Arrays.fill(bitmap, pos, bitmap.length, -1L);
                }
                i.discardFirstWords(howmany);
                return bitmap.length;
            }
            if (i.getRunningBit()) {
                Arrays.fill(bitmap, pos, pos + l, -1L);
            }
            pos += l;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] | i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howmany);
            return pos;
        }
        return pos;
    }

    protected static int inplacexor(long[] bitmap, IteratingRLW i) {
        long s;
        int pos = 0;
        while ((s = i.size()) > 0L) {
            int k;
            if ((long)pos + s < (long)bitmap.length) {
                int L = (int)i.getRunningLength();
                if (i.getRunningBit()) {
                    for (int k2 = pos; k2 < pos + L; ++k2) {
                        bitmap[k2] = bitmap[k2] ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                }
                pos += L;
                int LR = i.getNumberOfLiteralWords();
                for (k = 0; k < LR; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] ^ i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howMany = bitmap.length - pos;
            int l = (int)i.getRunningLength();
            if (pos + l > bitmap.length) {
                if (i.getRunningBit()) {
                    for (k = pos; k < bitmap.length; ++k) {
                        bitmap[k] = bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                }
                i.discardFirstWords(howMany);
                return bitmap.length;
            }
            if (i.getRunningBit()) {
                for (k = pos; k < pos + l; ++k) {
                    bitmap[k] = bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            pos += l;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] ^ i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howMany);
            return pos;
        }
        return pos;
    }

    protected static int inplaceand(long[] bitmap, IteratingRLW i) {
        long s;
        int pos = 0;
        while ((s = i.size()) > 0L) {
            int k;
            if ((long)pos + s < (long)bitmap.length) {
                int L = (int)i.getRunningLength();
                if (!i.getRunningBit()) {
                    for (int k2 = pos; k2 < pos + L; ++k2) {
                        bitmap[k2] = 0L;
                    }
                }
                pos += L;
                int LR = i.getNumberOfLiteralWords();
                for (k = 0; k < LR; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] & i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howmany = bitmap.length - pos;
            int l = (int)i.getRunningLength();
            if (pos + l > bitmap.length) {
                if (!i.getRunningBit()) {
                    for (k = pos; k < bitmap.length; ++k) {
                        bitmap[k] = 0L;
                    }
                }
                i.discardFirstWords(howmany);
                return bitmap.length;
            }
            if (!i.getRunningBit()) {
                for (k = pos; k < pos + l; ++k) {
                    bitmap[k] = 0L;
                }
            }
            pos += l;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] & i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howmany);
            return pos;
        }
        return pos;
    }
}

