/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class PyDocStyleParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        boolean fileLine = true;
        List<String> lines = ViolationParserUtils.getLines(string);
        String filename = null;
        Integer line = null;
        for (String inputLine : lines) {
            try {
                List<String> parts;
                if (fileLine) {
                    parts = ViolationParserUtils.getParts(inputLine, "([^:]*)", "(\\d+)");
                    filename = parts.get(0);
                    if (!filename.endsWith(".py")) continue;
                    line = Integer.parseInt(parts.get(1));
                } else {
                    parts = ViolationParserUtils.getParts(inputLine, "([^:]*)", ":(.*)");
                    if (parts.size() != 2) continue;
                    String rule = parts.get(0);
                    String message = parts.get(1);
                    violations.add(Violation.violationBuilder().setParser(Parser.PYDOCSTYLE).setStartLine(line).setFile(filename).setRule(rule).setSeverity(SEVERITY.ERROR).setMessage(message).build());
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                continue;
            }
            fileLine = !fileLine;
        }
        return violations;
    }
}

