/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class ProtoLintParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(reportContent, "\\[([^:]+):(\\d+):(\\d+)\\] (.+)");
        for (List<String> parts : partsPerLine) {
            String filename = parts.get(1);
            Integer line = Integer.parseInt(parts.get(2));
            Integer column = Integer.parseInt(parts.get(3));
            String message = parts.get(4);
            violations.add(Violation.violationBuilder().setParser(Parser.PROTOLINT).setStartLine(line).setColumn(column).setFile(filename).setSeverity(SEVERITY.ERROR).setMessage(message).build());
        }
        return violations;
    }
}

