/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class PCLintParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<String> lines = ViolationParserUtils.getLines(string);
        Pattern misraPattern = Pattern.compile("\\[MISRA.*\\]");
        for (String line : lines) {
            Matcher misraMatcher = misraPattern.matcher(line);
            if (misraMatcher.find()) {
                this.parseMisraViolation(line, violations);
                continue;
            }
            this.parseGeneralViolation(line, violations);
        }
        return violations;
    }

    private void parseMisraViolation(String line, Set<Violation> violations) {
        List<String> parts = ViolationParserUtils.getParts(line, "^([^\\(]+)\\(", "^([\\d]+)\\): ", "^(?:Error|Warning|Info|Note) [\\d]+: ([^\\[]*)", "^\\[(.*),", "(mandatory|required|advisory)\\]", "^(.*)$");
        if (parts.isEmpty()) {
            return;
        }
        String filename = parts.get(0);
        Integer lineNumber = Integer.parseInt(parts.get(1));
        String severityString = parts.get(4);
        SEVERITY severity = this.toMisraSeverity(severityString);
        String rule = parts.get(3) + ", " + severityString;
        String message = parts.get(2) + " " + parts.get(5);
        violations.add(Violation.violationBuilder().setParser(Parser.PCLINT).setStartLine(lineNumber).setFile(filename).setRule(rule).setSeverity(severity).setMessage(message).build());
    }

    private void parseGeneralViolation(String line, Set<Violation> violations) {
        List<String> parts = ViolationParserUtils.getParts(line, "^([^\\(]+)\\(", "^([\\d]+)\\): ", "^(Error|Warning|Info|Note) ", "^([\\d]+): ", "^(.*)$");
        if (parts.isEmpty()) {
            return;
        }
        String filename = parts.get(0);
        Integer lineNumber = Integer.parseInt(parts.get(1));
        SEVERITY severity = this.toSeverity(parts.get(2));
        String rule = parts.get(3);
        String message = parts.get(4);
        violations.add(Violation.violationBuilder().setParser(Parser.PCLINT).setStartLine(lineNumber).setFile(filename).setRule(rule).setSeverity(severity).setMessage(message).build());
    }

    private SEVERITY toSeverity(String severity) {
        if (severity.equals("Error")) {
            return SEVERITY.ERROR;
        }
        if (severity.equals("Warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    private SEVERITY toMisraSeverity(String severity) {
        if (severity.equals("mandatory")) {
            return SEVERITY.ERROR;
        }
        if (severity.equals("required")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

