/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces.transformers.textformat;

import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import shadow.de.vandermeer.skb.interfaces.transformers.IsTransformer;

public interface String_To_LeftPadded
extends IsTransformer<String, StrBuilder> {
    public static final int DEFAULT_LENGTH = 80;
    public static final char DEFAULT_PADDING_CHARACTER = ' ';
    public static final char DEFAULT_INNER_WHITESPACE_CHARACTER = ' ';

    default public int getLength() {
        return 80;
    }

    default public Character getInnerWsChar() {
        return Character.valueOf(' ');
    }

    default public Character getPaddingChar() {
        return Character.valueOf(' ');
    }

    default public StrBuilder getBuilderForAppend() {
        return null;
    }

    @Override
    default public StrBuilder transform(String s) {
        IsTransformer.super.transform(s);
        StrBuilder ret = this.getBuilderForAppend() == null ? new StrBuilder(this.getLength()) : this.getBuilderForAppend();
        String left = s == null ? "" : s;
        left = left.replace(' ', this.getInnerWsChar().charValue());
        ret.appendFixedWidthPadRight(left, this.getLength(), this.getPaddingChar().charValue());
        return ret;
    }

    public static String_To_LeftPadded create(final int length, final Character paddingChar, final Character innerWsChar, final StrBuilder builder) {
        Validate.validState(length > 0, "cannot work with lenght of less than 1", new Object[0]);
        return new String_To_LeftPadded(){

            @Override
            public int getLength() {
                return length;
            }

            @Override
            public Character getInnerWsChar() {
                return innerWsChar == null ? String_To_LeftPadded.super.getInnerWsChar() : innerWsChar;
            }

            @Override
            public Character getPaddingChar() {
                return paddingChar == null ? String_To_LeftPadded.super.getPaddingChar() : paddingChar;
            }

            @Override
            public StrBuilder getBuilderForAppend() {
                return builder;
            }
        };
    }

    public static StrBuilder convert(String s, int length) {
        return String_To_LeftPadded.create(length, null, null, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, StrBuilder builder) {
        return String_To_LeftPadded.create(length, null, null, builder).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character paddingChar) {
        return String_To_LeftPadded.create(length, paddingChar, null, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character paddingChar, Character innerWsChar) {
        return String_To_LeftPadded.create(length, paddingChar, innerWsChar, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character paddingChar, StrBuilder builder) {
        return String_To_LeftPadded.create(length, paddingChar, null, builder).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character paddingChar, Character innerWsChar, StrBuilder builder) {
        return String_To_LeftPadded.create(length, paddingChar, innerWsChar, builder).transform(s);
    }
}

