/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces.messagesets;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import shadow.de.vandermeer.skb.interfaces.messagesets.IsMessageSet;
import shadow.de.vandermeer.skb.interfaces.render.DoesRender;

public interface IsWarningSet<M>
extends IsMessageSet {
    @Override
    default public boolean isErrorSet() {
        return true;
    }

    @Override
    default public boolean isWarningSet() {
        return true;
    }

    default public void clearWarningMessages() {
        this.getWarningMessages().clear();
    }

    public Set<M> getWarningMessages();

    default public void addWarning(M warning) {
        this.getWarningMessages().add(warning);
    }

    default public void addAllWarnings(Collection<M> warnings) {
        this.getWarningMessages().addAll(warnings);
    }

    default public boolean hasWarnings() {
        return this.getWarningMessages().size() != 0;
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (M m : this.getWarningMessages()) {
            if (m instanceof DoesRender) {
                ret.append(((DoesRender)m).render());
            } else {
                ret.append(m);
            }
            ret.appendNewLine();
        }
        return ret.toString();
    }

    public static <M> IsWarningSet<M> create() {
        return new IsWarningSet<M>(){
            final Set<M> warningSet = new LinkedHashSet();

            @Override
            public Set<M> getWarningMessages() {
                return this.warningSet;
            }
        };
    }
}

