/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.nls;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.TranslationBundleLoadingException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.TranslationStringMissingException;

public abstract class TranslationBundle {
    private Locale effectiveLocale;
    private ResourceBundle resourceBundle;

    public Locale effectiveLocale() {
        return this.effectiveLocale;
    }

    public ResourceBundle resourceBundle() {
        return this.resourceBundle;
    }

    void load(Locale locale) throws TranslationBundleLoadingException {
        Class<?> bundleClass = this.getClass();
        try {
            this.resourceBundle = ResourceBundle.getBundle(bundleClass.getName(), locale, bundleClass.getClassLoader());
        }
        catch (MissingResourceException e) {
            throw new TranslationBundleLoadingException(bundleClass, locale, e);
        }
        this.effectiveLocale = this.resourceBundle.getLocale();
        for (Field field : bundleClass.getFields()) {
            if (!field.getType().equals(String.class)) continue;
            try {
                String translatedText = this.resourceBundle.getString(field.getName());
                field.set(this, translatedText);
            }
            catch (MissingResourceException e) {
                throw new TranslationStringMissingException(bundleClass, locale, field.getName(), (Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new Error(e);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
        }
    }
}

