/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.LargeObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.MissingObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.PackFile;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.PackInputStream;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.WindowCursor;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectLoader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectStream;

class LargePackedWholeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final long objectOffset;
    private final int headerLength;
    private final PackFile pack;
    private final FileObjectDatabase db;

    LargePackedWholeObject(int type, long size, long objectOffset, int headerLength, PackFile pack, FileObjectDatabase db) {
        this.type = type;
        this.size = size;
        this.objectOffset = objectOffset;
        this.headerLength = headerLength;
        this.pack = pack;
        this.db = db;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isLarge() {
        return true;
    }

    @Override
    public byte[] getCachedBytes() throws LargeObjectException {
        try {
            throw new LargeObjectException(this.getObjectId());
        }
        catch (IOException cannotObtainId) {
            LargeObjectException err = new LargeObjectException();
            err.initCause(cannotObtainId);
            throw err;
        }
    }

    @Override
    public ObjectStream openStream() throws MissingObjectException, IOException {
        InputStream in;
        WindowCursor wc = new WindowCursor(this.db);
        try {
            in = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, wc);
        }
        catch (IOException packGone) {
            return wc.open(this.getObjectId(), this.type).openStream();
        }
        in = new BufferedInputStream(new InflaterInputStream(in, wc.inflater(), 8192), 8192);
        return new ObjectStream.Filter(this.type, this.size, in);
    }

    private ObjectId getObjectId() throws IOException {
        return this.pack.findObjectForOffset(this.objectOffset);
    }
}

