/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch;

import java.util.Collection;
import java.util.Map;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.annotations.Nullable;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch.KetchReplica;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch.LeaderSnapshot;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Ref;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.ReceiveCommand;

public class ReplicaPushRequest {
    private final KetchReplica replica;
    private final Collection<ReceiveCommand> commands;
    private Map<String, Ref> refs;
    private Throwable exception;
    private boolean notified;

    public ReplicaPushRequest(KetchReplica replica, Collection<ReceiveCommand> commands) {
        this.replica = replica;
        this.commands = commands;
    }

    public Collection<ReceiveCommand> getCommands() {
        return this.commands;
    }

    @Nullable
    public Map<String, Ref> getRefs() {
        return this.refs;
    }

    public void setRefs(Map<String, Ref> refs) {
        this.refs = refs;
    }

    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    public void setException(@Nullable Repository repo, Throwable err) {
        if (KetchReplica.log.isErrorEnabled()) {
            KetchReplica.log.error(this.describe("failed"), err);
        }
        if (!this.notified) {
            this.notified = true;
            this.exception = err;
            this.replica.afterPush(repo, this);
        }
    }

    public void done(Repository repo) {
        if (KetchReplica.log.isDebugEnabled()) {
            KetchReplica.log.debug(this.describe("se.bjurr.violations.violationsgitlib.completed"));
        }
        if (!this.notified) {
            this.notified = true;
            this.replica.afterPush(repo, this);
        }
    }

    private String describe(String heading) {
        StringBuilder b = new StringBuilder();
        b.append("push to ");
        b.append(this.replica.describeForLog());
        b.append(' ').append(heading).append(":\n");
        for (ReceiveCommand cmd : this.commands) {
            b.append(String.format("  %-12s %-12s %s %s", new Object[]{LeaderSnapshot.str(cmd.getOldId()), LeaderSnapshot.str(cmd.getNewId()), cmd.getRefName(), cmd.getResult()}));
            if (cmd.getMessage() != null) {
                b.append(' ').append(cmd.getMessage());
            }
            b.append('\n');
        }
        return b.toString();
    }
}

