/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch.KetchConstants;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch.KetchLeader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch.LogIndex;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch.Round;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch.TimeIsUncertainException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.CommitBuilder;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectInserter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.TreeFormatter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.time.ProposedTimestamp;
import se.bjurr.violations.violationsgitlib.org.slf4j.Logger;
import se.bjurr.violations.violationsgitlib.org.slf4j.LoggerFactory;

class ElectionRound
extends Round {
    private static final Logger log = LoggerFactory.getLogger(ElectionRound.class);
    private long term;

    ElectionRound(KetchLeader leader, LogIndex head) {
        super(leader, head);
    }

    @Override
    void start() throws IOException {
        ObjectId id;
        try (Repository git = this.leader.openRepository();
             ProposedTimestamp ts = this.getSystem().getClock().propose();
             ObjectInserter inserter = git.newObjectInserter();){
            id = this.bumpTerm(git, ts, inserter);
            inserter.flush();
            this.blockUntil(ts);
        }
        this.runAsync(id);
    }

    @Override
    void success() {
    }

    long getTerm() {
        return this.term;
    }

    private ObjectId bumpTerm(Repository git, ProposedTimestamp ts, ObjectInserter inserter) throws IOException {
        CommitBuilder b = new CommitBuilder();
        if (!ObjectId.zeroId().equals(this.acceptedOldIndex)) {
            try (RevWalk rw = new RevWalk(git);){
                RevCommit c = rw.parseCommit(this.acceptedOldIndex);
                if (this.getSystem().requireMonotonicLeaderElections() && ts.read(TimeUnit.SECONDS) < (long)c.getCommitTime()) {
                    throw new TimeIsUncertainException();
                }
                b.setTreeId(c.getTree());
                b.setParentId(this.acceptedOldIndex);
                this.term = ElectionRound.parseTerm(c.getFooterLines(KetchConstants.TERM)) + 1L;
            }
        } else {
            this.term = 1L;
            b.setTreeId(inserter.insert(new TreeFormatter()));
        }
        StringBuilder msg = new StringBuilder();
        msg.append(KetchConstants.TERM.getName()).append(": ").append(this.term);
        String tag = this.leader.getSystem().newLeaderTag();
        if (tag != null && !tag.isEmpty()) {
            msg.append(' ').append(tag);
        }
        b.setAuthor(this.leader.getSystem().newCommitter(ts));
        b.setCommitter(b.getAuthor());
        b.setMessage(msg.toString());
        if (log.isDebugEnabled()) {
            log.debug("Trying to elect myself " + b.getMessage());
        }
        return inserter.insert(b);
    }

    private static long parseTerm(List<String> footer) {
        if (footer.isEmpty()) {
            return 0L;
        }
        String s = footer.get(0);
        int p = s.indexOf(32);
        if (p > 0) {
            s = s.substring(0, p);
        }
        return Long.parseLong(s, 10);
    }

    private void blockUntil(ProposedTimestamp ts) throws IOException {
        try {
            ts.blockUntil(this.getSystem().getMaxWaitForMonotonicClock());
        }
        catch (InterruptedException | TimeoutException e) {
            throw new TimeIsUncertainException(e);
        }
    }
}

