/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.GitCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.StoredConfig;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.RemoteConfig;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.URIish;

public class RemoteSetUrlCommand
extends GitCommand<RemoteConfig> {
    private String name;
    private URIish uri;
    private boolean push;

    protected RemoteSetUrlCommand(Repository repo) {
        super(repo);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUri(URIish uri) {
        this.uri = uri;
    }

    public void setPush(boolean push) {
        this.push = push;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.name);
            if (this.push) {
                List<URIish> uris = remote.getPushURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.pushurl has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removePushURI(uris.get(0));
                }
                remote.addPushURI(this.uri);
            } else {
                List<URIish> uris = remote.getURIs();
                if (uris.size() > 1) {
                    throw new JGitInternalException("remote.newtest.url has multiple values");
                }
                if (uris.size() == 1) {
                    remote.removeURI(uris.get(0));
                }
                remote.addURI(this.uri);
            }
            remote.update(config);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

