/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.GitCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Ref;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;

public class ListTagCommand
extends GitCommand<List<Ref>> {
    protected ListTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<Ref> tags = new ArrayList<Ref>();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Map<String, Ref> refList = this.repo.getRefDatabase().getRefs("refs/tags/");
            for (Ref ref : refList.values()) {
                tags.add(ref);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        Collections.sort(tags, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.setCallable(false);
        return tags;
    }
}

