/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpConnection;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpException;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpHost;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpInetConnection;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpRequest;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpRequestInterceptor;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpVersion;
import se.bjurr.violations.violationsgitlib.org.apache.http.ProtocolException;
import se.bjurr.violations.violationsgitlib.org.apache.http.ProtocolVersion;
import se.bjurr.violations.violationsgitlib.org.apache.http.annotation.Immutable;
import se.bjurr.violations.violationsgitlib.org.apache.http.protocol.HttpContext;
import se.bjurr.violations.violationsgitlib.org.apache.http.protocol.HttpCoreContext;
import se.bjurr.violations.violationsgitlib.org.apache.http.util.Args;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

