/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import se.bjurr.violations.violationsgitlib.org.apache.commons.logging.Log;
import se.bjurr.violations.violationsgitlib.org.apache.commons.logging.LogFactory;
import se.bjurr.violations.violationsgitlib.org.apache.http.Header;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpException;
import se.bjurr.violations.violationsgitlib.org.apache.http.annotation.Immutable;
import se.bjurr.violations.violationsgitlib.org.apache.http.client.ServiceUnavailableRetryStrategy;
import se.bjurr.violations.violationsgitlib.org.apache.http.client.methods.CloseableHttpResponse;
import se.bjurr.violations.violationsgitlib.org.apache.http.client.methods.HttpExecutionAware;
import se.bjurr.violations.violationsgitlib.org.apache.http.client.methods.HttpRequestWrapper;
import se.bjurr.violations.violationsgitlib.org.apache.http.client.protocol.HttpClientContext;
import se.bjurr.violations.violationsgitlib.org.apache.http.conn.routing.HttpRoute;
import se.bjurr.violations.violationsgitlib.org.apache.http.impl.execchain.ClientExecChain;
import se.bjurr.violations.violationsgitlib.org.apache.http.util.Args;

@Immutable
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

