/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.apache.http.impl.cookie;

import se.bjurr.violations.violationsgitlib.org.apache.http.annotation.Immutable;
import se.bjurr.violations.violationsgitlib.org.apache.http.cookie.Cookie;
import se.bjurr.violations.violationsgitlib.org.apache.http.cookie.CookieAttributeHandler;
import se.bjurr.violations.violationsgitlib.org.apache.http.cookie.CookieOrigin;
import se.bjurr.violations.violationsgitlib.org.apache.http.cookie.CookieRestrictionViolationException;
import se.bjurr.violations.violationsgitlib.org.apache.http.cookie.MalformedCookieException;
import se.bjurr.violations.violationsgitlib.org.apache.http.cookie.SetCookie;
import se.bjurr.violations.violationsgitlib.org.apache.http.util.Args;

@Immutable
public class BasicDomainHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (value.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        cookie.setDomain(value);
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            throw new CookieRestrictionViolationException("Cookie domain may not be null");
        }
        if (host.contains(".")) {
            if (!host.endsWith(domain)) {
                if (domain.startsWith(".")) {
                    domain = domain.substring(1, domain.length());
                }
                if (!host.equals(domain)) {
                    throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain + "\". Domain of origin: \"" + host + "\"");
                }
            }
        } else if (!host.equals(domain)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain + "\". Domain of origin: \"" + host + "\"");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        if (host.equals(domain)) {
            return true;
        }
        if (!domain.startsWith(".")) {
            domain = '.' + domain;
        }
        return host.endsWith(domain) || host.equals(domain.substring(1));
    }
}

