/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.apache.http.impl.auth;

import se.bjurr.violations.violationsgitlib.org.apache.http.Header;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpRequest;
import se.bjurr.violations.violationsgitlib.org.apache.http.annotation.NotThreadSafe;
import se.bjurr.violations.violationsgitlib.org.apache.http.auth.AuthenticationException;
import se.bjurr.violations.violationsgitlib.org.apache.http.auth.Credentials;
import se.bjurr.violations.violationsgitlib.org.apache.http.impl.auth.GGSSchemeBase;
import se.bjurr.violations.violationsgitlib.org.apache.http.protocol.HttpContext;
import se.bjurr.violations.violationsgitlib.org.apache.http.util.Args;
import se.bjurr.violations.violationsgitlib.org.ietf.jgss.GSSException;
import se.bjurr.violations.violationsgitlib.org.ietf.jgss.Oid;

@NotThreadSafe
public class KerberosScheme
extends GGSSchemeBase {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";

    public KerberosScheme(boolean stripPort) {
        super(stripPort);
    }

    public KerberosScheme() {
        super(false);
    }

    public String getSchemeName() {
        return "Kerberos";
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return super.authenticate(credentials, request, context);
    }

    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return this.generateGSSToken(input, new Oid(KERBEROS_OID), authServer);
    }

    public String getParameter(String name) {
        Args.notNull(name, "Parameter name");
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }
}

