/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.apache.http.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpEntity;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpEntityEnclosingRequest;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpException;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpRequest;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpResponse;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpServerConnection;
import se.bjurr.violations.violationsgitlib.org.apache.http.annotation.NotThreadSafe;
import se.bjurr.violations.violationsgitlib.org.apache.http.config.MessageConstraints;
import se.bjurr.violations.violationsgitlib.org.apache.http.entity.ContentLengthStrategy;
import se.bjurr.violations.violationsgitlib.org.apache.http.impl.BHttpConnectionBase;
import se.bjurr.violations.violationsgitlib.org.apache.http.impl.entity.DisallowIdentityContentLengthStrategy;
import se.bjurr.violations.violationsgitlib.org.apache.http.impl.io.DefaultHttpRequestParserFactory;
import se.bjurr.violations.violationsgitlib.org.apache.http.impl.io.DefaultHttpResponseWriterFactory;
import se.bjurr.violations.violationsgitlib.org.apache.http.io.HttpMessageParser;
import se.bjurr.violations.violationsgitlib.org.apache.http.io.HttpMessageParserFactory;
import se.bjurr.violations.violationsgitlib.org.apache.http.io.HttpMessageWriter;
import se.bjurr.violations.violationsgitlib.org.apache.http.io.HttpMessageWriterFactory;
import se.bjurr.violations.violationsgitlib.org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultBHttpServerConnection
extends BHttpConnectionBase
implements HttpServerConnection {
    private final HttpMessageParser<HttpRequest> requestParser;
    private final HttpMessageWriter<HttpResponse> responseWriter;

    public DefaultBHttpServerConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<HttpRequest> requestParserFactory, HttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
        super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy != null ? incomingContentStrategy : DisallowIdentityContentLengthStrategy.INSTANCE, outgoingContentStrategy);
        this.requestParser = (requestParserFactory != null ? requestParserFactory : DefaultHttpRequestParserFactory.INSTANCE).create(this.getSessionInputBuffer(), constraints);
        this.responseWriter = (responseWriterFactory != null ? responseWriterFactory : DefaultHttpResponseWriterFactory.INSTANCE).create(this.getSessionOutputBuffer());
    }

    public DefaultBHttpServerConnection(int buffersize, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints) {
        this(buffersize, buffersize, chardecoder, charencoder, constraints, null, null, null, null);
    }

    public DefaultBHttpServerConnection(int buffersize) {
        this(buffersize, buffersize, null, null, null, null, null, null, null);
    }

    protected void onRequestReceived(HttpRequest request) {
    }

    protected void onResponseSubmitted(HttpResponse response) {
    }

    @Override
    public void bind(Socket socket) throws IOException {
        super.bind(socket);
    }

    @Override
    public HttpRequest receiveRequestHeader() throws HttpException, IOException {
        this.ensureOpen();
        HttpRequest request = this.requestParser.parse();
        this.onRequestReceived(request);
        this.incrementRequestCount();
        return request;
    }

    @Override
    public void receiveRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        this.ensureOpen();
        HttpEntity entity = this.prepareInput(request);
        request.setEntity(entity);
    }

    @Override
    public void sendResponseHeader(HttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        this.ensureOpen();
        this.responseWriter.write(response);
        this.onResponseSubmitted(response);
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.incrementResponseCount();
        }
    }

    @Override
    public void sendResponseEntity(HttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        this.ensureOpen();
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        OutputStream outstream = this.prepareOutput(response);
        entity.writeTo(outstream);
        outstream.close();
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.doFlush();
    }
}

