/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class PiTestParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String content, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String status = null;
            String detected = null;
            String mutatedClass = null;
            String sourceFile = null;
            String mutatedMethod = null;
            String methodDescription = null;
            String mutator = null;
            int index = 0;
            int startLine = 0;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType == 1) {
                    if (xmlr.getLocalName().equalsIgnoreCase("mutation")) {
                        status = null;
                        detected = null;
                        mutatedClass = null;
                        sourceFile = null;
                        mutatedMethod = null;
                        methodDescription = null;
                        mutator = null;
                        index = 0;
                        startLine = 0;
                        status = ViolationParserUtils.getAttribute(xmlr, "status");
                        detected = ViolationParserUtils.getAttribute(xmlr, "detected");
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("mutatedClass")) {
                        mutatedClass = xmlr.getElementText();
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("sourceFile")) {
                        sourceFile = xmlr.getElementText();
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("mutatedMethod")) {
                        mutatedMethod = xmlr.getElementText();
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("methodDescription")) {
                        methodDescription = xmlr.getElementText();
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("mutator")) {
                        mutator = xmlr.getElementText();
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("lineNumber")) {
                        startLine = Integer.parseInt(xmlr.getElementText());
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("index")) {
                        index = Integer.parseInt(xmlr.getElementText());
                    }
                }
                if (eventType != 2 || !xmlr.getLocalName().equalsIgnoreCase("mutation")) continue;
                HashMap<String, String> specifics = new HashMap<String, String>();
                specifics.put("detected", detected);
                specifics.put("mutatedMethod", mutatedMethod);
                specifics.put("mutatedClass", mutatedClass);
                specifics.put("status", status);
                specifics.put("methodDescription", methodDescription);
                String filename = this.toFilename(mutatedClass, sourceFile);
                String message = status + ", " + mutator + ", " + methodDescription;
                Violation violation = Violation.violationBuilder().setRule(mutator).setSource(sourceFile).setParser(Parser.PITEST).setStartLine(startLine).setColumn(index).setFile(filename).setSeverity(SEVERITY.WARN).setMessage(message).setSpecifics(specifics).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    private String toFilename(String mutatedClass, String sourceFile) {
        return mutatedClass.substring(0, mutatedClass.lastIndexOf(".")).replaceAll("\\.", "/") + "/" + sourceFile;
    }
}

