/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class PMDParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String content, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String filename = null;
            Integer beginLine = null;
            Integer endLine = null;
            Optional<Integer> beginColumn = null;
            Optional<Integer> endColumn = null;
            String rule = null;
            Optional<String> ruleSetOpt = null;
            SEVERITY severity = null;
            String message = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("file")) {
                    filename = ViolationParserUtils.getAttribute(xmlr, "name");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("violation")) continue;
                beginLine = ViolationParserUtils.getIntegerAttribute(xmlr, "beginline");
                endLine = ViolationParserUtils.getIntegerAttribute(xmlr, "endline");
                beginColumn = ViolationParserUtils.findIntegerAttribute(xmlr, "begincolumn");
                endColumn = ViolationParserUtils.findIntegerAttribute(xmlr, "endcolumn");
                rule = ViolationParserUtils.getAttribute(xmlr, "rule").trim();
                ruleSetOpt = ViolationParserUtils.findAttribute(xmlr, "ruleset");
                Optional<String> externalInfoUrlOpt = ViolationParserUtils.findAttribute(xmlr, "externalInfoUrl");
                Integer priority = ViolationParserUtils.getIntegerAttribute(xmlr, "priority");
                severity = this.toSeverity(priority);
                String violationContent = xmlr.getElementText();
                message = violationContent + "\n\n" + ruleSetOpt.orElse("") + " " + externalInfoUrlOpt.orElse("");
                Violation violation = Violation.violationBuilder().setParser(Parser.PMD).setStartLine(beginLine).setEndLine(endLine).setColumn(beginColumn.orElse(null)).setEndColumn(endColumn.orElse(null)).setFile(filename).setSeverity(severity).setRule(rule).setCategory(ruleSetOpt.orElse(null)).setMessage(message.trim()).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(Integer priority) {
        if (priority < 3) {
            return SEVERITY.ERROR;
        }
        if (priority < 5) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

