/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.bjurr.violations.lib.FilteringViolationsLogger;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.codeclimate.CodeClimate;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateTransformer;
import se.bjurr.violations.lib.model.generated.sarif.SarifSchema;
import se.bjurr.violations.lib.model.sarif.SarifTransformer;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.reports.ReportsFinder;
import se.bjurr.violations.lib.reports.ViolationsFinder;
import se.bjurr.violations.lib.util.Utils;

public class ViolationsApi {
    private final Logger LOGGER = Logger.getLogger(ViolationsApi.class.getSimpleName());
    private String pattern;
    private ViolationsParser violationsParser;
    private File startFile;
    private String reporter;
    private List<String> ignorePaths = new ArrayList<String>();
    private ViolationsLogger violationsLogger = FilteringViolationsLogger.filterLevel(new ViolationsLogger(){

        @Override
        public void log(Level level, String string, Throwable t) {
            ViolationsApi.this.LOGGER.log(level, string, t);
        }

        @Override
        public void log(Level level, String string) {
            ViolationsApi.this.LOGGER.log(level, string);
        }
    });

    public static ViolationsApi violationsApi() {
        return new ViolationsApi();
    }

    private ViolationsApi() {
    }

    public ViolationsApi findAll(Parser parser) {
        this.violationsParser = Utils.checkNotNull(parser, "parser").getViolationsParser();
        return this;
    }

    public ViolationsApi withViolationsParser(ViolationsParser violationsParser) {
        this.violationsParser = Utils.checkNotNull(violationsParser, "violationsParser");
        return this;
    }

    public ViolationsApi withViolationsLogger(ViolationsLogger violationsLogger) {
        this.violationsLogger = Utils.checkNotNull(violationsLogger, "violationsLogger");
        return this;
    }

    public ViolationsApi withReporter(String reporter) {
        this.reporter = Utils.checkNotNull(reporter, "reporter");
        return this;
    }

    public ViolationsApi inFolder(String folder) {
        this.startFile = new File(Utils.checkNotNull(folder, "folder"));
        if (!this.startFile.exists()) {
            throw new RuntimeException(folder + " not found");
        }
        return this;
    }

    public ViolationsApi withIgnorePaths(List<String> ignorePaths) {
        this.ignorePaths = Utils.checkNotNull(ignorePaths, "ignorePaths");
        return this;
    }

    public Set<Violation> violations() {
        boolean reporterWasSupplied;
        List<File> includedFiles = ReportsFinder.findAllReports(this.violationsLogger, this.startFile, this.pattern, this.ignorePaths);
        this.violationsLogger.log(Level.INFO, "Found " + includedFiles.size() + " reports in " + this.startFile + " with pattern " + this.pattern);
        for (File f : includedFiles) {
            this.violationsLogger.log(Level.INFO, "    - " + f.getAbsolutePath());
        }
        Set<Violation> foundViolations = new ViolationsFinder(this.violationsParser).findViolations(this.violationsLogger, includedFiles);
        boolean bl = reporterWasSupplied = this.reporter != null && !this.reporter.trim().isEmpty();
        if (reporterWasSupplied) {
            Utils.setReporter(foundViolations, this.reporter);
        }
        if (this.LOGGER.isLoggable(Level.FINE)) {
            this.violationsLogger.log(Level.FINE, "Found " + foundViolations.size() + " violations:");
            for (Violation v : foundViolations) {
                this.violationsLogger.log(Level.FINE, v.getReporter() + " " + (Object)((Object)v.getSeverity()) + " (" + v.getRule() + ") " + v.getFile() + " " + v.getStartLine() + " -> " + v.getEndLine());
            }
        }
        return foundViolations;
    }

    public List<CodeClimate> codeClimate() {
        return CodeClimateTransformer.fromViolations(this.violations());
    }

    public SarifSchema sarif() {
        return SarifTransformer.fromViolations(this.violations());
    }

    private String makeWindowsFriendly(String regularExpression) {
        return regularExpression.replace("/", "(?:/|\\\\)");
    }

    public ViolationsApi withPattern(String regularExpression) {
        this.pattern = this.makeWindowsFriendly(regularExpression);
        return this;
    }
}

