/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.git;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.TreeMap;
import se.bjurr.violations.git.data.DiffsPerFile;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.Git;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.diff.DiffEntry;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.diff.DiffFormatter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.diff.RawText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectReader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevTree;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.CanonicalTreeParser;

public final class ViolationsGitRepo {
    private ViolationsGitRepo() {
    }

    public static DiffsPerFile diff(File repo, String from, String to) throws Exception {
        TreeMap<String, String> patchPerFile = new TreeMap<String, String>();
        Git git = null;
        Repository repository = null;
        try {
            repository = ViolationsGitRepo.getGitRepo(repo);
            ObjectId fromObjectId = ViolationsGitRepo.getObjectId(repository, from);
            ObjectId toObjectId = ViolationsGitRepo.getObjectId(repository, to);
            git = new Git(repository);
            AbstractTreeIterator oldTree = ViolationsGitRepo.getTree(repository, fromObjectId);
            AbstractTreeIterator newTree = ViolationsGitRepo.getTree(repository, toObjectId);
            Object diffs = git.diff().setOldTree(oldTree).setNewTree(newTree).call();
            Iterator iterator = diffs.iterator();
            while (iterator.hasNext()) {
                DiffEntry diff = (DiffEntry)iterator.next();
                String patchString = ViolationsGitRepo.toPatchString(repository, diff);
                String path = diff.getNewPath();
                patchPerFile.put(path, patchString);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not use GIT repo in " + repo.getAbsolutePath(), e);
        }
        finally {
            if (repository != null) {
                repository.close();
            }
            if (git != null) {
                git.close();
            }
        }
        return new DiffsPerFile(patchPerFile);
    }

    private static String toPatchString(Repository repository, DiffEntry diff) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DiffFormatter df = new DiffFormatter(out);){
            df.setRepository(repository);
            df.setContext(0);
            df.format(diff);
            RawText r = new RawText(out.toByteArray());
            r.getLineDelimiter();
        }
        String patchString = out.toString("UTF-8");
        out.reset();
        return patchString;
    }

    private static AbstractTreeIterator getTree(Repository repository, ObjectId objectId) throws Exception {
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit commit = walk.parseCommit(objectId);
            RevTree tree = walk.parseTree(commit.getTree().getId());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            try (ObjectReader reader = repository.newObjectReader();){
                treeParser.reset(reader, tree.getId());
            }
            CanonicalTreeParser canonicalTreeParser = treeParser;
            return canonicalTreeParser;
        }
    }

    private static ObjectId getObjectId(Repository repository, String revstr) throws Exception {
        ObjectId resolved = repository.resolve(revstr);
        if (resolved == null) {
            throw new RuntimeException("Could not resolve \"" + revstr + "\"");
        }
        return resolved;
    }

    private static Repository getGitRepo(File repo) throws IOException {
        FileRepositoryBuilder builder;
        File repoFile = new File(repo.getAbsolutePath());
        File gitRepoFile = new File(repo.getAbsolutePath() + "/.git");
        if (gitRepoFile.exists()) {
            repoFile = gitRepoFile;
        }
        if ((builder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(repoFile)).readEnvironment()).getGitDir() == null) {
            throw new RuntimeException("Did not find a GIT repo in " + repo.getAbsolutePath());
        }
        return builder.build();
    }
}

